/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.UpdateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.views.markers.internal.ActionAddGlobalTask;
import org.eclipse.ui.views.markers.internal.ActionDeleteCompleted;
import org.eclipse.ui.views.markers.internal.ActionMarkCompleted;
import org.eclipse.ui.views.markers.internal.ActionTaskProperties;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.DialogTaskFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldDone;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldPriority;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.TaskFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class TaskView
extends MarkerView {
    private static final String COMPLETION = "completion";
    private final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.taskmarker"};
    private static final String[] TABLE_COLUMN_PROPERTIES = new String[]{"completion", "priority", "message", Util.EMPTY_STRING, Util.EMPTY_STRING, Util.EMPTY_STRING};
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.task";
    private final IField[] VISIBLE_FIELDS = new IField[]{new FieldDone(), new FieldPriority(), new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object object, String string) {
            if (object instanceof ConcreteMarker) {
                IMarker iMarker = ((ConcreteMarker)object).getMarker();
                if (TaskView.COMPLETION.equals(string)) {
                    return iMarker.getAttribute("done", false) ? Boolean.TRUE : Boolean.FALSE;
                }
                if ("priority".equals(string)) {
                    return new Integer(2 - iMarker.getAttribute("priority", 1));
                }
                if ("message".equals(string)) {
                    return iMarker.getAttribute("message", "");
                }
            }
            return null;
        }

        public boolean canModify(Object object, String string) {
            return Util.isEditable(((ConcreteMarker)object).getMarker());
        }

        public void modify(Object object, String string, Object object2) {
            Item item;
            Object object3;
            if (object instanceof Item && (object3 = (item = (Item)object).getData()) instanceof ConcreteMarker) {
                ConcreteMarker concreteMarker = (ConcreteMarker)object3;
                IMarker iMarker = concreteMarker.getMarker();
                try {
                    Object object4 = this.getValue(object3, string);
                    if (object4 != null && !object4.equals(object2)) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        if (TaskView.COMPLETION.equals(string)) {
                            hashMap.put("done", object2);
                        } else if ("priority".equals(string)) {
                            hashMap.put("priority", new Integer(2 - (Integer)object2));
                        } else if ("message".equals(string)) {
                            hashMap.put("message", object2);
                        }
                        if (!hashMap.isEmpty()) {
                            UpdateMarkersOperation updateMarkersOperation = new UpdateMarkersOperation(iMarker, hashMap, MarkerMessages.modifyTask_title, true);
                            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)updateMarkersOperation, null, WorkspaceUndoUtil.getUIInfoAdapter(TaskView.this.getSite().getShell()));
                        }
                    }
                    concreteMarker.refresh();
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof CoreException) {
                        ErrorDialog.openError((Shell)TaskView.this.getSite().getShell(), (String)MarkerMessages.errorModifyingTask, null, (IStatus)((CoreException)executionException.getCause()).getStatus());
                    }
                    IDEWorkbenchPlugin.log(MarkerMessages.errorModifyingTask, executionException);
                }
            }
        }
    };
    private CellEditorActionHandler cellEditorActionHandler;
    private ActionAddGlobalTask addGlobalTaskAction;
    private ActionDeleteCompleted deleteCompletedAction;
    private ActionMarkCompleted markCompletedAction;

    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
        TreeViewer treeViewer = this.getViewer();
        CellEditor[] cellEditorArray = new CellEditor[treeViewer.getTree().getColumnCount()];
        cellEditorArray[0] = new CheckboxCellEditor((Composite)treeViewer.getTree());
        String[] stringArray = new String[]{MarkerMessages.priority_high, MarkerMessages.priority_normal, MarkerMessages.priority_low};
        cellEditorArray[1] = new ComboBoxCellEditor((Composite)treeViewer.getTree(), stringArray, 8);
        TextCellEditor textCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        cellEditorArray[2] = textCellEditor;
        treeViewer.setCellEditors(cellEditorArray);
        treeViewer.setCellModifier(this.cellModifier);
        treeViewer.setColumnProperties(TABLE_COLUMN_PROPERTIES);
        this.cellEditorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.cellEditorActionHandler.addCellEditor((CellEditor)textCellEditor);
        this.cellEditorActionHandler.setCopyAction((IAction)this.copyAction);
        this.cellEditorActionHandler.setPasteAction((IAction)this.pasteAction);
        this.cellEditorActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.cellEditorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
        this.cellEditorActionHandler.setUndoAction((IAction)this.undoAction);
        this.cellEditorActionHandler.setRedoAction((IAction)this.redoAction);
    }

    public void dispose() {
        if (this.cellEditorActionHandler != null) {
            this.cellEditorActionHandler.dispose();
        }
        if (this.markCompletedAction != null) {
            this.markCompletedAction.dispose();
        }
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TAG_DIALOG_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return iDialogSettings2;
    }

    protected void createActions() {
        super.createActions();
        this.addGlobalTaskAction = new ActionAddGlobalTask((IWorkbenchPart)this);
        this.deleteCompletedAction = new ActionDeleteCompleted(this, (ISelectionProvider)this.getViewer());
        this.markCompletedAction = new ActionMarkCompleted((ISelectionProvider)this.getViewer());
        this.propertiesAction = new ActionTaskProperties((IWorkbenchPart)this, (ISelectionProvider)this.getViewer());
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.addGlobalTaskAction);
        iMenuManager.add((IContributionItem)new Separator());
        super.fillContextMenu(iMenuManager);
    }

    protected void fillContextMenuAdditions(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.markCompletedAction);
        iMenuManager.add((IAction)this.deleteCompletedAction);
    }

    protected IField[] getSortingFields() {
        IField[] iFieldArray = new IField[this.VISIBLE_FIELDS.length + this.HIDDEN_FIELDS.length];
        System.arraycopy(this.VISIBLE_FIELDS, 0, iFieldArray, 0, this.VISIBLE_FIELDS.length);
        System.arraycopy(this.HIDDEN_FIELDS, 0, iFieldArray, this.VISIBLE_FIELDS.length, this.HIDDEN_FIELDS.length);
        return iFieldArray;
    }

    protected IField[] getAllFields() {
        return this.getSortingFields();
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected void initToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.addGlobalTaskAction);
        super.initToolBar(iToolBarManager);
    }

    public void setSelection(IStructuredSelection iStructuredSelection, boolean bl) {
        super.setSelection(iStructuredSelection, bl);
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.taskmarker"};
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.task_list_view_context";
    }

    protected DialogMarkerFilter createFiltersDialog() {
        MarkerFilter[] markerFilterArray = this.getUserFilters();
        TaskFilter[] taskFilterArray = new TaskFilter[markerFilterArray.length];
        System.arraycopy(markerFilterArray, 0, taskFilterArray, 0, markerFilterArray.length);
        return new DialogTaskFilter(this.getSite().getShell(), taskFilterArray);
    }

    protected MarkerFilter createFilter(String string) {
        return new TaskFilter(string);
    }

    protected String getSectionTag() {
        return TAG_DIALOG_SECTION;
    }

    String getMarkerEnablementPreferenceName() {
        return "LIMIT_TASKS";
    }

    String getMarkerLimitPreferenceName() {
        return "TASKS_LIMIT";
    }

    String getFiltersPreferenceName() {
        return "TASKS_FILTERS";
    }

    void updateDirectionIndicator(TreeColumn treeColumn) {
    }

    protected String getMarkerName() {
        return MarkerMessages.task_title;
    }

    protected IUndoContext getUndoContext() {
        return WorkspaceUndoUtil.getTasksUndoContext();
    }
}

