/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.FieldCategory;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;
import org.eclipse.ui.views.markers.internal.Util;

public class TypeMarkerGroup
extends MarkerGroup {
    private String name;

    public TypeMarkerGroup(String string) {
        super(null);
        this.name = string;
    }

    protected void createFields() {
        this.field = new FieldCategory();
        this.markerField = new TypeMarkerField();
    }

    public String getId() {
        return "org.eclipse.ui.ide.type";
    }

    public String getTitle() {
        return this.name;
    }

    class TypeMarkerField
    extends MarkerGroup.GroupMarkerField {
        TypeMarkerField() {
        }

        public String getValue(MarkerItem markerItem) {
            if (markerItem.getMarker() != null) {
                IMarker iMarker = markerItem.getMarker();
                if (iMarker == null || !iMarker.exists()) {
                    return MarkerMessages.FieldCategory_Uncategorized;
                }
                String string = MarkerSupportRegistry.getInstance().getCategory(iMarker);
                if (string == null) {
                    String string2;
                    try {
                        string2 = iMarker.getType();
                    }
                    catch (CoreException coreException) {
                        Policy.handle(coreException);
                        return MarkerMessages.FieldCategory_Uncategorized;
                    }
                    MarkerType markerType = MarkerTypesModel.getInstance().getType(string2);
                    string = markerType.getLabel();
                }
                return string;
            }
            return Util.EMPTY_STRING;
        }

        public int compare(MarkerItem markerItem, MarkerItem markerItem2) {
            return this.getValue(markerItem).compareTo(this.getValue(markerItem2));
        }
    }
}

