/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerNode;

public final class Util {
    static String EMPTY_STRING = "";
    static String TWO_LINE_FEED = "\n\n";
    static String LINE_FEED_AND_TAB = "\n\t";
    private static DateFormat format;
    static final MarkerNode[] EMPTY_MARKER_ARRAY;
    static final String TYPE_MARKER_GROUPING_ID = "org.eclipse.ui.ide.type";
    static final int SHORT_DELAY = 100;
    static final int LONG_DELAY = 30000;

    static {
        EMPTY_MARKER_ARRAY = new MarkerNode[0];
    }

    public static String getProperty(String string, IMarker iMarker) {
        if (iMarker == null || !iMarker.exists()) {
            return EMPTY_STRING;
        }
        try {
            Object object = iMarker.getAttribute(string);
            if (object != null) {
                return object.toString();
            }
            return EMPTY_STRING;
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return EMPTY_STRING;
        }
    }

    public static String getCreationTime(long l) {
        if (format == null) {
            format = DateFormat.getDateTimeInstance((int)1, (int)2);
        }
        return format.format(new Date(l));
    }

    public static String getCreationTime(IMarker iMarker) {
        try {
            return Util.getCreationTime(iMarker.getCreationTime());
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
            return EMPTY_STRING;
        }
    }

    public static String getContainerName(IMarker iMarker) {
        Object object;
        if (!iMarker.exists()) {
            return EMPTY_STRING;
        }
        try {
            object = iMarker.getAttribute("org.eclipse.ui.views.markers.path");
            if (object != null) {
                return object.toString();
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
        object = iMarker.getResource().getFullPath();
        int n = object.segmentCount() - 1;
        if (n <= 0) {
            return EMPTY_STRING;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += object.segment(n3).length();
            ++n3;
        }
        if (n > 1) {
            n2 += n - 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(object.segment(n4));
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String getResourceName(IMarker iMarker) {
        if (!iMarker.exists()) {
            return EMPTY_STRING;
        }
        try {
            Object object = iMarker.getAttribute("org.eclipse.ui.views.markers.name");
            if (object != null) {
                return object.toString();
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
        return iMarker.getResource().getName();
    }

    public static boolean isEditable(IMarker iMarker) {
        if (iMarker == null) {
            return false;
        }
        try {
            return iMarker.isSubtypeOf("org.eclipse.core.resources.bookmark") || iMarker.isSubtypeOf("org.eclipse.core.resources.taskmarker") && iMarker.getAttribute("userEditable", true);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static IStatus errorStatus(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        if (string == null) {
            string = EMPTY_STRING;
        }
        return new Status(4, "org.eclipse.ui.ide", 4, string, throwable);
    }

    private Util() {
    }

    public static Image getImage(int n) {
        if (n == 2) {
            return Util.getIDEImage("IMG_OBJS_ERROR_PATH");
        }
        if (n == 1) {
            return Util.getIDEImage("IMG_OBJS_WARNING_PATH");
        }
        if (n == 0) {
            return Util.getIDEImage("IMG_OBJS_INFO_PATH");
        }
        return null;
    }

    private static Image getIDEImage(String string) {
        return JFaceResources.getResources().createImageWithDefault(IDEInternalWorkbenchImages.getImageDescriptor(string));
    }

    public static String getShortContainerName(IMarker iMarker) {
        Object object;
        if (!iMarker.exists()) {
            return EMPTY_STRING;
        }
        try {
            object = iMarker.getAttribute("org.eclipse.ui.views.markers.path");
            if (object != null) {
                return object.toString();
            }
        }
        catch (CoreException coreException) {
            Policy.handle(coreException);
        }
        object = iMarker.getResource();
        int n = object.getType();
        if (n == 4) {
            return object.getName();
        }
        if (n == 8) {
            return MarkerMessages.Util_WorkspaceRoot;
        }
        String string = iMarker.getResource().getProjectRelativePath().removeLastSegments(1).toOSString();
        if (string.trim().length() == 0) {
            return MarkerMessages.Util_ProjectRoot;
        }
        return string;
    }

    static boolean isSingleConcreteSelection(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection != null && iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof MarkerNode) {
            return ((MarkerNode)object).isConcrete();
        }
        return false;
    }

    public static boolean allConcreteSelection(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection != null && iStructuredSelection.size() > 0) {
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                if (((MarkerNode)iterator.next()).isConcrete()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

