/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.FiltersContentProvider;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorAction;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;

public class FilterSelectionAction
extends ResourceNavigatorAction {
    private static final String FILTER_TOOL_TIP = ResourceNavigatorMessages.FilterSelection_toolTip;
    private static final String FILTER_SELECTION_MESSAGE = ResourceNavigatorMessages.FilterSelection_message;
    private static final String FILTER_TITLE_MESSAGE = ResourceNavigatorMessages.FilterSelection_title;

    public FilterSelectionAction(IResourceNavigator iResourceNavigator, String string) {
        super(iResourceNavigator, string);
        this.setToolTipText(FILTER_TOOL_TIP);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.filter_selection_action_context");
        this.setEnabled(true);
    }

    public void run() {
        IResourceNavigator iResourceNavigator = this.getNavigator();
        ResourcePatternFilter resourcePatternFilter = iResourceNavigator.getPatternFilter();
        FiltersContentProvider filtersContentProvider = new FiltersContentProvider(resourcePatternFilter);
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.getShell(), (Object)this.getViewer(), (IStructuredContentProvider)filtersContentProvider, (ILabelProvider)new LabelProvider(), FILTER_SELECTION_MESSAGE);
        listSelectionDialog.setTitle(FILTER_TITLE_MESSAGE);
        listSelectionDialog.setInitialSelections((Object[])filtersContentProvider.getInitialSelections());
        listSelectionDialog.open();
        if (listSelectionDialog.getReturnCode() == 0) {
            Object[] objectArray = listSelectionDialog.getResult();
            String[] stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            resourcePatternFilter.setPatterns(stringArray);
            iResourceNavigator.setFiltersPreference(stringArray);
            Viewer viewer = this.getViewer();
            viewer.getControl().setRedraw(false);
            viewer.refresh();
            viewer.getControl().setRedraw(true);
        }
    }
}

