/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.UpAction;
import org.eclipse.ui.views.navigator.GotoResourceAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;

public class GotoActionGroup
extends ResourceNavigatorActionGroup {
    private BackAction backAction;
    private ForwardAction forwardAction;
    private GoIntoAction goIntoAction;
    private UpAction upAction;
    private GotoResourceAction goToResourceAction;

    public GotoActionGroup(IResourceNavigator iResourceNavigator) {
        super(iResourceNavigator);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (iStructuredSelection.size() == 1) {
            if (ResourceSelectionUtil.allResourcesAreOfType(iStructuredSelection, 2)) {
                iMenuManager.add((IAction)this.goIntoAction);
            } else {
                IProject iProject;
                IStructuredSelection iStructuredSelection2 = ResourceSelectionUtil.allResources(iStructuredSelection, 4);
                if (iStructuredSelection2 != null && !iStructuredSelection2.isEmpty() && (iProject = (IProject)iStructuredSelection2.getFirstElement()).isOpen()) {
                    iMenuManager.add((IAction)this.goIntoAction);
                }
            }
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("goInto", (IAction)this.goIntoAction);
        iActionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        iActionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        iActionBars.setGlobalActionHandler("up", (IAction)this.upAction);
        iActionBars.setGlobalActionHandler("goToResource", (IAction)this.goToResourceAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.backAction);
        iToolBarManager.add((IAction)this.forwardAction);
        iToolBarManager.add((IAction)this.upAction);
    }

    protected void makeActions() {
        FrameList frameList = this.navigator.getFrameList();
        this.goIntoAction = new GoIntoAction(frameList);
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
        this.goToResourceAction = new GotoResourceAction(this.navigator, ResourceNavigatorMessages.GoToResource_label);
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection;
        ActionContext actionContext = this.getContext();
        boolean bl = false;
        if (actionContext != null && (iStructuredSelection = (IStructuredSelection)actionContext.getSelection()).size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IProject) {
                bl = ((IProject)object).isOpen();
            } else if (object instanceof IFolder) {
                bl = true;
            }
        }
        this.goIntoAction.setEnabled(bl);
    }
}

