/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.views.navigator.CollapseAllAction;
import org.eclipse.ui.views.navigator.GotoActionGroup;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.OpenActionGroup;
import org.eclipse.ui.views.navigator.RefactorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;
import org.eclipse.ui.views.navigator.SortAndFilterActionGroup;
import org.eclipse.ui.views.navigator.ToggleLinkingAction;
import org.eclipse.ui.views.navigator.WorkspaceActionGroup;

public class MainActionGroup
extends ResourceNavigatorActionGroup {
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected ImportResourcesAction importAction;
    protected ExportResourcesAction exportAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected GotoActionGroup gotoGroup;
    protected OpenActionGroup openGroup;
    protected RefactorActionGroup refactorGroup;
    protected WorkingSetFilterActionGroup workingSetGroup;
    protected SortAndFilterActionGroup sortAndFilterGroup;
    protected UndoRedoActionGroup undoRedoGroup;
    protected WorkspaceActionGroup workspaceGroup;
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            MainActionGroup.this.handleResourceChanged(iResourceChangeEvent);
        }
    };
    private NewWizardMenu newWizardMenu;
    static /* synthetic */ Class class$0;

    public MainActionGroup(IResourceNavigator iResourceNavigator) {
        super(iResourceNavigator);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.makeSubGroups();
    }

    protected void handleResourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        ActionContext actionContext = this.getContext();
        if (actionContext == null) {
            return;
        }
        final IStructuredSelection iStructuredSelection = (IStructuredSelection)actionContext.getSelection();
        if (!ResourceSelectionUtil.allResourcesAreOfType(iStructuredSelection, 4)) {
            return;
        }
        List list = iStructuredSelection.toList();
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
            if ((iResourceDelta2.getFlags() & 0x84000) != 0 && list.contains(iResourceDelta2.getResource())) {
                this.getNavigator().getSite().getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        MainActionGroup.this.addTaskAction.selectionChanged(iStructuredSelection);
                        MainActionGroup.this.gotoGroup.updateActionBars();
                        MainActionGroup.this.refactorGroup.updateActionBars();
                        MainActionGroup.this.workspaceGroup.updateActionBars();
                    }
                });
            }
            ++n;
        }
    }

    protected void makeActions() {
        IWorkbenchPartSite iWorkbenchPartSite = this.navigator.getSite();
        this.newWizardMenu = new NewWizardMenu(this.navigator.getSite().getWorkbenchWindow());
        this.addBookmarkAction = new AddBookmarkAction((IShellProvider)iWorkbenchPartSite, true);
        this.addTaskAction = new AddTaskAction((IShellProvider)iWorkbenchPartSite);
        this.propertyDialogAction = new PropertyDialogAction((IShellProvider)iWorkbenchPartSite, (ISelectionProvider)this.navigator.getViewer());
        this.importAction = new ImportResourcesAction(this.navigator.getSite().getWorkbenchWindow());
        this.importAction.setDisabledImageDescriptor(this.getImageDescriptor("dtool16/import_wiz.gif"));
        this.importAction.setImageDescriptor(this.getImageDescriptor("etool16/import_wiz.gif"));
        this.exportAction = new ExportResourcesAction(this.navigator.getSite().getWorkbenchWindow());
        this.exportAction.setDisabledImageDescriptor(this.getImageDescriptor("dtool16/export_wiz.gif"));
        this.exportAction.setImageDescriptor(this.getImageDescriptor("etool16/export_wiz.gif"));
        this.collapseAllAction = new CollapseAllAction(this.navigator, ResourceNavigatorMessages.CollapseAllAction_title);
        this.collapseAllAction.setToolTipText(ResourceNavigatorMessages.CollapseAllAction_toolTip);
        this.collapseAllAction.setImageDescriptor(this.getImageDescriptor("elcl16/collapseall.gif"));
        this.toggleLinkingAction = new ToggleLinkingAction(this.navigator, ResourceNavigatorMessages.ToggleLinkingAction_text);
        this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.ToggleLinkingAction_toolTip);
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
    }

    protected void makeSubGroups() {
        this.gotoGroup = new GotoActionGroup(this.navigator);
        this.openGroup = new OpenActionGroup(this.navigator);
        this.refactorGroup = new RefactorActionGroup(this.navigator);
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("changeWorkingSet".equals(string)) {
                    IResourceNavigator iResourceNavigator = MainActionGroup.this.getNavigator();
                    Object object = propertyChangeEvent.getNewValue();
                    if (object instanceof IWorkingSet) {
                        iResourceNavigator.setWorkingSet((IWorkingSet)object);
                    } else if (object == null) {
                        iResourceNavigator.setWorkingSet(null);
                    }
                }
            }
        };
        TreeViewer treeViewer = this.navigator.getViewer();
        Shell shell = treeViewer.getControl().getShell();
        this.workingSetGroup = new WorkingSetFilterActionGroup(shell, iPropertyChangeListener);
        this.workingSetGroup.setWorkingSet(this.navigator.getWorkingSet());
        this.sortAndFilterGroup = new SortAndFilterActionGroup(this.navigator);
        this.workspaceGroup = new WorkspaceActionGroup(this.navigator);
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IUndoContext iUndoContext = (IUndoContext)iWorkspace.getAdapter((Class)clazz);
        this.undoRedoGroup = new UndoRedoActionGroup(this.getNavigator().getSite(), iUndoContext, true);
    }

    public void setContext(ActionContext actionContext) {
        super.setContext(actionContext);
        this.gotoGroup.setContext(actionContext);
        this.openGroup.setContext(actionContext);
        this.refactorGroup.setContext(actionContext);
        this.sortAndFilterGroup.setContext(actionContext);
        this.workspaceGroup.setContext(actionContext);
        this.undoRedoGroup.setContext(actionContext);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        MenuManager menuManager = new MenuManager(ResourceNavigatorMessages.ResourceNavigator_new);
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IContributionItem)this.newWizardMenu);
        this.gotoGroup.fillContextMenu(iMenuManager);
        this.openGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        this.refactorGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.importAction);
        iMenuManager.add((IAction)this.exportAction);
        this.importAction.selectionChanged(iStructuredSelection);
        this.exportAction.selectionChanged(iStructuredSelection);
        iMenuManager.add((IContributionItem)new Separator());
        this.workspaceGroup.fillContextMenu(iMenuManager);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        iMenuManager.add((IContributionItem)new Separator());
        if (iStructuredSelection.size() == 1) {
            this.propertyDialogAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.propertyDialogAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        this.gotoGroup.fillActionBars(iActionBars);
        this.openGroup.fillActionBars(iActionBars);
        this.refactorGroup.fillActionBars(iActionBars);
        this.workingSetGroup.fillActionBars(iActionBars);
        this.sortAndFilterGroup.fillActionBars(iActionBars);
        this.workspaceGroup.fillActionBars(iActionBars);
        this.undoRedoGroup.fillActionBars(iActionBars);
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        iMenuManager.add((IAction)this.toggleLinkingAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IContributionItem)new Separator());
        iToolBarManager.add((IAction)this.collapseAllAction);
        iToolBarManager.add((IAction)this.toggleLinkingAction);
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.propertyDialogAction.setEnabled(iStructuredSelection.size() == 1);
        this.addBookmarkAction.selectionChanged(iStructuredSelection);
        this.addTaskAction.selectionChanged(iStructuredSelection);
        this.gotoGroup.updateActionBars();
        this.openGroup.updateActionBars();
        this.refactorGroup.updateActionBars();
        this.workingSetGroup.updateActionBars();
        this.sortAndFilterGroup.updateActionBars();
        this.workspaceGroup.updateActionBars();
        this.undoRedoGroup.updateActionBars();
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
        this.openGroup.runDefaultAction(iStructuredSelection);
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        this.refactorGroup.handleKeyPressed(keyEvent);
        this.workspaceGroup.handleKeyPressed(keyEvent);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.newWizardMenu.dispose();
        this.collapseAllAction.dispose();
        this.importAction.dispose();
        this.exportAction.dispose();
        this.propertyDialogAction.dispose();
        this.toggleLinkingAction.dispose();
        this.gotoGroup.dispose();
        this.openGroup.dispose();
        this.refactorGroup.dispose();
        this.sortAndFilterGroup.dispose();
        this.workingSetGroup.dispose();
        this.workspaceGroup.dispose();
        this.undoRedoGroup.dispose();
        super.dispose();
    }
}

