/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class NavigatorDragAdapter
extends DragSourceAdapter {
    private static final String CHECK_MOVE_TITLE = ResourceNavigatorMessages.DragAdapter_title;
    private static final String CHECK_DELETE_MESSAGE = ResourceNavigatorMessages.DragAdapter_checkDeleteMessage;
    ISelectionProvider selectionProvider;
    private TransferData lastDataType;

    public NavigatorDragAdapter(ISelectionProvider iSelectionProvider) {
        this.selectionProvider = iSelectionProvider;
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        block11: {
            block10: {
                LocalSelectionTransfer.getInstance().setSelection(null);
                if (!dragSourceEvent.doit) {
                    return;
                }
                if (dragSourceEvent.detail != 2) break block10;
                if (this.lastDataType != null && FileTransfer.getInstance().isSupportedType(this.lastDataType)) {
                    return;
                }
                IResource[] iResourceArray = this.getSelectedResources(3);
                DragSource dragSource = (DragSource)dragSourceEvent.widget;
                Control control = dragSource.getControl();
                Shell shell = control.getShell();
                if (iResourceArray == null || iResourceArray.length == 0) {
                    return;
                }
                ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(shell, CHECK_MOVE_TITLE, CHECK_DELETE_MESSAGE);
                iResourceArray = readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
                int n = 0;
                while (n < iResourceArray.length) {
                    try {
                        iResourceArray[n].delete(3, null);
                    }
                    catch (CoreException coreException) {
                        StatusManager.getManager().handle(coreException, "org.eclipse.ui.ide");
                    }
                    ++n;
                }
                break block11;
            }
            if (dragSourceEvent.detail != 8) break block11;
            IResource[] iResourceArray = this.getSelectedResources(3);
            if (iResourceArray == null) {
                return;
            }
            int n = 0;
            while (n < iResourceArray.length) {
                try {
                    iResourceArray[n].refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(coreException, "org.eclipse.ui.ide");
                }
                ++n;
            }
        }
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        IResource[] iResourceArray = this.getSelectedResources(3);
        if (iResourceArray == null || iResourceArray.length == 0) {
            return;
        }
        this.lastDataType = dragSourceEvent.dataType;
        if (LocalSelectionTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = LocalSelectionTransfer.getInstance().getSelection();
            return;
        }
        if (ResourceTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = iResourceArray;
            return;
        }
        if (!FileTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            return;
        }
        int n = iResourceArray.length;
        int n2 = 0;
        String[] stringArray = new String[n];
        int n3 = 0;
        while (n3 < n) {
            IPath iPath = iResourceArray[n3].getLocation();
            if (iPath != null) {
                stringArray[n2++] = iPath.toOSString();
            }
            ++n3;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < n) {
            String[] stringArray2 = stringArray;
            stringArray = new String[n2];
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n4] = stringArray2[n4];
                ++n4;
            }
        }
        dragSourceEvent.data = stringArray;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        this.lastDataType = null;
        DragSource dragSource = (DragSource)dragSourceEvent.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            dragSourceEvent.doit = false;
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selectionProvider.getSelection();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IFile || e instanceof IFolder) continue;
            dragSourceEvent.doit = false;
            return;
        }
        if (iStructuredSelection.isEmpty()) {
            dragSourceEvent.doit = false;
            return;
        }
        LocalSelectionTransfer.getInstance().setSelection((ISelection)iStructuredSelection);
        dragSourceEvent.doit = true;
    }

    private IResource[] getSelectedResources(int n) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        IResource[] iResourceArray = new IResource[]{};
        ISelection iSelection = this.selectionProvider.getSelection();
        if (!(iSelection instanceof IStructuredSelection) || iSelection.isEmpty()) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            Object e = iterator.next();
            if (!(e instanceof IResource) || ((iResource = (IResource)e).getType() & n) != iResource.getType()) continue;
            arrayList.add(iResource);
        }
        iResourceArray = new IResource[arrayList.size()];
        arrayList.toArray(iResourceArray);
        return iResourceArray;
    }
}

