/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.dialogs.ImportTypeDialog;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class NavigatorDropAdapter
extends PluginDropAdapter
implements IOverwriteQuery {
    private boolean alwaysOverwrite = false;
    private int lastValidOperation = 0;
    static /* synthetic */ Class class$0;

    public NavigatorDropAdapter(StructuredViewer structuredViewer) {
        super(structuredViewer);
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        if (FileTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType) && dropTargetEvent.detail == 16) {
            dropTargetEvent.detail = 1;
        }
        super.dragEnter(dropTargetEvent);
    }

    private IStatus error(String string) {
        return this.error(string, null);
    }

    private IStatus error(String string, Throwable throwable) {
        return new Status(4, "org.eclipse.ui", 0, string, throwable);
    }

    private IContainer getActualTarget(IResource iResource) {
        if (this.getFeedbackEnabled() && (this.getCurrentLocation() == 1 || this.getCurrentLocation() == 2)) {
            return iResource.getParent();
        }
        if (iResource.getType() == 1) {
            return iResource.getParent();
        }
        return (IContainer)iResource;
    }

    private Display getDisplay() {
        return this.getViewer().getControl().getDisplay();
    }

    private IResource[] getSelectedResources() {
        ArrayList arrayList = new ArrayList();
        ISelection iSelection = LocalSelectionTransfer.getInstance().getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                IResource iResource;
                Object e = iterator.next();
                if (e instanceof IResource) {
                    arrayList.add(e);
                    continue;
                }
                if (!(e instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                arrayList.add(iResource);
            }
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }

    private IStatus info(String string) {
        return new Status(1, "org.eclipse.ui", 0, string, null);
    }

    private void mergeStatus(MultiStatus multiStatus, IStatus iStatus) {
        if (!iStatus.isOK()) {
            multiStatus.merge(iStatus);
        }
    }

    private IStatus ok() {
        return new Status(0, "org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_ok, null);
    }

    private void openError(IStatus iStatus) {
        if (iStatus == null) {
            return;
        }
        String string = ResourceNavigatorMessages.DropAdapter_title;
        int n = 6;
        if (!iStatus.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)n);
            return;
        }
        IStatus[] iStatusArray = iStatus.getChildren();
        if (iStatusArray.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)iStatus.getMessage(), null, (IStatus)iStatusArray[0], (int)n);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)string, null, (IStatus)iStatus, (int)n);
    }

    public boolean performDrop(Object object) {
        this.alwaysOverwrite = false;
        if (this.getCurrentTarget() == null || object == null) {
            return false;
        }
        boolean bl = false;
        IStatus iStatus = null;
        IResource[] iResourceArray = null;
        TransferData transferData = this.getCurrentTransfer();
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = this.getSelectedResources();
        } else if (ResourceTransfer.getInstance().isSupportedType(transferData)) {
            iResourceArray = (IResource[])object;
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            iStatus = this.performFileDrop(object);
            bl = iStatus.isOK();
        } else {
            bl = NavigatorDropAdapter.super.performDrop(object);
        }
        if (iResourceArray != null && iResourceArray.length > 0) {
            iStatus = this.getCurrentOperation() == 1 || this.getCurrentOperation() == 4 ? this.performResourceCopy(this.getShell(), iResourceArray) : this.performResourceMove(iResourceArray);
        }
        this.openError(iStatus);
        return bl;
    }

    private IStatus performFileDrop(Object object) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, ResourceNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        final IContainer iContainer = this.getActualTarget((IResource)this.getCurrentTarget());
        final String[] stringArray = (String[])object;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                NavigatorDropAdapter.this.getShell().forceActive();
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(NavigatorDropAdapter.this.getShell());
                int n = 6;
                if (!iContainer.isGroup() && NavigatorDropAdapter.this.getCurrentOperation() != 4) {
                    n |= 1;
                }
                ImportTypeDialog importTypeDialog = new ImportTypeDialog(NavigatorDropAdapter.this.getShell(), n);
                importTypeDialog.setProject(iContainer.getProject());
                int n2 = importTypeDialog.open() == 0 ? importTypeDialog.getSelection() : 0;
                switch (n2) {
                    case 1: {
                        copyFilesAndFoldersOperation.copyFiles(stringArray, iContainer);
                        break;
                    }
                    case 2: {
                        if (importTypeDialog.getVariable() != null) {
                            copyFilesAndFoldersOperation.setRelativeVariable(importTypeDialog.getVariable());
                        }
                        copyFilesAndFoldersOperation.createGroupAndLinks(stringArray, iContainer);
                        break;
                    }
                    case 4: {
                        if (importTypeDialog.getVariable() != null) {
                            copyFilesAndFoldersOperation.setRelativeVariable(importTypeDialog.getVariable());
                        }
                        copyFilesAndFoldersOperation.linkFiles(stringArray, iContainer);
                        break;
                    }
                }
            }
        });
        return multiStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus performResourceCopy(Shell shell, IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer iContainer = this.getActualTarget((IResource)this.getCurrentTarget());
        boolean bl = false;
        if (iContainer.isGroup()) {
            bl = true;
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[0].getType() != 1) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(shell);
        if (bl) {
            copyFilesAndFoldersOperation.setCreateLinks(true);
            copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
            return multiStatus;
        } else {
            boolean bl2 = true;
            int n = 0;
            while (n < iResourceArray.length) {
                if (!iResourceArray[0].isGroup() && !iResourceArray[0].isLinked()) {
                    bl2 = false;
                    break;
                }
                ++n;
            }
            if (!bl2) {
                n = 6;
                if (!iContainer.isGroup() && this.getCurrentOperation() != 4) {
                    n |= 1;
                }
                ImportTypeDialog importTypeDialog = new ImportTypeDialog(this.getShell(), n);
                importTypeDialog.setProject(iContainer.getProject());
                if (importTypeDialog.open() != 0) return multiStatus;
                if (importTypeDialog.getSelection() == 2) {
                    copyFilesAndFoldersOperation.setCreateGroups(true);
                }
                if (importTypeDialog.getSelection() == 4) {
                    copyFilesAndFoldersOperation.setCreateLinks(true);
                }
                if (importTypeDialog.getVariable() != null) {
                    copyFilesAndFoldersOperation.setRelativeVariable(importTypeDialog.getVariable());
                }
                copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
                return multiStatus;
            } else {
                copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
            }
        }
        return multiStatus;
    }

    private IStatus performResourceMove(IResource[] iResourceArray) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 1, ResourceNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(multiStatus, this.validateTarget(this.getCurrentTarget(), this.getCurrentTransfer()));
        IContainer iContainer = this.getActualTarget((IResource)this.getCurrentTarget());
        boolean bl = false;
        if (iContainer.isGroup()) {
            bl = true;
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[0].isGroup() || iResourceArray[0].isLinked()) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            copyFilesAndFoldersOperation.setCreateLinks(true);
            copyFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        } else {
            ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.getShell(), ResourceNavigatorMessages.MoveResourceAction_title, ResourceNavigatorMessages.MoveResourceAction_checkMoveMessage);
            iResourceArray = readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
            MoveFilesAndFoldersOperation moveFilesAndFoldersOperation = new MoveFilesAndFoldersOperation(this.getShell());
            moveFilesAndFoldersOperation.copyResources(iResourceArray, iContainer);
        }
        return multiStatus;
    }

    public String queryOverwrite(String string) {
        if (this.alwaysOverwrite) {
            return "ALL";
        }
        final String[] stringArray = new String[]{"CANCEL"};
        final String string2 = NLS.bind((String)ResourceNavigatorMessages.DropAdapter_overwriteQuery, (Object)string);
        final String[] stringArray2 = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        this.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog messageDialog = new MessageDialog(NavigatorDropAdapter.this.getShell(), ResourceNavigatorMessages.DropAdapter_question, null, string2, 3, stringArray2, 0);
                messageDialog.open();
                int n = messageDialog.getReturnCode();
                String[] stringArray3 = new String[]{"YES", "ALL", "NO", "CANCEL"};
                stringArray[0] = n < 0 ? "CANCEL" : stringArray3[n];
            }
        });
        if (stringArray[0] == "ALL") {
            this.alwaysOverwrite = true;
        }
        return stringArray[0];
    }

    public boolean validateDrop(Object object, int n, TransferData transferData) {
        if (n != 0) {
            this.lastValidOperation = n;
        }
        if (FileTransfer.getInstance().isSupportedType(transferData) && this.lastValidOperation != 1 && this.lastValidOperation != 4) {
            return false;
        }
        if (super.validateDrop(object, n, transferData)) {
            return true;
        }
        return this.validateTarget(object, transferData).isOK();
    }

    private IStatus validateTarget(Object object, TransferData transferData) {
        if (!(object instanceof IResource)) {
            return this.info(ResourceNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource iResource = (IResource)object;
        if (!iResource.isAccessible()) {
            return this.error(ResourceNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer iContainer = this.getActualTarget(iResource);
        if (iContainer.getType() == 8) {
            return this.error(ResourceNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String string = null;
        if (LocalSelectionTransfer.getInstance().isSupportedType(transferData)) {
            IResource[] iResourceArray = this.getSelectedResources();
            if (iResourceArray.length == 0) {
                string = ResourceNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else if (this.lastValidOperation == 1 || this.lastValidOperation == 4) {
                CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
                if (copyFilesAndFoldersOperation.validateDestination(iContainer, iResourceArray) != null) {
                    copyFilesAndFoldersOperation.setCreateGroups(true);
                    string = copyFilesAndFoldersOperation.validateDestination(iContainer, iResourceArray);
                }
            } else {
                MoveFilesAndFoldersOperation moveFilesAndFoldersOperation = new MoveFilesAndFoldersOperation(this.getShell());
                if (((CopyFilesAndFoldersOperation)moveFilesAndFoldersOperation).validateDestination(iContainer, iResourceArray) != null) {
                    moveFilesAndFoldersOperation.setCreateGroups(true);
                    string = ((CopyFilesAndFoldersOperation)moveFilesAndFoldersOperation).validateDestination(iContainer, iResourceArray);
                    if (string == null) {
                        this.lastValidOperation = 1;
                    }
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferData)) {
            String[] stringArray = (String[])FileTransfer.getInstance().nativeToJava(transferData);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            CopyFilesAndFoldersOperation copyFilesAndFoldersOperation = new CopyFilesAndFoldersOperation(this.getShell());
            string = copyFilesAndFoldersOperation.validateImportDestination(iContainer, stringArray);
        }
        if (string != null) {
            return this.error(string);
        }
        return this.ok();
    }
}

