/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class NavigatorFrameSource
extends TreeViewerFrameSource {
    private ResourceNavigator navigator;

    public NavigatorFrameSource(ResourceNavigator resourceNavigator) {
        super((AbstractTreeViewer)resourceNavigator.getTreeViewer());
        this.navigator = resourceNavigator;
    }

    protected TreeFrame createFrame(Object object) {
        TreeFrame treeFrame = super.createFrame(object);
        treeFrame.setName(this.navigator.getFrameName(object));
        treeFrame.setToolTipText(this.navigator.getFrameToolTipText(object));
        return treeFrame;
    }

    protected void frameChanged(TreeFrame treeFrame) {
        IResource iResource = (IResource)treeFrame.getInput();
        IProject iProject = iResource.getProject();
        if (iProject != null && !iProject.isOpen()) {
            MessageDialog.openInformation((Shell)this.navigator.getViewSite().getShell(), (String)ResourceNavigatorMessages.NavigatorFrameSource_closedProject_title, (String)NLS.bind((String)ResourceNavigatorMessages.NavigatorFrameSource_closedProject_message, (Object)iProject.getName()));
            this.navigator.getFrameList().back();
        } else {
            super.frameChanged(treeFrame);
            this.navigator.updateTitle();
        }
    }
}

