/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;

public class OpenActionGroup
extends ResourceNavigatorActionGroup {
    private OpenFileAction openFileAction;
    public static final String OPEN_WITH_ID = "org.eclipse.ui.OpenWithSubMenu";

    public OpenActionGroup(IResourceNavigator iResourceNavigator) {
        super(iResourceNavigator);
    }

    protected void makeActions() {
        this.openFileAction = new OpenFileAction(this.navigator.getSite().getPage());
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        boolean bl;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl2 = !iStructuredSelection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(iStructuredSelection, 7);
        boolean bl3 = bl = !iStructuredSelection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(iStructuredSelection, 1);
        if (bl) {
            this.openFileAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.openFileAction);
            this.fillOpenWithMenu(iMenuManager, iStructuredSelection);
        }
        if (bl2) {
            this.addNewWindowAction(iMenuManager, iStructuredSelection);
        }
    }

    private void fillOpenWithMenu(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IFile)) {
            return;
        }
        MenuManager menuManager = new MenuManager(ResourceNavigatorMessages.ResourceNavigator_openWith, OPEN_WITH_ID);
        menuManager.add((IContributionItem)new OpenWithMenu(this.navigator.getSite().getPage(), (IAdaptable)((IFile)object)));
        iMenuManager.add((IContributionItem)menuManager);
    }

    private void addNewWindowAction(IMenuManager iMenuManager, IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IContainer)) {
            return;
        }
        if (object instanceof IProject && !((IProject)object).isOpen()) {
            return;
        }
        iMenuManager.add((IAction)new OpenInNewWindowAction(this.navigator.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)object)));
    }

    public void runDefaultAction(IStructuredSelection iStructuredSelection) {
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IFile) {
            this.openFileAction.selectionChanged(iStructuredSelection);
            this.openFileAction.run();
        }
    }
}

