/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.views.navigator.CopyAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.PasteAction;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMoveAction;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;

public class RefactorActionGroup
extends ResourceNavigatorActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private ResourceNavigatorRenameAction renameAction;
    private ResourceNavigatorMoveAction moveAction;
    private TextActionHandler textActionHandler;

    public RefactorActionGroup(IResourceNavigator iResourceNavigator) {
        super(iResourceNavigator);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = !iStructuredSelection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(iStructuredSelection, 7);
        this.copyAction.selectionChanged(iStructuredSelection);
        iMenuManager.add((IAction)this.copyAction);
        this.pasteAction.selectionChanged(iStructuredSelection);
        iMenuManager.add((IAction)this.pasteAction);
        if (bl) {
            this.deleteAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.deleteAction);
            this.moveAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.moveAction);
            this.renameAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        this.textActionHandler = new TextActionHandler(iActionBars);
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        iActionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        iActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            keyEvent.doit = false;
        } else if (keyEvent.keyCode == 0x100000B && keyEvent.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            keyEvent.doit = false;
        }
    }

    protected void makeActions() {
        TreeViewer treeViewer = this.navigator.getViewer();
        IWorkbenchPartSite iWorkbenchPartSite = this.navigator.getSite();
        this.clipboard = new Clipboard(iWorkbenchPartSite.getShell().getDisplay());
        this.pasteAction = new PasteAction(iWorkbenchPartSite.getShell(), this.clipboard);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.copyAction = new CopyAction(iWorkbenchPartSite.getShell(), this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.moveAction = new ResourceNavigatorMoveAction(iWorkbenchPartSite.getShell(), (StructuredViewer)treeViewer);
        this.renameAction = new ResourceNavigatorRenameAction(iWorkbenchPartSite.getShell(), treeViewer);
        this.deleteAction = new DeleteResourceAction((IShellProvider)iWorkbenchPartSite);
        this.deleteAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(iStructuredSelection);
        this.pasteAction.selectionChanged(iStructuredSelection);
        this.deleteAction.selectionChanged(iStructuredSelection);
        this.moveAction.selectionChanged(iStructuredSelection);
        this.renameAction.selectionChanged(iStructuredSelection);
    }
}

