/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.FiltersContentProvider;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.MainActionGroup;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;
import org.eclipse.ui.views.navigator.NavigatorFrameSource;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourcePatternFilter;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ResourceNavigator
extends ViewPart
implements ISetSelectionTarget,
IResourceNavigator {
    private TreeViewer viewer;
    private IDialogSettings settings;
    private IMemento memento;
    private FrameList frameList;
    private ResourceNavigatorActionGroup actionGroup;
    private ResourcePatternFilter patternFilter = new ResourcePatternFilter();
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private boolean linkingEnabled;
    private boolean dragDetected;
    private Listener dragDetectListener;
    private IWorkingSet workingSet;
    private boolean emptyWorkingSet = false;
    private static final String STORE_SECTION = "ResourceNavigator";
    private static final String STORE_SORT_TYPE = "ResourceViewer.STORE_SORT_TYPE";
    private static final String STORE_WORKING_SET = "ResourceWorkingSetFilter.STORE_WORKING_SET";
    public static final String NAVIGATOR_VIEW_HELP_ID = "org.eclipse.ui.resource_view_context";
    private boolean linkScheduled = false;
    private static final String TAG_SORTER = "sorter";
    private static final String TAG_FILTERS = "filters";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_EXPANDED = "expanded";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_IS_ENABLED = "isEnabled";
    private static final String TAG_PATH = "path";
    private static final String TAG_CURRENT_FRAME = "currentFrame";
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart) {
                ResourceNavigator.this.editorActivated((IEditorPart)iWorkbenchPart);
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof IEditorPart) {
                ResourceNavigator.this.editorActivated((IEditorPart)iWorkbenchPart);
            }
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getProperty();
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            if ("workingSetRemove".equals(string) && object2 == ResourceNavigator.this.workingSet) {
                ResourceNavigator.this.setWorkingSet(null);
            } else if ("workingSetNameChange".equals(string) && object == ResourceNavigator.this.workingSet) {
                ResourceNavigator.this.updateTitle();
            } else if ("workingSetContentChange".equals(string) && object == ResourceNavigator.this.workingSet) {
                if (ResourceNavigator.this.workingSet.isAggregateWorkingSet() && ResourceNavigator.this.workingSet.isEmpty()) {
                    if (!ResourceNavigator.this.emptyWorkingSet) {
                        ResourceNavigator.this.emptyWorkingSet = true;
                        ResourceNavigator.this.workingSetFilter.setWorkingSet(null);
                    }
                } else if (ResourceNavigator.this.emptyWorkingSet) {
                    ResourceNavigator.this.emptyWorkingSet = false;
                    ResourceNavigator.this.workingSetFilter.setWorkingSet(ResourceNavigator.this.workingSet);
                }
                ResourceNavigator.this.getViewer().refresh();
            }
        }
    };
    private CollapseAllHandler collapseAllHandler;
    private OpenAndLinkWithEditorHelper openAndLinkWithEditorHelper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public ResourceNavigator() {
        IDialogSettings iDialogSettings = this.getPlugin().getDialogSettings();
        this.settings = iDialogSettings.getSection(STORE_SECTION);
        if (this.settings == null) {
            this.settings = iDialogSettings.addNewSection(STORE_SECTION);
        }
        this.initLinkingEnabled();
    }

    private StructuredSelection convertSelection(ISelection iSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
        }
        return new StructuredSelection(arrayList);
    }

    public void createPartControl(Composite composite) {
        TreeViewer treeViewer;
        this.viewer = treeViewer = this.createViewer(composite);
        if (this.memento != null) {
            this.restoreFilters();
            this.restoreLinkingEnabled();
        }
        this.frameList = this.createFrameList();
        this.initDragAndDrop();
        this.updateTitle();
        this.initContextMenu();
        this.initResourceComparator();
        this.initWorkingSetFilter();
        treeViewer.setInput((Object)this.getInitialInput());
        this.makeActions();
        this.getActionGroup().fillActionBars(this.getViewSite().getActionBars());
        this.updateActionBars((IStructuredSelection)treeViewer.getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)treeViewer);
        this.getSite().getPage().addPartListener(this.partListener);
        IWorkingSetManager iWorkingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
        iWorkingSetManager.addPropertyChangeListener(this.propertyChangeListener);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp(treeViewer.getControl(), this.getHelpContextId());
    }

    protected String getHelpContextId() {
        return NAVIGATOR_VIEW_HELP_ID;
    }

    protected void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ResourceNavigator.this.fillContextMenu(iMenuManager);
            }
        });
        TreeViewer treeViewer = this.getTreeViewer();
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)treeViewer);
    }

    protected TreeViewer createViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite, 770);
        treeViewer.setUseHashlookup(true);
        this.initContentProvider(treeViewer);
        this.initLabelProvider(treeViewer);
        this.initFilters(treeViewer);
        this.initListeners(treeViewer);
        return treeViewer;
    }

    protected void initContentProvider(TreeViewer treeViewer) {
        treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
    }

    protected void initLabelProvider(TreeViewer treeViewer) {
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), this.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    protected void initFilters(TreeViewer treeViewer) {
        treeViewer.addFilter((ViewerFilter)this.patternFilter);
        treeViewer.addFilter((ViewerFilter)this.workingSetFilter);
    }

    private void initLinkingEnabled() {
        String string = this.settings.get("LINK_NAVIGATOR_TO_EDITOR");
        if (string != null) {
            this.linkingEnabled = string.equals("true");
            return;
        }
        this.linkingEnabled = PlatformUI.getPreferenceStore().getBoolean("LINK_NAVIGATOR_TO_EDITOR");
    }

    protected void initListeners(final TreeViewer treeViewer) {
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ResourceNavigator.this.handleSelectionChanged(selectionChangedEvent);
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ResourceNavigator.this.handleDoubleClick(doubleClickEvent);
            }
        });
        this.openAndLinkWithEditorHelper = new OpenAndLinkWithEditorHelper((StructuredViewer)treeViewer){

            protected void activate(ISelection iSelection) {
                Object object = ResourceNavigator.getSingleElement(iSelection);
                if (object instanceof IFile) {
                    FileEditorInput fileEditorInput = new FileEditorInput((IFile)object);
                    IWorkbenchPage iWorkbenchPage = ResourceNavigator.this.getSite().getPage();
                    IEditorPart iEditorPart = iWorkbenchPage.findEditor((IEditorInput)fileEditorInput);
                    if (iEditorPart != null) {
                        iWorkbenchPage.activate((IWorkbenchPart)iEditorPart);
                    }
                }
            }

            protected void linkToEditor(ISelection iSelection) {
                if (!ResourceNavigator.this.linkScheduled) {
                    ResourceNavigator.this.linkScheduled = true;
                    ResourceNavigator.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this, treeViewer){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ TreeViewer val$viewer;
                        {
                            this.this$1 = var1_1;
                            this.val$viewer = treeViewer;
                        }

                        public void run() {
                            ResourceNavigator.access$5(6.access$0(this.this$1), false);
                            if (this.val$viewer == null || this.val$viewer.getControl() == null || this.val$viewer.getControl().isDisposed()) {
                                return;
                            }
                            if (!ResourceNavigator.access$6(6.access$0(this.this$1))) {
                                6.access$0(this.this$1).linkToEditor(this.val$viewer.getSelection());
                            }
                        }
                    });
                }
            }

            protected void open(ISelection iSelection, boolean bl) {
                ResourceNavigator.this.handleOpen(iSelection);
            }

            static /* synthetic */ ResourceNavigator access$0(6 var0) {
                return var0.ResourceNavigator.this;
            }
        };
        treeViewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                ResourceNavigator.this.handleKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ResourceNavigator.this.handleKeyReleased(keyEvent);
            }
        });
        this.openAndLinkWithEditorHelper.setLinkWithEditor(this.linkingEnabled);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        IWorkingSetManager iWorkingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
        iWorkingSetManager.removePropertyChangeListener(this.propertyChangeListener);
        if (this.collapseAllHandler != null) {
            this.collapseAllHandler.dispose();
        }
        if (this.getActionGroup() != null) {
            this.getActionGroup().dispose();
        }
        Control control = this.viewer.getControl();
        if (this.dragDetectListener != null && control != null && !control.isDisposed()) {
            control.removeListener(29, this.dragDetectListener);
        }
        super.dispose();
    }

    protected void editorActivated(IEditorPart iEditorPart) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        IFile iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
        if (iFile != null) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)iFile);
            if (this.getTreeViewer().getSelection().equals(structuredSelection)) {
                this.getTreeViewer().getTree().showSelection();
            } else {
                this.getTreeViewer().setSelection((ISelection)structuredSelection, true);
            }
        }
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        this.getActionGroup().setContext(new ActionContext((ISelection)iStructuredSelection));
        this.getActionGroup().fillContextMenu(iMenuManager);
    }

    public FrameList getFrameList() {
        return this.frameList;
    }

    protected IAdaptable getInitialInput() {
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable != null) {
            IResource iResource = null;
            if (iAdaptable instanceof IResource) {
                iResource = (IResource)iAdaptable;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null) {
                switch (iResource.getType()) {
                    case 1: {
                        return iResource.getParent();
                    }
                    case 2: 
                    case 4: 
                    case 8: {
                        return iResource;
                    }
                }
            }
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public ResourcePatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSetFilter.getWorkingSet();
    }

    public AbstractUIPlugin getPlugin() {
        return IDEWorkbenchPlugin.getDefault();
    }

    public ResourceSorter getSorter() {
        ViewerSorter viewerSorter = this.getTreeViewer().getSorter();
        if (viewerSorter instanceof ResourceSorter) {
            return (ResourceSorter)viewerSorter;
        }
        return null;
    }

    public ResourceComparator getComparator() {
        ViewerComparator viewerComparator = this.getTreeViewer().getComparator();
        if (viewerComparator instanceof ResourceComparator) {
            return (ResourceComparator)viewerComparator;
        }
        return null;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    public Shell getShell() {
        return this.getViewSite().getShell();
    }

    protected String getStatusLineMessage(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IResource) {
                return ((IResource)object).getFullPath().makeRelative().toString();
            }
            return ResourceNavigatorMessages.ResourceNavigator_oneItemSelected;
        }
        if (iStructuredSelection.size() > 1) {
            return NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_statusLine, (Object)String.valueOf(iStructuredSelection.size()));
        }
        return "";
    }

    String getFrameName(Object object) {
        if (object instanceof IResource) {
            return ((IResource)object).getName();
        }
        String string = ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(object);
        if (string == null) {
            return "";
        }
        return string;
    }

    String getFrameToolTipText(Object object) {
        if (object instanceof IResource) {
            IPath iPath = ((IResource)object).getFullPath();
            if (iPath.isRoot()) {
                return ResourceNavigatorMessages.ResourceManager_toolTip;
            }
            return iPath.makeRelative().toString();
        }
        String string = ((ILabelProvider)this.getTreeViewer().getLabelProvider()).getText(object);
        if (string == null) {
            return "";
        }
        return string;
    }

    protected void handleOpen(OpenEvent openEvent) {
        this.handleOpen(openEvent.getSelection());
    }

    protected void handleOpen(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.getActionGroup().runDefaultAction((IStructuredSelection)iSelection);
        }
    }

    protected void handleDoubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer.isExpandable(object)) {
            treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
        } else if (iStructuredSelection.size() == 1 && object instanceof IResource && ((IResource)object).getType() == 4) {
            OpenResourceAction openResourceAction = new OpenResourceAction((IShellProvider)this.getSite());
            openResourceAction.selectionChanged((IStructuredSelection)treeViewer.getSelection());
            if (openResourceAction.isEnabled()) {
                openResourceAction.run();
            }
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateStatusLine(iStructuredSelection);
        this.updateActionBars(iStructuredSelection);
        this.dragDetected = false;
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        this.getActionGroup().handleKeyPressed(keyEvent);
    }

    protected void handleKeyReleased(KeyEvent keyEvent) {
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    protected void initDragAndDrop() {
        int n = 7;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.addDragSupport(n, transferArray, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)treeViewer));
        NavigatorDropAdapter navigatorDropAdapter = new NavigatorDropAdapter((StructuredViewer)treeViewer);
        navigatorDropAdapter.setFeedbackEnabled(false);
        treeViewer.addDropSupport(n | 0x10, transferArray, (DropTargetListener)navigatorDropAdapter);
        this.dragDetectListener = new Listener(){

            public void handleEvent(Event event) {
                ResourceNavigator.this.dragDetected = true;
            }
        };
        treeViewer.getControl().addListener(29, this.dragDetectListener);
    }

    protected FrameList createFrameList() {
        NavigatorFrameSource navigatorFrameSource = new NavigatorFrameSource(this);
        FrameList frameList = new FrameList(navigatorFrameSource);
        navigatorFrameSource.connectTo(frameList);
        return frameList;
    }

    protected void initResourceSorter() {
        int n = 1;
        try {
            int n2 = 0;
            if (this.memento != null) {
                String string = this.memento.getString(TAG_SORTER);
                if (string != null) {
                    n2 = new Integer(string);
                }
            } else {
                n2 = this.settings.getInt(STORE_SORT_TYPE);
            }
            if (n2 == 1 || n2 == 2) {
                n = n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setSorter(new ResourceSorter(n));
    }

    protected void initResourceComparator() {
        int n = 1;
        try {
            int n2 = 0;
            if (this.memento != null) {
                String string = this.memento.getString(TAG_SORTER);
                if (string != null) {
                    n2 = new Integer(string);
                }
            } else {
                n2 = this.settings.getInt(STORE_SORT_TYPE);
            }
            if (n2 == 1 || n2 == 2) {
                n = n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        this.setComparator(new ResourceComparator(n));
    }

    protected void initWorkingSetFilter() {
        String string = this.settings.get(STORE_WORKING_SET);
        IWorkingSet iWorkingSet = null;
        if (string != null && !string.equals("")) {
            IWorkingSetManager iWorkingSetManager = this.getPlugin().getWorkbench().getWorkingSetManager();
            iWorkingSet = iWorkingSetManager.getWorkingSet(string);
        } else if (PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT")) {
            iWorkingSet = this.getSite().getPage().getAggregateWorkingSet();
        }
        if (iWorkingSet != null) {
            this.workingSetFilter.setWorkingSet(iWorkingSet);
            this.internalSetWorkingSet(iWorkingSet);
        }
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    protected void linkToEditor(IStructuredSelection iStructuredSelection) {
        this.linkToEditor((ISelection)iStructuredSelection);
    }

    protected void linkToEditor(ISelection iSelection) {
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object object = ResourceNavigator.getSingleElement(iSelection);
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            IEditorPart iEditorPart = ResourceUtil.findEditor(iWorkbenchPage, iFile);
            if (iEditorPart != null) {
                iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
                return;
            }
        }
    }

    protected void makeActions() {
        MainActionGroup mainActionGroup = new MainActionGroup(this);
        this.setActionGroup(mainActionGroup);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService iHandlerService = (IHandlerService)iWorkbenchPartSite.getService((Class)clazz);
        iHandlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)mainActionGroup.toggleLinkingAction));
        this.collapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.viewer);
        iHandlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.collapseAllHandler);
    }

    private void restoreFilters() {
        IMemento iMemento = this.memento.getChild(TAG_FILTERS);
        if (iMemento != null) {
            IMemento[] iMementoArray = iMemento.getChildren(TAG_FILTER);
            if (iMementoArray.length > 0 && iMementoArray[0].getString(TAG_IS_ENABLED) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n = 0;
                while (n < iMementoArray.length) {
                    if (iMementoArray[n].getString(TAG_IS_ENABLED).equals(String.valueOf(true))) {
                        arrayList.add(iMementoArray[n].getString(TAG_ELEMENT));
                    } else {
                        arrayList2.add(iMementoArray[n].getString(TAG_ELEMENT));
                    }
                    ++n;
                }
                List list = FiltersContentProvider.getDefaultFilters();
                String[] stringArray = list.iterator();
                while (stringArray.hasNext()) {
                    String string = (String)stringArray.next();
                    if (arrayList.contains(string) || arrayList2.contains(string)) continue;
                    arrayList.add(string);
                }
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                this.getPatternFilter().setPatterns(stringArray);
            } else {
                String[] stringArray = new String[iMementoArray.length];
                int n = 0;
                while (n < iMementoArray.length) {
                    stringArray[n] = iMementoArray[n].getString(TAG_ELEMENT);
                    ++n;
                }
                this.getPatternFilter().setPatterns(stringArray);
            }
        } else {
            this.getPatternFilter().setPatterns(new String[0]);
        }
    }

    protected void restoreState(IMemento iMemento) {
        TreeViewer treeViewer = this.getTreeViewer();
        IMemento iMemento2 = iMemento.getChild(TAG_CURRENT_FRAME);
        if (iMemento2 != null) {
            TreeFrame treeFrame = new TreeFrame((AbstractTreeViewer)treeViewer);
            treeFrame.restoreState(iMemento2);
            treeFrame.setName(this.getFrameName(treeFrame.getInput()));
            treeFrame.setToolTipText(this.getFrameToolTipText(treeFrame.getInput()));
            treeViewer.setSelection((ISelection)new StructuredSelection(treeFrame.getInput()));
            this.frameList.gotoFrame(treeFrame);
        } else {
            IResource iResource;
            int n;
            IMemento[] iMementoArray;
            ArrayList<IResource> arrayList;
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IMemento iMemento3 = iMemento.getChild(TAG_EXPANDED);
            if (iMemento3 != null) {
                arrayList = new ArrayList<IResource>();
                iMementoArray = iMemento3.getChildren(TAG_ELEMENT);
                n = 0;
                while (n < iMementoArray.length) {
                    iResource = iWorkspaceRoot.findMember(iMementoArray[n].getString(TAG_PATH));
                    if (iResource != null) {
                        arrayList.add(iResource);
                    }
                    ++n;
                }
                treeViewer.setExpandedElements(arrayList.toArray());
            }
            if ((iMemento3 = iMemento.getChild(TAG_SELECTION)) != null) {
                arrayList = new ArrayList();
                iMementoArray = iMemento3.getChildren(TAG_ELEMENT);
                n = 0;
                while (n < iMementoArray.length) {
                    iResource = iWorkspaceRoot.findMember(iMementoArray[n].getString(TAG_PATH));
                    if (iResource != null) {
                        arrayList.add(iResource);
                    }
                    ++n;
                }
                treeViewer.setSelection((ISelection)new StructuredSelection(arrayList));
            }
        }
    }

    private void restoreLinkingEnabled() {
        Integer n = this.memento.getInteger("LINK_NAVIGATOR_TO_EDITOR");
        if (n != null) {
            this.linkingEnabled = n != 0;
        }
    }

    public void saveState(IMemento iMemento) {
        IMemento iMemento2;
        Object[] objectArray;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer == null) {
            if (this.memento != null) {
                iMemento.putMemento(this.memento);
            }
            return;
        }
        if (this.getComparator() != null) {
            iMemento.putInteger(TAG_SORTER, this.getComparator().getCriteria());
        } else if (this.getSorter() != null) {
            iMemento.putInteger(TAG_SORTER, this.getSorter().getCriteria());
        }
        String[] stringArray = this.getPatternFilter().getPatterns();
        List<String> list = Arrays.asList(stringArray);
        List list2 = FiltersContentProvider.getDefinedFilters();
        IMemento iMemento3 = iMemento.createChild(TAG_FILTERS);
        Object object = list2.iterator();
        while (object.hasNext()) {
            objectArray = (Object[])object.next();
            iMemento2 = iMemento3.createChild(TAG_FILTER);
            iMemento2.putString(TAG_ELEMENT, (String)objectArray);
            iMemento2.putString(TAG_IS_ENABLED, String.valueOf(list.contains(objectArray)));
        }
        if (this.frameList.getCurrentIndex() > 0) {
            object = (TreeFrame)this.frameList.getCurrentFrame();
            objectArray = iMemento.createChild(TAG_CURRENT_FRAME);
            ((TreeFrame)object).saveState((IMemento)objectArray);
        } else {
            object = treeViewer.getVisibleExpandedElements();
            if (((Object[])object).length > 0) {
                objectArray = iMemento.createChild(TAG_EXPANDED);
                int n = 0;
                while (n < ((Object)object).length) {
                    if (object[n] instanceof IResource) {
                        IMemento iMemento4 = objectArray.createChild(TAG_ELEMENT);
                        iMemento4.putString(TAG_PATH, ((IResource)object[n]).getFullPath().toString());
                    }
                    ++n;
                }
            }
            if ((objectArray = ((IStructuredSelection)treeViewer.getSelection()).toArray()).length > 0) {
                iMemento2 = iMemento.createChild(TAG_SELECTION);
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] instanceof IResource) {
                        IMemento iMemento5 = iMemento2.createChild(TAG_ELEMENT);
                        iMemento5.putString(TAG_PATH, ((IResource)objectArray[n]).getFullPath().toString());
                    }
                    ++n;
                }
            }
        }
        this.saveLinkingEnabled(iMemento);
    }

    private void saveLinkingEnabled(IMemento iMemento) {
        iMemento.putInteger("LINK_NAVIGATOR_TO_EDITOR", this.linkingEnabled ? 1 : 0);
    }

    public void selectReveal(ISelection iSelection) {
        StructuredSelection structuredSelection = this.convertSelection(iSelection);
        if (!structuredSelection.isEmpty()) {
            this.getViewer().getControl().setRedraw(false);
            this.getViewer().setSelection((ISelection)structuredSelection, true);
            this.getViewer().getControl().setRedraw(true);
        }
    }

    public void setFiltersPreference(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        this.getPlugin().getPreferenceStore().setValue("resourceFilters", stringBuffer.toString());
        IPreferenceStore iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("resourceFilters");
        if (string.length() > 0) {
            iPreferenceStore.setValue("resourceFilters", "");
        }
    }

    public void setFocus() {
        this.getTreeViewer().getTree().setFocus();
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
    }

    public void setLinkingEnabled(boolean bl) {
        IEditorPart iEditorPart;
        this.linkingEnabled = bl;
        this.settings.put("LINK_NAVIGATOR_TO_EDITOR", bl);
        if (bl && (iEditorPart = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(iEditorPart);
        }
        this.openAndLinkWithEditorHelper.setLinkWithEditor(bl);
    }

    public void setSorter(ResourceSorter resourceSorter) {
        TreeViewer treeViewer = this.getTreeViewer();
        ViewerSorter viewerSorter = treeViewer.getSorter();
        treeViewer.getControl().setRedraw(false);
        if (viewerSorter == resourceSorter) {
            treeViewer.refresh();
        } else {
            treeViewer.setSorter((ViewerSorter)resourceSorter);
        }
        treeViewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, resourceSorter.getCriteria());
        this.updateActionBars((IStructuredSelection)treeViewer.getSelection());
    }

    public void setComparator(ResourceComparator resourceComparator) {
        TreeViewer treeViewer = this.getTreeViewer();
        ViewerComparator viewerComparator = treeViewer.getComparator();
        treeViewer.getControl().setRedraw(false);
        if (viewerComparator == resourceComparator) {
            treeViewer.refresh();
        } else {
            treeViewer.setComparator((ViewerComparator)resourceComparator);
        }
        treeViewer.getControl().setRedraw(true);
        this.settings.put(STORE_SORT_TYPE, resourceComparator.getCriteria());
        this.updateActionBars((IStructuredSelection)treeViewer.getSelection());
    }

    public void setWorkingSet(IWorkingSet iWorkingSet) {
        TreeViewer treeViewer = this.getTreeViewer();
        Object[] objectArray = treeViewer.getExpandedElements();
        ISelection iSelection = treeViewer.getSelection();
        boolean bl = this.internalSetWorkingSet(iWorkingSet);
        this.workingSetFilter.setWorkingSet(this.emptyWorkingSet ? null : iWorkingSet);
        if (iWorkingSet != null) {
            this.settings.put(STORE_WORKING_SET, iWorkingSet.getName());
        } else {
            this.settings.put(STORE_WORKING_SET, "");
        }
        this.updateTitle();
        if (bl) {
            treeViewer.refresh();
        }
        treeViewer.setExpandedElements(objectArray);
        if (!iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            treeViewer.reveal(iStructuredSelection.getFirstElement());
        }
    }

    private boolean internalSetWorkingSet(IWorkingSet iWorkingSet) {
        boolean bl = !Util.equals((Object)this.workingSet, (Object)iWorkingSet);
        this.workingSet = iWorkingSet;
        this.emptyWorkingSet = iWorkingSet != null && iWorkingSet.isAggregateWorkingSet() && iWorkingSet.isEmpty();
        return bl;
    }

    protected void updateActionBars(IStructuredSelection iStructuredSelection) {
        ResourceNavigatorActionGroup resourceNavigatorActionGroup = this.getActionGroup();
        if (resourceNavigatorActionGroup != null) {
            resourceNavigatorActionGroup.setContext(new ActionContext((ISelection)iStructuredSelection));
            resourceNavigatorActionGroup.updateActionBars();
        }
    }

    protected void updateStatusLine(IStructuredSelection iStructuredSelection) {
        String string = this.getStatusLineMessage(iStructuredSelection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    public void updateTitle() {
        Object object = this.getViewer().getInput();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkingSet iWorkingSet = this.workingSetFilter.getWorkingSet();
        if (object == null || object.equals(iWorkspace) || object.equals(iWorkspace.getRoot())) {
            this.setContentDescription("");
            if (iWorkingSet != null) {
                this.setTitleToolTip(NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_workingSetToolTip, (Object)iWorkingSet.getLabel()));
            } else {
                this.setTitleToolTip("");
            }
        } else {
            ILabelProvider iLabelProvider = (ILabelProvider)this.getTreeViewer().getLabelProvider();
            String string = this.getFrameToolTipText(object);
            String string2 = iLabelProvider.getText(object);
            if (string2 != null) {
                this.setContentDescription(string2);
            }
            if (iWorkingSet != null) {
                this.setTitleToolTip(NLS.bind((String)ResourceNavigatorMessages.ResourceNavigator_workingSetInputToolTip, (Object)string, (Object)iWorkingSet.getLabel()));
            } else {
                this.setTitleToolTip(string);
            }
        }
    }

    protected ResourceNavigatorActionGroup getActionGroup() {
        return this.actionGroup;
    }

    protected void setActionGroup(ResourceNavigatorActionGroup resourceNavigatorActionGroup) {
        this.actionGroup = resourceNavigatorActionGroup;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getShowInSource();
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return this.getShowInTarget();
        }
        return null;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(ResourceNavigator.this.getViewer().getInput(), ResourceNavigator.this.getViewer().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext showInContext) {
                Object object;
                Iterator iterator;
                Object object2;
                ArrayList arrayList = new ArrayList();
                ISelection iSelection = showInContext.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    object2 = (IStructuredSelection)iSelection;
                    iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        IResource iResource;
                        IResource iResource2;
                        object = iterator.next();
                        if (object instanceof IResource) {
                            arrayList.add(object);
                            continue;
                        }
                        if (object instanceof IMarker) {
                            iResource2 = ((IMarker)object).getResource();
                            if (iResource2.getType() == 8) continue;
                            arrayList.add(iResource2);
                            continue;
                        }
                        if (!(object instanceof IAdaptable)) continue;
                        iResource2 = (IAdaptable)object;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.core.resources.IResource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((object = iResource2.getAdapter((Class)clazz)) instanceof IResource) {
                            arrayList.add(object);
                            continue;
                        }
                        Class<?> clazz2 = class$4;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("org.eclipse.core.resources.IMarker");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (!((object = iResource2.getAdapter((Class)clazz2)) instanceof IMarker) || (iResource = ((IMarker)object).getResource()).getType() == 8) continue;
                        arrayList.add(iResource);
                    }
                }
                if (arrayList.isEmpty() && (object2 = showInContext.getInput()) instanceof IAdaptable) {
                    iterator = (IAdaptable)object2;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((object = iterator.getAdapter(clazz)) instanceof IResource) {
                        arrayList.add(object);
                    }
                }
                if (!arrayList.isEmpty()) {
                    ResourceNavigator.this.selectReveal((ISelection)new StructuredSelection(arrayList));
                    return true;
                }
                return false;
            }
        };
    }

    protected static final Object getSingleElement(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        return iStructuredSelection.getFirstElement();
    }

    static /* synthetic */ boolean access$6(ResourceNavigator resourceNavigator) {
        return resourceNavigator.dragDetected;
    }
}

