/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.actions.MoveResourceAction;

public class ResourceNavigatorMoveAction
extends MoveResourceAction {
    private StructuredViewer viewer;
    private MoveProjectAction moveProjectAction;

    public ResourceNavigatorMoveAction(Shell shell, StructuredViewer structuredViewer) {
        super(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.resource_navigator_move_action_context");
        this.viewer = structuredViewer;
        this.moveProjectAction = new MoveProjectAction(shell);
    }

    public void run() {
        if (this.moveProjectAction.isEnabled()) {
            this.moveProjectAction.run();
            return;
        }
        super.run();
        List list = this.getDestinations();
        if (list != null && !list.isEmpty()) {
            IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IResource iResource = iWorkspaceRoot.findMember((IPath)iterator.next());
                if (iResource == null) continue;
                arrayList.add(iResource);
            }
            this.viewer.setSelection((ISelection)new StructuredSelection(arrayList), true);
        }
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        this.moveProjectAction.selectionChanged(iStructuredSelection);
        return super.updateSelection(iStructuredSelection) || this.moveProjectAction.isEnabled();
    }
}

