/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.views.navigator.FiltersContentProvider;
import org.eclipse.ui.views.navigator.StringMatcher;

public class ResourcePatternFilter
extends ViewerFilter {
    private String[] patterns;
    private StringMatcher[] matchers;
    static final String COMMA_SEPARATOR = ",";
    static final String FILTERS_TAG = "resourceFilters";
    static /* synthetic */ Class class$0;

    private StringMatcher[] getMatchers() {
        if (this.matchers == null) {
            this.initializeFromPreferences();
        }
        return this.matchers;
    }

    public String[] getPatterns() {
        if (this.patterns == null) {
            this.initializeFromPreferences();
        }
        return this.patterns;
    }

    private void initializeFromPreferences() {
        String[] stringArray;
        Object object;
        IPreferenceStore iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString(FILTERS_TAG);
        if (string.length() == 0 && (string = (object = PrefUtil.getInternalPreferenceStore()).getString(FILTERS_TAG)).length() > 0) {
            iPreferenceStore.setValue(FILTERS_TAG, string);
            object.setValue(FILTERS_TAG, "");
        }
        if (string.length() == 0) {
            object = FiltersContentProvider.getDefaultFilters();
            String[] stringArray2 = new String[object.size()];
            object.toArray(stringArray2);
            this.setPatterns(stringArray2);
            return;
        }
        object = FiltersContentProvider.getDefinedFilters();
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA_SEPARATOR);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        while (stringTokenizer.hasMoreElements()) {
            stringArray = stringTokenizer.nextToken();
            if (object.indexOf(stringArray) <= -1) continue;
            arrayList.add(stringArray);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.setPatterns(stringArray);
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        Object object3;
        IResource iResource = null;
        if (object2 instanceof IResource) {
            iResource = (IResource)object2;
        } else if (object2 instanceof IAdaptable) {
            object3 = (IAdaptable)object2;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource = (IResource)object3.getAdapter((Class)clazz);
        }
        if (iResource != null) {
            object3 = iResource.getName();
            StringMatcher[] stringMatcherArray = this.getMatchers();
            int n = 0;
            while (n < stringMatcherArray.length) {
                if (stringMatcherArray[n].match((String)object3)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return true;
    }

    public void setPatterns(String[] stringArray) {
        this.patterns = stringArray;
        this.matchers = new StringMatcher[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.matchers[n] = new StringMatcher(stringArray[n], true, false);
            ++n;
        }
    }
}

