/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.views.navigator.FilterSelectionAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.SortViewAction;

public class SortAndFilterActionGroup
extends ResourceNavigatorActionGroup {
    private SortViewAction sortByTypeAction;
    private SortViewAction sortByNameAction;
    private FilterSelectionAction filterAction;

    public SortAndFilterActionGroup(IResourceNavigator iResourceNavigator) {
        super(iResourceNavigator);
    }

    protected void makeActions() {
        this.sortByNameAction = new SortViewAction(this.navigator, false);
        this.sortByTypeAction = new SortViewAction(this.navigator, true);
        this.filterAction = new FilterSelectionAction(this.navigator, ResourceNavigatorMessages.ResourceNavigator_filterText);
        this.filterAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/filter_ps.gif"));
        this.filterAction.setImageDescriptor(this.getImageDescriptor("elcl16/filter_ps.gif"));
    }

    public void fillActionBars(IActionBars iActionBars) {
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        MenuManager menuManager = new MenuManager(ResourceNavigatorMessages.ResourceNavigator_sort);
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.sortByNameAction);
        menuManager.add((IAction)this.sortByTypeAction);
        iMenuManager.add((IAction)this.filterAction);
    }

    public void updateActionBars() {
        int n = this.navigator.getComparator().getCriteria();
        this.sortByNameAction.setChecked(n == 1);
        this.sortByTypeAction.setChecked(n == 2);
    }
}

