/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.WorkspaceActionGroup;

public class WorkspaceActionGroup
extends ResourceNavigatorActionGroup {
    private BuildAction buildAction;
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private CloseUnrelatedProjectsAction closeUnrelatedProjectsAction;
    private RefreshAction refreshAction;
    static /* synthetic */ Class class$0;

    public WorkspaceActionGroup(IResourceNavigator iResourceNavigator) {
        super(iResourceNavigator);
    }

    public void fillActionBars(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.BUILD_PROJECT.getId(), (IAction)this.buildAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        iActionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.closeUnrelatedProjectsAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext() && (!bl2 || !bl3 || bl4 || bl)) {
            Object e = iterator.next();
            IProject iProject = null;
            if (e instanceof IProject) {
                iProject = (IProject)e;
            } else if (e instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iProject = (IProject)iAdaptable.getAdapter((Class)clazz);
            }
            if (iProject == null) {
                bl = false;
                continue;
            }
            if (iProject.isOpen()) {
                bl2 = true;
                if (!bl4 || this.hasBuilder(iProject)) continue;
                bl4 = false;
                continue;
            }
            bl3 = true;
            bl4 = false;
        }
        if (!iStructuredSelection.isEmpty() && bl && !ResourcesPlugin.getWorkspace().isAutoBuilding() && bl4) {
            this.buildAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.buildAction);
        }
        if (!bl3) {
            this.refreshAction.selectionChanged(iStructuredSelection);
            iMenuManager.add((IAction)this.refreshAction);
        }
        if (bl) {
            if (bl3) {
                this.openProjectAction.selectionChanged(iStructuredSelection);
                iMenuManager.add((IAction)this.openProjectAction);
            }
            if (bl2) {
                this.closeProjectAction.selectionChanged(iStructuredSelection);
                iMenuManager.add((IAction)this.closeProjectAction);
                this.closeUnrelatedProjectsAction.selectionChanged(iStructuredSelection);
                iMenuManager.add((IAction)this.closeUnrelatedProjectsAction);
            }
        }
    }

    public void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x100000E && keyEvent.stateMask == 0) {
            if (this.refreshAction.isEnabled()) {
                this.refreshAction.refreshAll();
            }
            keyEvent.doit = false;
        }
    }

    boolean hasBuilder(IProject iProject) {
        try {
            ICommand[] iCommandArray = iProject.getDescription().getBuildSpec();
            if (iCommandArray.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void makeActions() {
        IWorkbenchPartSite iWorkbenchPartSite = this.navigator.getSite();
        this.openProjectAction = new OpenResourceAction((IShellProvider)iWorkbenchPartSite);
        this.closeProjectAction = new CloseResourceAction((IShellProvider)iWorkbenchPartSite);
        this.closeUnrelatedProjectsAction = new CloseUnrelatedProjectsAction((IShellProvider)iWorkbenchPartSite);
        this.refreshAction = new RefreshAction((IShellProvider)iWorkbenchPartSite, (IShellProvider)iWorkbenchPartSite){
            private final /* synthetic */ IShellProvider val$provider;
            {
                this.val$provider = iShellProvider2;
            }

            public void run() {
                IStatus[] iStatusArray = new IStatus[]{Status.OK_STATUS};
                WorkspaceModifyOperation workspaceModifyOperation = (WorkspaceModifyOperation)this.createOperation(iStatusArray);
                WorkspaceJob workspaceJob = new WorkspaceJob(this, "refresh", workspaceModifyOperation, this.val$provider, iStatusArray){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ WorkspaceModifyOperation val$op;
                    private final /* synthetic */ IShellProvider val$provider;
                    private final /* synthetic */ IStatus[] val$errorStatus;
                    {
                        this.this$1 = var1_1;
                        this.val$op = workspaceModifyOperation;
                        this.val$provider = iShellProvider;
                        this.val$errorStatus = iStatusArray;
                    }

                    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                        try {
                            this.val$op.run(iProgressMonitor);
                            Shell shell = this.val$provider.getShell();
                            if (shell != null && !shell.isDisposed()) {
                                shell.getDisplay().asyncExec(new Runnable(this){
                                    final /* synthetic */ 2 this$2;
                                    {
                                        this.this$2 = var1_1;
                                    }

                                    public void run() {
                                        TreeViewer treeViewer = 1.access$0(2.access$0(this.this$2)).navigator.getViewer();
                                        if (treeViewer != null && treeViewer.getControl() != null && !treeViewer.getControl().isDisposed()) {
                                            treeViewer.refresh();
                                        }
                                    }
                                });
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            String string = NLS.bind((String)IDEWorkbenchMessages.WorkspaceAction_logTitle, (Object)((Object)((Object)this)).getClass().getName(), (Object)invocationTargetException.getTargetException());
                            throw new CoreException(StatusUtil.newStatus(4, string, invocationTargetException.getTargetException()));
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                        return this.val$errorStatus[0];
                    }

                    static /* synthetic */ 1 access$0(2 var0) {
                        return var0.this$1;
                    }
                };
                ISchedulingRule iSchedulingRule = workspaceModifyOperation.getRule();
                if (iSchedulingRule != null) {
                    workspaceJob.setRule(iSchedulingRule);
                }
                workspaceJob.setUser(true);
                workspaceJob.schedule();
            }

            static /* synthetic */ WorkspaceActionGroup access$0(1 var0) {
                return var0.WorkspaceActionGroup.this;
            }
        };
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.buildAction = new BuildAction((IShellProvider)iWorkbenchPartSite, 10);
    }

    public void updateActionBars() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(iStructuredSelection);
        this.buildAction.selectionChanged(iStructuredSelection);
        this.openProjectAction.selectionChanged(iStructuredSelection);
        this.closeUnrelatedProjectsAction.selectionChanged(iStructuredSelection);
        this.closeProjectAction.selectionChanged(iStructuredSelection);
    }
}

