/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.properties;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.views.properties.IDEPropertiesMessages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IResourcePropertyConstants;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ResourcePropertySource
implements IPropertySource {
    protected static String NOT_LOCAL_TEXT = IDEPropertiesMessages.PropertySource_notLocal;
    protected static String FILE_NOT_FOUND = IDEPropertiesMessages.PropertySource_notFound;
    protected static String UNDEFINED_PATH_VARIABLE = IDEPropertiesMessages.PropertySource_undefinedPathVariable;
    protected static String FILE_NOT_EXIST_TEXT = IDEPropertiesMessages.PropertySource_fileNotExist;
    protected IResource element;
    protected String errorMessage = IDEPropertiesMessages.PropertySource_readOnly;
    protected static IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[7];
    protected static IPropertyDescriptor[] propertyDescriptorsLinkVariable = new IPropertyDescriptor[8];

    static {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.jface.text", IResourcePropertyConstants.P_LABEL_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[0] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[0] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.path", IResourcePropertyConstants.P_DISPLAYPATH_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[1] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[1] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.editable", IResourcePropertyConstants.P_DISPLAYEDITABLE_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[2] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[2] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.derived", IResourcePropertyConstants.P_DISPLAYDERIVED_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[3] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[3] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.lastmodified", IResourcePropertyConstants.P_DISPLAY_LAST_MODIFIED);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[4] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[4] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.linked", IResourcePropertyConstants.P_DISPLAYLINKED_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[5] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[5] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.location", IResourcePropertyConstants.P_DISPLAYLOCATION_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptors[6] = propertyDescriptor;
        ResourcePropertySource.propertyDescriptorsLinkVariable[6] = propertyDescriptor;
        propertyDescriptor = new PropertyDescriptor((Object)"org.eclipse.ui.resolvedLocation", IResourcePropertyConstants.P_DISPLAYRESOLVED_LOCATION_RES);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(IResourcePropertyConstants.P_FILE_SYSTEM_CATEGORY);
        ResourcePropertySource.propertyDescriptorsLinkVariable[7] = propertyDescriptor;
    }

    public ResourcePropertySource(IResource iResource) {
        Assert.isNotNull((Object)iResource);
        this.element = iResource;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.isPathVariable(this.element)) {
            return propertyDescriptorsLinkVariable;
        }
        return propertyDescriptors;
    }

    public Object getPropertyValue(Object object) {
        if (object.equals("org.eclipse.jface.text")) {
            return this.element.getName();
        }
        if (object.equals("org.eclipse.ui.path")) {
            return TextProcessor.process((String)this.element.getFullPath().toString());
        }
        if (object.equals("org.eclipse.ui.lastmodified")) {
            return IDEResourceInfoUtils.getDateStringValue(this.element);
        }
        if (object.equals("org.eclipse.ui.editable")) {
            ResourceAttributes resourceAttributes = this.element.getResourceAttributes();
            if (resourceAttributes == null || resourceAttributes.isReadOnly()) {
                return IDEPropertiesMessages.ResourceProperty_false;
            }
            return IDEPropertiesMessages.ResourceProperty_true;
        }
        if (object.equals("org.eclipse.ui.derived")) {
            if (this.element.isDerived()) {
                return IDEPropertiesMessages.ResourceProperty_true;
            }
            return IDEPropertiesMessages.ResourceProperty_false;
        }
        if (object.equals("org.eclipse.ui.linked")) {
            if (this.element.isLinked()) {
                return IDEPropertiesMessages.ResourceProperty_true;
            }
            return IDEPropertiesMessages.ResourceProperty_false;
        }
        if (object.equals("org.eclipse.ui.location")) {
            return TextProcessor.process((String)IDEResourceInfoUtils.getLocationText(this.element));
        }
        if (object.equals("org.eclipse.ui.resolvedLocation")) {
            return TextProcessor.process((String)IDEResourceInfoUtils.getResolvedLocationText(this.element));
        }
        return null;
    }

    private boolean isPathVariable(IResource iResource) {
        if (!iResource.isLinked()) {
            return false;
        }
        IPath iPath = iResource.getLocation();
        if (iPath == null) {
            return true;
        }
        IPath iPath2 = iResource.getRawLocation();
        return !iPath.equals((Object)iPath2);
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }

    protected File getFile(IResource iResource) {
        IPath iPath = iResource.getLocation();
        if (iPath == null) {
            return null;
        }
        return iPath.toFile();
    }
}

