/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class CopyTaskAction
extends TaskAction {
    public CopyTaskAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.copy_task_action_context");
    }

    public void run() {
        TaskList taskList = this.getTaskList();
        TableViewer tableViewer = taskList.getTableViewer();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)tableViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        taskList.cancelEditing();
        List list = iStructuredSelection.toList();
        IMarker[] iMarkerArray = new IMarker[list.size()];
        list.toArray(iMarkerArray);
        this.setClipboard(iMarkerArray, TaskList.createMarkerReport(iMarkerArray));
        taskList.updatePasteEnablement();
    }

    private void setClipboard(IMarker[] iMarkerArray, String string) {
        block3: {
            try {
                Object[] objectArray = new Object[]{iMarkerArray, string};
                Transfer[] transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
                this.getTaskList().getClipboard().setContents(objectArray, transferArray);
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)TaskListMessages.CopyToClipboardProblemDialog_title, (String)TaskListMessages.CopyToClipboardProblemDialog_message)) break block3;
                this.setClipboard(iMarkerArray, string);
            }
        }
    }
}

