/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerType;
import org.eclipse.ui.views.tasklist.MarkerTypesModel;
import org.eclipse.ui.views.tasklist.TasksFilter;

class FiltersDialog
extends TrayDialog {
    static final int RESET_ID = 1024;
    static final int SELECT_ID = 1025;
    private EnumType severityType;
    private EnumType priorityType;
    private EnumType completionType;
    private TasksFilter filter;
    MarkerTypesModel markerTypesModel = new MarkerTypesModel();
    private MarkerType[] markerTypes;
    private CheckboxTreeViewer typesViewer;
    Button anyResourceButton;
    Button anyResourceInSameProjectButton;
    Button selectedResourceButton;
    Button selectedResourceAndChildrenButton;
    private WorkingSetGroup workingSetGroup;
    private LabelComboTextGroup descriptionGroup;
    private CheckboxEnumGroup severityGroup;
    private CheckboxEnumGroup priorityGroup;
    private CheckboxEnumGroup completionGroup;
    private Button filterOnMarkerLimit;
    private Text markerLimit;
    SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            FiltersDialog.this.widgetSelected(selectionEvent);
        }
    };
    private ICheckStateListener checkStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
            FiltersDialog.this.checkStateChanged(checkStateChangedEvent);
        }
    };

    public FiltersDialog(Shell shell) {
        super(shell);
        this.initTypes();
    }

    protected void buttonPressed(int n) {
        if (1024 == n) {
            this.resetPressed();
        } else if (1025 == n) {
            this.workingSetGroup.selectPressed();
        } else {
            super.buttonPressed(n);
        }
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        MarkerType markerType = (MarkerType)checkStateChangedEvent.getElement();
        this.typesViewer.setSubtreeChecked((Object)markerType, checkStateChangedEvent.getChecked());
        MarkerType[] markerTypeArray = markerType.getAllSupertypes();
        int n = 0;
        while (n < markerTypeArray.length) {
            this.typesViewer.setChecked((Object)markerTypeArray[n], false);
            ++n;
        }
        this.updateEnabledState();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TaskListMessages.TaskList_filter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.task_filters_dialog_context");
    }

    void createAttributesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        String[] stringArray = new String[]{TaskListMessages.TaskList_contains, TaskListMessages.TaskList_doesNotContain};
        this.descriptionGroup = new LabelComboTextGroup(composite2, TaskListMessages.TaskList_whereDescription, stringArray, "", 200);
        this.severityGroup = new CheckboxEnumGroup(composite2, TaskListMessages.TaskList_severity_label, this.severityType);
        this.priorityGroup = new CheckboxEnumGroup(composite2, TaskListMessages.TaskList_priority_label, this.priorityType);
        this.completionGroup = new CheckboxEnumGroup(composite2, TaskListMessages.TaskList_status_label, this.completionType);
    }

    void createResetArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(128));
        Button button = new Button(composite2, 8);
        button.setText(TaskListMessages.TaskList_resetText);
        button.setData((Object)new Integer(1024));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FiltersDialog.this.buttonPressed((Integer)selectionEvent.widget.getData());
            }
        });
        button.setFont(composite2.getFont());
        this.setButtonLayoutData(button);
    }

    Button createCheckbox(Composite composite, String string, boolean bl) {
        Button button = new Button(composite, 32);
        if (bl) {
            GridData gridData = new GridData(768);
            button.setLayoutData((Object)gridData);
        }
        button.setText(string);
        button.addSelectionListener(this.selectionListener);
        button.setFont(composite.getFont());
        return button;
    }

    Combo createCombo(Composite composite, String[] stringArray, int n) {
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(768));
        combo.setFont(composite.getFont());
        combo.setItems(stringArray);
        combo.select(n);
        combo.addSelectionListener(this.selectionListener);
        return combo;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMarkerLimitArea(composite2);
        this.createTypesArea(composite2);
        this.createResourceArea(composite2);
        this.createAttributesArea(composite2);
        this.createResetArea(composite2);
        this.createSeparatorLine(composite2);
        this.updateUIFromFilter(this.getFilter());
        return composite2;
    }

    void createSeparatorLine(Composite composite) {
        Label label = new Label(composite, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
    }

    Button createRadioButton(Composite composite, String string) {
        Button button = new Button(composite, 16);
        button.setText(string);
        button.setFont(composite.getFont());
        button.addSelectionListener(this.selectionListener);
        return button;
    }

    void createResourceArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout());
        composite2.setFont(composite.getFont());
        this.anyResourceButton = this.createRadioButton(composite2, TaskListMessages.TaskList_anyResource);
        this.anyResourceInSameProjectButton = this.createRadioButton(composite2, TaskListMessages.TaskList_anyResourceInSameProject);
        this.selectedResourceButton = this.createRadioButton(composite2, TaskListMessages.TaskList_selectedResource);
        this.selectedResourceAndChildrenButton = this.createRadioButton(composite2, TaskListMessages.TaskList_selectedAndChildren);
        this.workingSetGroup = new WorkingSetGroup(composite2);
    }

    void createTypesArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(TaskListMessages.TaskList_showItemsOfType);
        this.typesViewer = new CheckboxTreeViewer(composite2);
        GridData gridData = new GridData(768);
        gridData.heightHint = 100;
        this.typesViewer.getControl().setLayoutData((Object)gridData);
        this.typesViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.typesViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.typesViewer.setComparator(this.getViewerComparator());
        this.typesViewer.setAutoExpandLevel(-1);
        this.typesViewer.addCheckStateListener(this.checkStateListener);
        this.typesViewer.setInput((Object)this.getMarkerTypes());
    }

    ITreeContentProvider getContentProvider() {
        return new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object object) {
                return new Object[]{FiltersDialog.this.markerTypesModel.getType("org.eclipse.core.resources.problemmarker"), FiltersDialog.this.markerTypesModel.getType("org.eclipse.core.resources.taskmarker")};
            }

            public Object[] getChildren(Object object) {
                MarkerType markerType = (MarkerType)object;
                return markerType.getSubtypes();
            }

            public Object getParent(Object object) {
                return null;
            }

            public boolean hasChildren(Object object) {
                return this.getChildren(object).length > 0;
            }
        };
    }

    void createMarkerLimitArea(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(font);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.filterOnMarkerLimit = this.createCheckbox(composite2, TaskListMessages.TaskList_limitVisibleTasksTo, false);
        this.filterOnMarkerLimit.setLayoutData((Object)new GridData());
        this.markerLimit = new Text(composite2, 2052);
        this.markerLimit.setTextLimit(6);
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(10);
        this.markerLimit.setLayoutData((Object)gridData);
        this.markerLimit.setFont(font);
    }

    public TasksFilter getFilter() {
        if (this.filter == null) {
            this.filter = new TasksFilter();
        }
        return this.filter;
    }

    ILabelProvider getLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                MarkerType markerType = (MarkerType)object;
                return markerType.getLabel();
            }
        };
    }

    MarkerType[] getMarkerTypes() {
        if (this.markerTypes == null) {
            ArrayList<MarkerType> arrayList = new ArrayList<MarkerType>();
            MarkerType[] markerTypeArray = this.markerTypesModel.getTypes();
            int n = 0;
            while (n < markerTypeArray.length) {
                MarkerType markerType = markerTypeArray[n];
                if (markerType.getLabel().length() > 0 && (markerType.isSubtypeOf(this.markerTypesModel.getType("org.eclipse.core.resources.problemmarker")) || markerType.isSubtypeOf(this.markerTypesModel.getType("org.eclipse.core.resources.taskmarker")))) {
                    arrayList.add(markerType);
                }
                ++n;
            }
            Collections.sort(arrayList, new Comparator(){
                Collator collator = Collator.getInstance();

                public int compare(Object object, Object object2) {
                    return this.collator.compare(((MarkerType)object).getLabel(), ((MarkerType)object2).getLabel());
                }
            });
            this.markerTypes = new MarkerType[arrayList.size()];
            arrayList.toArray(this.markerTypes);
        }
        return this.markerTypes;
    }

    String[] getSelectedTypes() {
        Object[] objectArray = this.typesViewer.getCheckedElements();
        ArrayList<MarkerType> arrayList = new ArrayList<MarkerType>();
        int n = 0;
        while (n < objectArray.length) {
            MarkerType markerType = (MarkerType)objectArray[n];
            boolean bl = false;
            int n2 = arrayList.size();
            while (--n2 >= 0) {
                if (!markerType.isSubtypeOf((MarkerType)arrayList.get(n2))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(markerType);
            }
            ++n;
        }
        String[] stringArray = new String[arrayList.size()];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            stringArray[n3] = ((MarkerType)arrayList.get(n3)).getId();
            ++n3;
        }
        return stringArray;
    }

    private ViewerComparator getViewerComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object object, Object object2) {
                MarkerType markerType = (MarkerType)object;
                MarkerType markerType2 = (MarkerType)object2;
                return this.getComparator().compare(markerType.getLabel(), markerType2.getLabel());
            }
        };
    }

    String getTypeId(int n) {
        return this.getMarkerTypes()[n].getId();
    }

    int getTypeIndex(String string) {
        MarkerType[] markerTypeArray = this.getMarkerTypes();
        int n = 0;
        while (n < markerTypeArray.length) {
            String string2 = markerTypeArray[n].getId();
            if (string2 == null ? string == null : string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void initTypes() {
        this.severityType = new EnumType(new EnumValue[]{new EnumValue(2, TaskListMessages.TaskList_severity_error), new EnumValue(1, TaskListMessages.TaskList_severity_warning), new EnumValue(0, TaskListMessages.TaskList_severity_info)});
        this.priorityType = new EnumType(new EnumValue[]{new EnumValue(2, TaskListMessages.TaskList_priority_high), new EnumValue(1, TaskListMessages.TaskList_priority_normal), new EnumValue(0, TaskListMessages.TaskList_priority_low)});
        this.completionType = new EnumType(new EnumValue[]{new EnumValue(1, TaskListMessages.TaskList_status_completed), new EnumValue(0, TaskListMessages.TaskList_status_notCompleted)});
    }

    protected void okPressed() {
        block3: {
            try {
                int n = Integer.parseInt(this.markerLimit.getText());
                if (n < 1) {
                    throw new NumberFormatException();
                }
                this.updateFilterFromUI(this.getFilter());
                super.okPressed();
            }
            catch (NumberFormatException numberFormatException) {
                MessageBox messageBox = new MessageBox(this.getShell(), 65569);
                messageBox.setText(TaskListMessages.TaskList_titleMarkerLimitInvalid);
                messageBox.setMessage(TaskListMessages.TaskList_messageMarkerLimitInvalid);
                messageBox.open();
                if (!this.markerLimit.forceFocus()) break block3;
                this.markerLimit.setSelection(0, this.markerLimit.getCharCount());
                this.markerLimit.showSelection();
            }
        }
    }

    void resetPressed() {
        this.updateUIFromFilter(new TasksFilter());
    }

    boolean selectionIncludesSubtypeOf(String string) {
        MarkerType markerType = this.markerTypesModel.getType(string);
        if (markerType == null) {
            return false;
        }
        Object[] objectArray = this.typesViewer.getCheckedElements();
        int n = 0;
        while (n < objectArray.length) {
            if (((MarkerType)objectArray[n]).isSubtypeOf(markerType)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setFilter(TasksFilter tasksFilter) {
        this.filter = tasksFilter;
    }

    void setSelectedTypes(String[] stringArray) {
        this.typesViewer.setCheckedElements((Object[])new MarkerType[0]);
        int n = 0;
        while (n < stringArray.length) {
            MarkerType markerType = this.markerTypesModel.getType(stringArray[n]);
            if (markerType != null) {
                this.typesViewer.setSubtreeChecked((Object)markerType, true);
            }
            ++n;
        }
    }

    void updateEnabledState() {
        this.markerLimit.setEnabled(this.filterOnMarkerLimit.getSelection());
        boolean bl = this.selectionIncludesSubtypeOf("org.eclipse.core.resources.problemmarker");
        boolean bl2 = this.selectionIncludesSubtypeOf("org.eclipse.core.resources.taskmarker");
        this.severityGroup.setEnabled(bl);
        this.priorityGroup.setEnabled(bl2);
        this.completionGroup.setEnabled(bl2);
    }

    void updateFilterFromUI(TasksFilter tasksFilter) {
        tasksFilter.types = this.getSelectedTypes();
        tasksFilter.onResource = this.selectedResourceButton.getSelection() ? 1 : (this.selectedResourceAndChildrenButton.getSelection() ? 2 : (this.anyResourceInSameProjectButton.getSelection() ? 3 : (this.workingSetGroup.getSelection() ? 4 : 0)));
        tasksFilter.workingSet = this.workingSetGroup.getWorkingSet();
        tasksFilter.descriptionFilterKind = this.descriptionGroup.combo.getSelectionIndex();
        tasksFilter.descriptionFilter = this.descriptionGroup.text.getText();
        tasksFilter.filterOnDescription = !tasksFilter.descriptionFilter.equals("");
        tasksFilter.filterOnSeverity = this.severityGroup.getSelection();
        tasksFilter.severityFilter = this.severityGroup.getValueMask();
        tasksFilter.filterOnPriority = this.priorityGroup.getSelection();
        tasksFilter.priorityFilter = this.priorityGroup.getValueMask();
        tasksFilter.filterOnCompletion = this.completionGroup.getSelection();
        tasksFilter.completionFilter = this.completionGroup.getValueMask();
        int n = 2000;
        try {
            n = Integer.parseInt(this.markerLimit.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        tasksFilter.setMarkerLimit(n);
        tasksFilter.setFilterOnMarkerLimit(this.filterOnMarkerLimit.getSelection());
    }

    void updateUIFromFilter(TasksFilter tasksFilter) {
        this.setSelectedTypes(tasksFilter.types);
        int n = tasksFilter.onResource;
        this.anyResourceButton.setSelection(n == 0);
        this.anyResourceInSameProjectButton.setSelection(n == 3);
        this.selectedResourceButton.setSelection(n == 1);
        this.selectedResourceAndChildrenButton.setSelection(n == 2);
        this.workingSetGroup.setSelection(n == 4);
        this.workingSetGroup.setWorkingSet(tasksFilter.workingSet);
        this.descriptionGroup.combo.select(tasksFilter.descriptionFilterKind);
        this.descriptionGroup.text.setText(tasksFilter.descriptionFilter);
        this.severityGroup.setSelection(tasksFilter.filterOnSeverity);
        this.severityGroup.setValueMask(tasksFilter.severityFilter);
        this.priorityGroup.setSelection(tasksFilter.filterOnPriority);
        this.priorityGroup.setValueMask(tasksFilter.priorityFilter);
        this.completionGroup.setSelection(tasksFilter.filterOnCompletion);
        this.completionGroup.setValueMask(tasksFilter.completionFilter);
        this.markerLimit.setText("" + tasksFilter.getMarkerLimit());
        this.filterOnMarkerLimit.setSelection(tasksFilter.getFilterOnMarkerLimit());
        this.updateEnabledState();
    }

    void widgetSelected(SelectionEvent selectionEvent) {
        this.updateEnabledState();
    }

    private class CheckboxEnumGroup {
        private EnumType type;
        private Button enableButton;
        private Button[] valueButtons;

        CheckboxEnumGroup(Composite composite, String string, EnumType enumType) {
            this.type = enumType;
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayoutData((Object)new GridData(768));
            composite2.setLayout((Layout)new FillLayout());
            this.enableButton = new Button(composite2, 32);
            this.enableButton.addSelectionListener(FiltersDialog.this.selectionListener);
            this.enableButton.setText(string);
            Composite composite3 = new Composite(composite, 0);
            composite3.setLayoutData((Object)new GridData(768));
            composite3.setLayout((Layout)new FillLayout());
            EnumValue[] enumValueArray = enumType.getValues();
            this.valueButtons = new Button[enumValueArray.length];
            int n = 0;
            while (n < enumValueArray.length) {
                Button button = new Button(composite3, 32);
                button.setText(enumValueArray[n].getText());
                this.valueButtons[n] = button;
                ++n;
            }
        }

        void setEnabled(boolean bl) {
            this.enableButton.setEnabled(bl);
            this.updateEnabledState();
        }

        boolean getSelection() {
            return this.enableButton.getSelection();
        }

        void setSelection(boolean bl) {
            this.enableButton.setSelection(bl);
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean bl = this.enableButton.isEnabled() && this.enableButton.getSelection();
            int n = 0;
            while (n < this.valueButtons.length) {
                this.valueButtons[n].setEnabled(bl);
                ++n;
            }
        }

        int getValueMask() {
            int n = 0;
            EnumValue[] enumValueArray = this.type.getValues();
            int n2 = 0;
            while (n2 < this.valueButtons.length) {
                if (this.valueButtons[n2].getSelection()) {
                    n |= 1 << enumValueArray[n2].getValue();
                }
                ++n2;
            }
            return n;
        }

        void setValueMask(int n) {
            EnumValue[] enumValueArray = this.type.getValues();
            int n2 = 0;
            while (n2 < enumValueArray.length) {
                this.valueButtons[n2].setSelection((n & 1 << enumValueArray[n2].getValue()) != 0);
                ++n2;
            }
        }
    }

    private static class EnumType {
        private EnumValue[] values;

        EnumType(EnumValue[] enumValueArray) {
            this.values = enumValueArray;
        }

        EnumValue[] getValues() {
            return this.values;
        }
    }

    private static class EnumValue {
        private int value;
        private String text;

        EnumValue(int n, String string) {
            this.value = n;
            this.text = string;
        }

        int getValue() {
            return this.value;
        }

        String getText() {
            return this.text;
        }
    }

    private class LabelComboTextGroup {
        Label label;
        Combo combo;
        Text text;

        LabelComboTextGroup(Composite composite, String string, String[] stringArray, String string2, int n) {
            Font font = composite.getFont();
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
            composite2.setFont(font);
            this.label = new Label(composite2, 0);
            this.label.setText(string);
            this.label.setFont(font);
            this.combo = FiltersDialog.this.createCombo(composite2, stringArray, 0);
            this.text = new Text(composite, 2052);
            GridData gridData = new GridData(768);
            gridData.widthHint = n;
            this.text.setLayoutData((Object)gridData);
            this.text.setFont(font);
            this.text.setText(string2);
        }
    }

    private class WorkingSetGroup {
        private Button button;

        WorkingSetGroup(Composite composite) {
            this.button = FiltersDialog.this.createRadioButton(composite, TaskListMessages.TaskList_noWorkingSet);
            GridData gridData = new GridData(768);
            this.button.setLayoutData((Object)gridData);
            Composite composite2 = new Composite(composite, 0);
            composite2.setFont(composite.getFont());
            GridLayout gridLayout = new GridLayout();
            Button button = new Button(composite, 16);
            gridLayout.marginWidth = button.computeSize((int)-1, (int)-1).x;
            gridLayout.marginHeight = 0;
            button.dispose();
            composite2.setLayout((Layout)gridLayout);
            FiltersDialog.this.createButton(composite2, 1025, TaskListMessages.TaskList_workingSetSelect, false);
        }

        boolean getSelection() {
            return this.button.getSelection();
        }

        IWorkingSet getWorkingSet() {
            return (IWorkingSet)this.button.getData();
        }

        void setSelection(boolean bl) {
            this.button.setSelection(bl);
            if (bl) {
                FiltersDialog.this.anyResourceButton.setSelection(false);
                FiltersDialog.this.anyResourceInSameProjectButton.setSelection(false);
                FiltersDialog.this.selectedResourceButton.setSelection(false);
                FiltersDialog.this.selectedResourceAndChildrenButton.setSelection(false);
            }
        }

        void selectPressed() {
            IWorkingSetSelectionDialog iWorkingSetSelectionDialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(FiltersDialog.this.getShell(), false);
            IWorkingSet iWorkingSet = this.getWorkingSet();
            if (iWorkingSet != null) {
                iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
            }
            if (iWorkingSetSelectionDialog.open() == 0) {
                IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
                if (iWorkingSetArray != null && iWorkingSetArray.length > 0) {
                    this.setWorkingSet(iWorkingSetArray[0]);
                } else {
                    this.setWorkingSet(null);
                }
                if (!this.getSelection()) {
                    this.setSelection(true);
                }
            }
        }

        void setWorkingSet(IWorkingSet iWorkingSet) {
            this.button.setData((Object)iWorkingSet);
            if (iWorkingSet != null) {
                this.button.setText(NLS.bind((String)TaskListMessages.TaskList_workingSet, (Object)iWorkingSet.getLabel()));
            } else {
                this.button.setText(TaskListMessages.TaskList_noWorkingSet);
            }
        }
    }
}

