/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class GotoTaskAction
extends TaskAction {
    public GotoTaskAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.goto_task_action_context");
    }

    public void run() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getTaskList().getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IMarker)) {
            return;
        }
        IMarker iMarker = (IMarker)object;
        IResource iResource = iMarker.getResource();
        if (iMarker.exists() && iResource instanceof IFile) {
            IWorkbenchPage iWorkbenchPage = this.getTaskList().getSite().getPage();
            try {
                IDE.openEditor(iWorkbenchPage, iMarker, OpenStrategy.activateOnOpen());
            }
            catch (PartInitException partInitException) {
                DialogUtil.openError(iWorkbenchPage.getWorkbenchWindow().getShell(), TaskListMessages.GotoTask_errorMessage, partInitException.getMessage(), partInitException);
            }
        }
    }
}

