/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.views.tasklist.MarkerType;

class MarkerTypesModel {
    private HashMap types = this.readTypes();

    public MarkerType getType(String string) {
        return (MarkerType)this.types.get(string);
    }

    public MarkerType[] getTypes() {
        MarkerType[] markerTypeArray = new MarkerType[this.types.size()];
        this.types.values().toArray(markerTypeArray);
        return markerTypeArray;
    }

    private String getWellKnownLabel(String string) {
        if (string.equals("org.eclipse.core.resources.problemmarker")) {
            return "Problem";
        }
        if (string.equals("org.eclipse.core.resources.taskmarker")) {
            return "Task";
        }
        if (string.equals("org.eclipse.jdt.core.problem")) {
            return "Java Problem";
        }
        return string;
    }

    private HashMap readTypes() {
        HashMap<String, IConfigurationElement> hashMap = new HashMap<String, IConfigurationElement>();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                Object object;
                IExtension iExtension = iExtensionArray[n];
                String string = iExtension.getUniqueIdentifier();
                String string2 = iExtension.getLabel();
                if (string2.equals("")) {
                    string2 = this.getWellKnownLabel(string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    String string3;
                    object = iConfigurationElementArray[n2];
                    if (object.getName().equalsIgnoreCase("super") && (string3 = object.getAttribute("type")) != null) {
                        arrayList.add(string3);
                    }
                    ++n2;
                }
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                object = new MarkerType(this, string, string2, stringArray);
                hashMap.put(string, (IConfigurationElement)object);
                ++n;
            }
        }
        return hashMap;
    }
}

