/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.IMarkerConstants;

class MarkerUtil
implements IMarkerConstants {
    private static Map imageDescriptors;
    private static ImageRegistry imageRegistry;
    private static MessageFormat line;
    private static MessageFormat lineAndLocation;

    static {
        imageRegistry = new ImageRegistry();
        line = new MessageFormat(TaskListMessages.TaskList_line);
        lineAndLocation = new MessageFormat(TaskListMessages.TaskList_lineAndLocation);
        MarkerUtil.createImageDescriptors();
    }

    private MarkerUtil() {
    }

    static void createImageDescriptors() {
        imageDescriptors = new HashMap(51);
        imageDescriptors.put("header_complete", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/header_complete.gif"));
        imageDescriptors.put("header_priority", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/header_priority.gif"));
        imageDescriptors.put("task", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/taskmrk_tsk.gif"));
        imageDescriptors.put("error", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/error_tsk.gif"));
        imageDescriptors.put("warn", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/warn_tsk.gif"));
        imageDescriptors.put("info", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/info_tsk.gif"));
        imageDescriptors.put("hprio", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/hprio_tsk.gif"));
        imageDescriptors.put("lprio", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/lprio_tsk.gif"));
        imageDescriptors.put("complete_tsk", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/complete_tsk.gif"));
        imageDescriptors.put("incomplete_tsk", IDEWorkbenchPlugin.getIDEImageDescriptor("obj16/incomplete_tsk.gif"));
        imageDescriptors.put("gotoobj", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/gotoobj_tsk.gif"));
        imageDescriptors.put("addtsk", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/addtsk_tsk.gif"));
        imageDescriptors.put("addtsk_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/addtsk_tsk.gif"));
        imageDescriptors.put("showcomplete", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/showcomplete_tsk.gif"));
        imageDescriptors.put("selected_mode", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/selected_mode.gif"));
        imageDescriptors.put("selected_mode_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/selected_mode.gif"));
        imageDescriptors.put("showchild_mode", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/showchild_mode.gif"));
        imageDescriptors.put("showchild_mode_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showchild_mode.gif"));
        imageDescriptors.put("showerr_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showerr_tsk.gif"));
        imageDescriptors.put("showwarn_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showwarn_tsk.gif"));
        imageDescriptors.put("showtsk_disabled", IDEWorkbenchPlugin.getIDEImageDescriptor("dlcl16/showtsk_tsk.gif"));
        imageDescriptors.put("filter", IDEWorkbenchPlugin.getIDEImageDescriptor("elcl16/filter_ps.gif"));
    }

    public static int getCharEnd(IMarker iMarker) {
        return iMarker.getAttribute("charEnd", -1);
    }

    public static int getCharStart(IMarker iMarker) {
        return iMarker.getAttribute("charStart", -1);
    }

    public static Image getCompleteImage(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            if (MarkerUtil.isComplete(iMarker)) {
                return MarkerUtil.getImage("complete_tsk");
            }
            if (!MarkerUtil.isReadOnly(iMarker)) {
                return MarkerUtil.getImage("incomplete_tsk");
            }
        }
        return null;
    }

    public static String getCompleteText(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            if (MarkerUtil.isComplete(iMarker)) {
                return TaskListMessages.TaskList_completed;
            }
            return TaskListMessages.TaskList_notCompleted;
        }
        return "";
    }

    public static String getKindText(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            return TaskListMessages.TaskList_task;
        }
        switch (MarkerUtil.getSeverity(iMarker)) {
            case 2: {
                return TaskListMessages.TaskList_error;
            }
            case 1: {
                return TaskListMessages.TaskList_warning;
            }
            case 0: {
                return TaskListMessages.TaskList_info;
            }
        }
        return "";
    }

    public static String getContainerName(IMarker iMarker) {
        IPath iPath = iMarker.getResource().getFullPath();
        int n = iPath.segmentCount() - 1;
        if (n <= 0) {
            return "";
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += iPath.segment(n3).length();
            ++n3;
        }
        if (n > 1) {
            n2 += n - 1;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(iPath.segment(n4));
            ++n4;
        }
        return stringBuffer.toString();
    }

    static Image getImage(String string) {
        ImageDescriptor imageDescriptor;
        Image image = imageRegistry.get(string);
        if (image == null && (imageDescriptor = MarkerUtil.getImageDescriptor(string)) != null) {
            image = imageDescriptor.createImage(false);
            if (image == null) {
                System.err.println("TaskList: Error creating image for " + string);
            }
            imageRegistry.put(string, image);
        }
        return image;
    }

    public static Image getImage(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtil.getSeverity(iMarker)) {
                case 2: {
                    return MarkerUtil.getImage("error");
                }
                case 1: {
                    return MarkerUtil.getImage("warn");
                }
                case 0: {
                    return MarkerUtil.getImage("info");
                }
            }
        } else if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.getImage("task");
        }
        return null;
    }

    static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = (ImageDescriptor)imageDescriptors.get(string);
        if (imageDescriptor == null) {
            IDEWorkbenchPlugin.log("TaskList: No image descriptor for " + string);
        }
        return imageDescriptor;
    }

    public static String getLineAndLocation(IMarker iMarker) {
        int n = MarkerUtil.getLineNumber(iMarker);
        String string = MarkerUtil.getLocation(iMarker);
        return MarkerUtil.getLineAndLocation(n, string);
    }

    public static String getLineAndLocation(int n, String string) {
        if (n == -1) {
            if (string.equals("")) {
                return "";
            }
            return string;
        }
        if (string.equals("")) {
            return line.format((Object)new Object[]{Integer.toString(n)});
        }
        return lineAndLocation.format((Object)new Object[]{Integer.toString(n), string});
    }

    public static int getLineNumber(IMarker iMarker) {
        return iMarker.getAttribute("lineNumber", -1);
    }

    public static String getLocation(IMarker iMarker) {
        return iMarker.getAttribute("location", "");
    }

    public static String getMessage(IMarker iMarker) {
        return iMarker.getAttribute("message", "");
    }

    public static int getNumericValue(String string) {
        boolean bl = false;
        int n = 0;
        int n2 = string.length();
        if (n < n2 && string.charAt(n) == '#') {
            ++n;
        }
        if (n < n2 && string.charAt(n) == '-') {
            bl = true;
            ++n;
        }
        int n3 = 0;
        while (n < n2) {
            int n4;
            if ((n4 = Character.digit(string.charAt(n++), 10)) < 0) {
                return n3;
            }
            n3 = n3 * 10 + n4;
        }
        if (bl) {
            n3 = -n3;
        }
        return n3;
    }

    public static int getPriority(IMarker iMarker) {
        return iMarker.getAttribute("priority", 1);
    }

    public static Image getPriorityImage(IMarker iMarker) {
        switch (MarkerUtil.getPriority(iMarker)) {
            case 2: {
                return MarkerUtil.getImage("hprio");
            }
            case 1: {
                return null;
            }
            case 0: {
                return MarkerUtil.getImage("lprio");
            }
        }
        return null;
    }

    public static String getPriorityText(IMarker iMarker) {
        if (!MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            return "";
        }
        switch (MarkerUtil.getPriority(iMarker)) {
            case 2: {
                return TaskListMessages.TaskList_high;
            }
            case 1: {
                return TaskListMessages.TaskList_normal;
            }
            case 0: {
                return TaskListMessages.TaskList_low;
            }
        }
        return "";
    }

    public static Object getProperty(Object object, String string) {
        IMarker iMarker = (IMarker)object;
        if ("org.eclipse.jface.image" == string) {
            return MarkerUtil.getImage(iMarker);
        }
        if ("org.eclipse.ui.tasklist.completeImage" == string) {
            return MarkerUtil.getCompleteImage(iMarker);
        }
        if ("org.eclipse.ui.tasklist.priorityImage" == string) {
            return MarkerUtil.getPriorityImage(iMarker);
        }
        if ("message" == string) {
            return MarkerUtil.getMessage(iMarker);
        }
        if ("org.eclipse.ui.tasklist.resourceName" == string) {
            return MarkerUtil.getResourceName(iMarker);
        }
        if ("org.eclipse.ui.tasklist.containerName" == string) {
            return MarkerUtil.getContainerName(iMarker);
        }
        if ("org.eclipse.ui.tasklist.lineAndLocation" == string) {
            return MarkerUtil.getLineAndLocation(iMarker);
        }
        if ("priority" == string) {
            return new Integer(2 - MarkerUtil.getPriority(iMarker));
        }
        if ("done" == string) {
            return MarkerUtil.isComplete(iMarker) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("org.eclipse.jface.text" == string) {
            return MarkerUtil.getMessage(iMarker);
        }
        return null;
    }

    public static String getResourceName(IMarker iMarker) {
        return iMarker.getResource().getName();
    }

    public static int getSeverity(IMarker iMarker) {
        return iMarker.getAttribute("severity", 1);
    }

    public static boolean isComplete(IMarker iMarker) {
        return iMarker.getAttribute("done", false);
    }

    public static boolean isEditable(IMarker iMarker) {
        return MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker") && !MarkerUtil.isReadOnly(iMarker);
    }

    public static boolean isMarkerType(IMarker iMarker, String string) {
        try {
            return iMarker.isSubtypeOf(string);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isReadOnly(IMarker iMarker) {
        return !iMarker.getAttribute("userEditable", true);
    }

    public static String getCreationTime(IMarker iMarker) {
        try {
            return DateFormat.getDateTimeInstance((int)1, (int)2).format(new Date(iMarker.getCreationTime()));
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

