/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TaskPropertiesDialog;

class NewTaskAction
extends TaskAction {
    public NewTaskAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.new_task_action_context");
    }

    public void run() {
        TaskPropertiesDialog taskPropertiesDialog = new TaskPropertiesDialog(this.getShell());
        taskPropertiesDialog.setResource(this.getTaskList().getResource());
        int n = taskPropertiesDialog.open();
        if (n == 0) {
            this.showMarker(taskPropertiesDialog.getMarker());
        }
    }

    private void showMarker(final IMarker iMarker) {
        if (iMarker == null) {
            return;
        }
        if (this.getTaskList().shouldShow(iMarker)) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    NewTaskAction.this.getTaskList().setSelection((ISelection)new StructuredSelection((Object)iMarker), true);
                }
            });
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TaskListMessages.NewTask_notShownTitle, (String)TaskListMessages.NewTask_notShownMsg);
        }
    }
}

