/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class PasteTaskAction
extends TaskAction {
    public PasteTaskAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.paste_task_action_context");
    }

    public void run() {
        MarkerTransfer markerTransfer = MarkerTransfer.getInstance();
        final IMarker[] iMarkerArray = (IMarker[])this.getTaskList().getClipboard().getContents((Transfer)markerTransfer);
        if (iMarkerArray == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        try {
            this.getTaskList().getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        if (iMarkerArray[n].getType().equals("org.eclipse.core.resources.taskmarker")) {
                            arrayList2.add(iMarkerArray[n].getResource());
                            arrayList.add(iMarkerArray[n].getAttributes());
                        }
                        ++n;
                    }
                }
            }, null);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.PasteTask_errorMessage, null, (IStatus)coreException.getStatus());
            return;
        }
        Map[] mapArray = arrayList.toArray(new Map[arrayList.size()]);
        IResource[] iResourceArray = arrayList2.toArray(new IResource[arrayList2.size()]);
        final CreateMarkersOperation createMarkersOperation = new CreateMarkersOperation("org.eclipse.core.resources.taskmarker", mapArray, iResourceArray, this.getText());
        this.execute((IUndoableOperation)createMarkersOperation, TaskListMessages.PasteTask_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        if (createMarkersOperation.getMarkers() != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TaskList taskList = PasteTaskAction.this.getTaskList();
                    taskList.setSelection((ISelection)new StructuredSelection((Object[])createMarkersOperation.getMarkers()), true);
                }
            });
        }
    }
}

