/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class PurgeCompletedAction
extends TaskAction {
    public PurgeCompletedAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.purge_completed_task_action_context");
    }

    public void run() {
        Object object;
        IMarker[] iMarkerArray;
        IResource iResource = this.getTaskList().getResource();
        int n = this.getTaskList().getResourceDepth();
        try {
            iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.taskmarker", true, n);
        }
        catch (CoreException coreException) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.PurgeCompleted_errorMessage, null, (IStatus)coreException.getStatus());
            return;
        }
        ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        int n2 = 0;
        while (n2 < iMarkerArray.length) {
            object = iMarkerArray[n2];
            if (MarkerUtil.isComplete(object) && !MarkerUtil.isReadOnly(object)) {
                arrayList.add((IMarker)object);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TaskListMessages.PurgeCompleted_title, (String)TaskListMessages.PurgeCompleted_noneCompleted);
            return;
        }
        if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)TaskListMessages.PurgeCompleted_title, (String)NLS.bind((String)TaskListMessages.PurgeCompleted_permanent, (Object)String.valueOf(arrayList.size())))) {
            return;
        }
        IMarker[] iMarkerArray2 = new IMarker[arrayList.size()];
        arrayList.toArray(iMarkerArray2);
        object = new DeleteMarkersOperation(iMarkerArray2, this.getText());
        this.execute((IUndoableOperation)object, TaskListMessages.PurgeCompleted_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
    }
}

