/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.DeleteMarkersOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class RemoveTaskAction
extends TaskAction {
    public RemoveTaskAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.remove_task_action_context");
    }

    public void run() {
        TaskList taskList = this.getTaskList();
        TableViewer tableViewer = taskList.getTableViewer();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)tableViewer.getSelection();
        if (iStructuredSelection.isEmpty()) {
            return;
        }
        taskList.cancelEditing();
        Table table = tableViewer.getTable();
        int n = table.getSelectionIndex();
        List list = iStructuredSelection.toList();
        IMarker[] iMarkerArray = new IMarker[list.size()];
        list.toArray(iMarkerArray);
        DeleteMarkersOperation deleteMarkersOperation = new DeleteMarkersOperation(iMarkerArray, TaskListMessages.RemoveTask_undoText);
        this.execute((IUndoableOperation)deleteMarkersOperation, TaskListMessages.RemoveTask_errorMessage, null, WorkspaceUndoUtil.getUIInfoAdapter(this.getShell()));
        int n2 = table.getItemCount();
        if (n < n2) {
            table.setSelection(n);
        } else if (n2 != 0) {
            table.setSelection(n2 - 1);
        }
        tableViewer.setSelection(tableViewer.getSelection(), true);
    }
}

