/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskList;

class ResolveMarkerAction
extends TaskAction {
    protected ResolveMarkerAction(TaskList taskList, String string) {
        super(taskList, string);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.resolve_marker_action_context");
    }

    public boolean shouldEnable(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        IMarker iMarker = (IMarker)iStructuredSelection.getFirstElement();
        if (iMarker == null) {
            return false;
        }
        return IDE.getMarkerHelpRegistry().hasResolutions(iMarker);
    }

    public void run() {
        IMarker iMarker = this.getMarker();
        if (iMarker == null) {
            return;
        }
        this.getTaskList().cancelEditing();
        IMarkerResolution[] iMarkerResolutionArray = this.getResolutions(iMarker);
        if (iMarkerResolutionArray.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)TaskListMessages.Resolve_title, (String)TaskListMessages.Resolve_noResolutionsLabel);
            return;
        }
        MarkerResolutionSelectionDialog markerResolutionSelectionDialog = new MarkerResolutionSelectionDialog(this.getShell(), iMarkerResolutionArray);
        if (markerResolutionSelectionDialog.open() != 0) {
            return;
        }
        Object[] objectArray = markerResolutionSelectionDialog.getResult();
        if (objectArray != null && objectArray.length > 0) {
            ((IMarkerResolution)objectArray[0]).run(iMarker);
        }
    }

    private IMarkerResolution[] getResolutions(IMarker iMarker) {
        return IDE.getMarkerHelpRegistry().getResolutions(iMarker);
    }

    private IMarker getMarker() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getTaskList().getSelection();
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        return (IMarker)iStructuredSelection.getFirstElement();
    }
}

