/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.views.tasklist.TaskList;

abstract class TaskAction
extends Action {
    private TaskList taskList;

    protected TaskAction(TaskList taskList, String string) {
        this.taskList = taskList;
        this.setId(string);
    }

    protected Shell getShell() {
        return this.taskList.getSite().getShell();
    }

    protected TaskList getTaskList() {
        return this.taskList;
    }

    protected void storeValue() {
        IDialogSettings iDialogSettings = TaskList.getPlugin().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("TaskAction");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("TaskAction");
        }
        iDialogSettings2.put(this.getId(), this.isChecked());
    }

    void execute(IUndoableOperation iUndoableOperation, String string, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) {
        try {
            PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(iUndoableOperation, iProgressMonitor, iAdaptable);
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CoreException) {
                ErrorDialog.openError((Shell)WorkspaceUndoUtil.getShell(iAdaptable), (String)string, null, (IStatus)((CoreException)executionException.getCause()).getStatus());
            }
            IDEWorkbenchPlugin.log(string, executionException);
        }
    }
}

