/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.tasklist.CopyTaskAction;
import org.eclipse.ui.views.tasklist.DefaultTaskListResourceAdapter;
import org.eclipse.ui.views.tasklist.FiltersAction;
import org.eclipse.ui.views.tasklist.GotoTaskAction;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;
import org.eclipse.ui.views.tasklist.MarkCompletedAction;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.NewTaskAction;
import org.eclipse.ui.views.tasklist.PasteTaskAction;
import org.eclipse.ui.views.tasklist.PurgeCompletedAction;
import org.eclipse.ui.views.tasklist.RemoveTaskAction;
import org.eclipse.ui.views.tasklist.ResolveMarkerAction;
import org.eclipse.ui.views.tasklist.SelectAllTasksAction;
import org.eclipse.ui.views.tasklist.TaskAction;
import org.eclipse.ui.views.tasklist.TaskListContentProvider;
import org.eclipse.ui.views.tasklist.TaskPropertiesAction;
import org.eclipse.ui.views.tasklist.TaskSorter;
import org.eclipse.ui.views.tasklist.TasksFilter;

public class TaskList
extends ViewPart {
    private Table table;
    private TaskSorter comparator;
    private CellEditor descriptionEditor;
    private TableViewer viewer;
    private TasksFilter filter = new TasksFilter();
    private IMemento memento;
    private boolean markerLimitExceeded;
    private Composite parent;
    private StackLayout stackLayout = new StackLayout();
    private Composite compositeMarkerLimitExceeded;
    private CellEditorActionHandler editorActionHandler;
    private TaskAction newTaskAction;
    private TaskAction copyTaskAction;
    private TaskAction pasteTaskAction;
    private TaskAction removeTaskAction;
    private TaskAction purgeCompletedAction;
    private TaskAction gotoTaskAction;
    private TaskAction selectAllAction;
    private ResolveMarkerAction resolveMarkerAction;
    private TaskAction filtersAction;
    private MarkCompletedAction markCompletedAction;
    private TaskAction propertiesAction;
    private Action sortByCategoryAction;
    private Action sortByCompletedAction;
    private Action sortByPriorityAction;
    private Action sortByDescriptionAction;
    private Action sortByResourceAction;
    private Action sortByContainerAction;
    private Action sortByLocationAction;
    private Action sortByCreationTimeAction;
    private Action sortAscendingAction;
    private Action sortDescendingAction;
    private Clipboard clipboard;
    private static String[] tableColumnProperties = new String[]{"org.eclipse.jface.image", "done", "priority", "message", "org.eclipse.ui.tasklist.resourceName", "org.eclipse.ui.tasklist.containerName", "org.eclipse.ui.tasklist.lineAndLocation"};
    private static final String TAG_COLUMN = "column";
    private static final String TAG_NUMBER = "number";
    private static final String TAG_WIDTH = "width";
    private static final String TAG_FILTER = "filter";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_ID = "id";
    private static final String TAG_MARKER = "marker";
    private static final String TAG_RESOURCE = "resource";
    private static final String TAG_TOP_INDEX = "topIndex";
    private static final String TAG_SORT_SECTION = "TaskListSortState";
    private String[] columnHeaders = new String[]{TaskListMessages.TaskList_headerIcon, TaskListMessages.TaskList_headerCompleted, TaskListMessages.TaskList_headerPriority, TaskListMessages.TaskList_headerDescription, TaskListMessages.TaskList_headerResource, TaskListMessages.TaskList_headerFolder, TaskListMessages.TaskList_headerLocation};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(16, false, true), new ColumnPixelData(16, false, true), new ColumnPixelData(16, false, true), new ColumnWeightData(200), new ColumnWeightData(75), new ColumnWeightData(150), new ColumnWeightData(60)};
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            TaskList.this.partActivated(iWorkbenchPart);
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
            TaskList.this.partClosed(iWorkbenchPart);
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private ISelectionChangedListener focusSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            TaskList.this.focusSelectionChanged(selectionChangedEvent);
        }
    };
    private IResource[] focusResources;
    private IWorkbenchPart focusPart;
    private ISelectionProvider focusSelectionProvider;
    private ICellModifier cellModifier = new ICellModifier(){

        public Object getValue(Object object, String string) {
            return MarkerUtil.getProperty(object, string);
        }

        public boolean canModify(Object object, String string) {
            return MarkerUtil.isEditable((IMarker)object);
        }

        public void modify(Object object, String string, Object object2) {
            Item item = (Item)object;
            IMarker iMarker = (IMarker)item.getData();
            TaskList.this.setProperty(iMarker, string, object2);
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    void addDragSupport(Control control) {
        int n = 1;
        Transfer[] transferArray = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        DragSourceAdapter dragSourceAdapter = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                TaskList.this.performDragSetData(dragSourceEvent);
            }

            public void dragFinished(DragSourceEvent dragSourceEvent) {
            }
        };
        this.viewer.addDragSupport(n, transferArray, (DragSourceListener)dragSourceAdapter);
    }

    void cancelEditing() {
        this.getTableViewer().cancelEditing();
    }

    void createColumns() {
        IMemento[] iMementoArray;
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = TaskList.this.table.indexOf((TableColumn)selectionEvent.widget);
                if (n == TaskList.this.comparator.getTopPriority()) {
                    TaskList.this.comparator.reverseTopPriority();
                } else {
                    TaskList.this.comparator.setTopPriority(n);
                }
                TaskList.this.updateSortingState();
                TaskList.this.viewer.refresh();
                IDialogSettings iDialogSettings = TaskList.getPlugin().getDialogSettings();
                IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TaskList.TAG_SORT_SECTION);
                if (iDialogSettings2 == null) {
                    iDialogSettings2 = iDialogSettings.addNewSection(TaskList.TAG_SORT_SECTION);
                }
                TaskList.this.comparator.saveState(iDialogSettings2);
            }
        };
        if (this.memento != null && (iMementoArray = this.memento.getChildren(TAG_COLUMN)) != null) {
            int n = 0;
            while (n < iMementoArray.length) {
                Integer n2 = iMementoArray[n].getInteger(TAG_NUMBER);
                if (n2 != null) {
                    int n3 = n2;
                    n2 = iMementoArray[n].getInteger(TAG_WIDTH);
                    if (n2 != null) {
                        this.columnLayouts[n3] = new ColumnPixelData(n2.intValue(), true);
                    }
                }
                ++n;
            }
        }
        boolean bl = Util.isMac();
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        int n = 0;
        while (n < this.columnHeaders.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0, n);
            if (!bl && n == 1) {
                tableColumn.setImage(MarkerUtil.getImage("header_complete"));
            } else if (!bl && n == 2) {
                tableColumn.setImage(MarkerUtil.getImage("header_priority"));
            } else {
                tableColumn.setText(this.columnHeaders[n]);
            }
            if (bl && (n == 1 || n == 2)) {
                tableColumn.pack();
                this.columnLayouts[n] = new ColumnPixelData(Math.max(16, tableColumn.getWidth()), false, true);
            }
            tableColumn.setResizable(this.columnLayouts[n].resizable);
            tableLayout.addColumnData(this.columnLayouts[n]);
            tableColumn.addSelectionListener((SelectionListener)selectionAdapter);
            ++n;
        }
    }

    static String createMarkerReport(IMarker[] iMarkerArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TaskListMessages.TaskList_reportKind);
        stringBuffer.append("\t");
        stringBuffer.append(TaskListMessages.TaskList_reportStatus);
        stringBuffer.append("\t");
        stringBuffer.append(TaskListMessages.TaskList_reportPriority);
        stringBuffer.append("\t");
        stringBuffer.append(TaskListMessages.TaskList_headerDescription);
        stringBuffer.append("\t");
        stringBuffer.append(TaskListMessages.TaskList_headerResource);
        stringBuffer.append("\t");
        stringBuffer.append(TaskListMessages.TaskList_headerFolder);
        stringBuffer.append("\t");
        stringBuffer.append(TaskListMessages.TaskList_headerLocation);
        stringBuffer.append(System.getProperty("line.separator"));
        int n = 0;
        while (n < iMarkerArray.length) {
            TaskList.writeMarker(stringBuffer, iMarkerArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static void writeMarker(StringBuffer stringBuffer, IMarker iMarker) {
        stringBuffer.append(MarkerUtil.getKindText(iMarker));
        stringBuffer.append("\t");
        stringBuffer.append(MarkerUtil.getCompleteText(iMarker));
        stringBuffer.append("\t");
        stringBuffer.append(MarkerUtil.getPriorityText(iMarker));
        stringBuffer.append("\t");
        stringBuffer.append(MarkerUtil.getMessage(iMarker));
        stringBuffer.append("\t");
        stringBuffer.append(MarkerUtil.getResourceName(iMarker));
        stringBuffer.append("\t");
        stringBuffer.append(MarkerUtil.getContainerName(iMarker));
        stringBuffer.append("\t");
        stringBuffer.append(MarkerUtil.getLineAndLocation(iMarker));
        stringBuffer.append(System.getProperty("line.separator"));
    }

    boolean isMarkerLimitExceeded() {
        return this.markerLimitExceeded;
    }

    void setMarkerLimitExceeded(boolean bl) {
        this.markerLimitExceeded = bl;
        this.stackLayout.topControl = bl ? this.compositeMarkerLimitExceeded : this.table;
        this.parent.layout();
    }

    public void createPartControl(Composite composite) {
        this.createPartControl0(composite);
    }

    private void createPartControl0(Composite composite) {
        IMemento iMemento;
        this.parent = composite;
        this.clipboard = new Clipboard(composite.getDisplay());
        this.createTable(composite);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.createColumns();
        this.makeActions();
        this.fillActionBars();
        this.addDragSupport((Control)this.table);
        this.compositeMarkerLimitExceeded = new Composite(composite, 0);
        this.compositeMarkerLimitExceeded.setLayout((Layout)new GridLayout());
        Label label = new Label(this.compositeMarkerLimitExceeded, 64);
        label.setText(TaskListMessages.TaskList_markerLimitExceeded);
        composite.setLayout((Layout)this.stackLayout);
        this.setMarkerLimitExceeded(false);
        this.viewer.setContentProvider((IContentProvider)new TaskListContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TaskListLabelProvider());
        if (this.memento != null && (iMemento = this.memento.getChild(TAG_FILTER)) != null) {
            this.getFilter().restoreState(iMemento);
        }
        this.comparator = new TaskSorter();
        iMemento = TaskList.getPlugin().getDialogSettings();
        IDialogSettings iDialogSettings = iMemento.getSection(TAG_SORT_SECTION);
        this.comparator.restoreState(iDialogSettings);
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.updateSortingState();
        this.viewer.setInput((Object)this.getWorkspace().getRoot());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TaskList.this.selectionChanged(selectionChangedEvent);
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                TaskList.this.gotoTaskAction.run();
            }
        });
        this.viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                TaskList.this.handleKeyPressed(keyEvent);
            }
        });
        this.viewer.getControl().getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent accessibleControlEvent) {
                int n = accessibleControlEvent.childID;
                if (n == -1) {
                    super.getValue(accessibleControlEvent);
                    return;
                }
                Object object = TaskList.this.viewer.getElementAt(n);
                if (object instanceof IMarker) {
                    IMarker iMarker = (IMarker)object;
                    accessibleControlEvent.result = MarkerUtil.isEditable(iMarker) ? MarkerUtil.getCompleteText(iMarker) : MarkerUtil.getKindText(iMarker);
                } else {
                    super.getValue(accessibleControlEvent);
                    return;
                }
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[this.columnHeaders.length];
        cellEditorArray[1] = new CheckboxCellEditor((Composite)this.table);
        String[] stringArray = new String[]{TaskListMessages.TaskList_high, TaskListMessages.TaskList_normal, TaskListMessages.TaskList_low};
        cellEditorArray[2] = new ComboBoxCellEditor((Composite)this.table, stringArray, 8);
        cellEditorArray[3] = this.descriptionEditor = new TextCellEditor((Composite)this.table);
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier(this.cellModifier);
        this.viewer.setColumnProperties(tableColumnProperties);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                TaskList.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getSite().getPage().addPartListener(this.partListener);
        this.editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this.editorActionHandler.addCellEditor(this.descriptionEditor);
        this.editorActionHandler.setCopyAction((IAction)this.copyTaskAction);
        this.editorActionHandler.setPasteAction((IAction)this.pasteTaskAction);
        this.editorActionHandler.setDeleteAction((IAction)this.removeTaskAction);
        this.editorActionHandler.setSelectAllAction((IAction)this.selectAllAction);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        if (this.memento != null) {
            this.restoreState(this.memento);
        }
        this.memento = null;
        this.viewer.getControl().addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                String string = null;
                IMarker iMarker = (IMarker)((IStructuredSelection)TaskList.this.getSelection()).getFirstElement();
                if (iMarker != null) {
                    string = IDE.getMarkerHelpRegistry().getHelp(iMarker);
                }
                if (string == null) {
                    string = "org.eclipse.ui.task_list_view_context";
                }
                TaskList.this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().displayHelp(string);
            }
        });
        this.updateStatusMessage();
        this.updateTitle();
    }

    void createTable(Composite composite) {
        this.table = new Table(composite, 66306);
        this.table.setLinesVisible(true);
        new TableEditor(this.table);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.focusSelectionProvider != null) {
            this.focusSelectionProvider.removeSelectionChangedListener(this.focusSelectionChangedListener);
            this.focusSelectionProvider = null;
        }
        this.focusPart = null;
        if (this.editorActionHandler != null) {
            this.editorActionHandler.dispose();
            this.editorActionHandler = null;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }

    public void edit(IMarker iMarker) {
        this.viewer.editElement((Object)iMarker, 3);
    }

    void fillActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IMenuManager iMenuManager = iActionBars.getMenuManager();
        MenuManager menuManager = new MenuManager(TaskListMessages.SortByMenu_text);
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.sortByCategoryAction);
        menuManager.add((IAction)this.sortByCompletedAction);
        menuManager.add((IAction)this.sortByPriorityAction);
        menuManager.add((IAction)this.sortByDescriptionAction);
        menuManager.add((IAction)this.sortByResourceAction);
        menuManager.add((IAction)this.sortByContainerAction);
        menuManager.add((IAction)this.sortByLocationAction);
        menuManager.add((IAction)this.sortByCreationTimeAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.sortAscendingAction);
        menuManager.add((IAction)this.sortDescendingAction);
        iMenuManager.add((IAction)this.filtersAction);
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.newTaskAction);
        iToolBarManager.add((IAction)this.removeTaskAction);
        iToolBarManager.add((IAction)this.filtersAction);
    }

    void fillContextMenu(IMenuManager iMenuManager) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getSelection();
        this.markCompletedAction.setEnabled(this.markCompletedAction.shouldEnable(iStructuredSelection));
        this.resolveMarkerAction.setEnabled(this.resolveMarkerAction.shouldEnable(iStructuredSelection));
        iMenuManager.add((IAction)this.newTaskAction);
        iMenuManager.add((IAction)this.gotoTaskAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.copyTaskAction);
        iMenuManager.add((IAction)this.pasteTaskAction);
        iMenuManager.add((IAction)this.removeTaskAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.markCompletedAction);
        iMenuManager.add((IAction)this.purgeCompletedAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.resolveMarkerAction);
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        iMenuManager.add((IAction)this.propertiesAction);
    }

    void filterChanged() {
        BusyIndicator.showWhile((Display)this.viewer.getControl().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                TaskList.this.viewer.getControl().setRedraw(false);
                TaskList.this.viewer.refresh(false);
                TaskList.this.viewer.getControl().setRedraw(true);
                TaskList.this.updateStatusMessage();
                TaskList.this.updateTitle();
            }
        });
    }

    void focusSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateFocusResource(selectionChangedEvent.getSelection());
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, TaskList.this.getSelection());
                }
            };
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(clazz);
    }

    Clipboard getClipboard() {
        return this.clipboard;
    }

    TasksFilter getFilter() {
        return this.filter;
    }

    static AbstractUIPlugin getPlugin() {
        return (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
    }

    public IResource getResource() {
        if (this.showSelections() && this.focusResources != null && this.focusResources.length >= 1 && this.focusResources[0] != null) {
            return this.focusResources[0];
        }
        return this.getWorkspace().getRoot();
    }

    public IResource[] getResources() {
        if (this.showSelections() && this.focusResources != null) {
            return this.focusResources;
        }
        return new IResource[]{this.getWorkspace().getRoot()};
    }

    int getResourceDepth() {
        if (this.showSelections() && !this.showChildrenHierarchy()) {
            return 0;
        }
        return 2;
    }

    public ISelection getSelection() {
        return this.viewer.getSelection();
    }

    String getStatusMessage(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection != null && iStructuredSelection.size() == 1) {
            IMarker iMarker = (IMarker)iStructuredSelection.getFirstElement();
            return MarkerUtil.getMessage(iMarker);
        }
        TaskListContentProvider taskListContentProvider = (TaskListContentProvider)this.viewer.getContentProvider();
        if (iStructuredSelection != null && iStructuredSelection.size() > 1) {
            return taskListContentProvider.getStatusSummarySelected(iStructuredSelection);
        }
        return taskListContentProvider.getStatusSummaryVisible();
    }

    TableViewer getTableViewer() {
        return this.viewer;
    }

    IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    void handleKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0 && this.removeTaskAction.isEnabled()) {
            this.removeTaskAction.run();
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    boolean checkResource(IResource iResource) {
        IResource iResource2;
        int n;
        if (!this.showSelections()) {
            return true;
        }
        IResource[] iResourceArray = this.getResources();
        if (this.showOwnerProject()) {
            n = 0;
            int n2 = iResourceArray.length;
            while (n < n2) {
                iResource2 = iResourceArray[n];
                if (iResource2 == null) {
                    return true;
                }
                IProject iProject = iResource2.getProject();
                if (iProject == null || iProject.equals((Object)iResource.getProject())) {
                    return true;
                }
                ++n;
            }
        }
        if (this.showChildrenHierarchy()) {
            int n3 = 0;
            n = iResourceArray.length;
            while (n3 < n) {
                iResource2 = iResourceArray[n3];
                if (iResource2 != null && iResource2.getFullPath().isPrefixOf(iResource.getFullPath())) {
                    return true;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            n = iResourceArray.length;
            while (n4 < n) {
                iResource2 = iResourceArray[n4];
                if (iResource.equals((Object)iResource2)) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    boolean shouldShow(IMarker iMarker) {
        return this.checkResource(iMarker.getResource()) && this.getFilter().select(iMarker);
    }

    void makeActions() {
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.gotoTaskAction = new GotoTaskAction(this, "gotoFile");
        this.gotoTaskAction.setText(TaskListMessages.GotoTask_text);
        this.gotoTaskAction.setToolTipText(TaskListMessages.GotoTask_tooltip);
        this.gotoTaskAction.setImageDescriptor(MarkerUtil.getImageDescriptor("gotoobj"));
        this.gotoTaskAction.setEnabled(false);
        this.newTaskAction = new NewTaskAction(this, "newTask");
        this.newTaskAction.setText(TaskListMessages.NewTask_text);
        this.newTaskAction.setToolTipText(TaskListMessages.NewTask_tooltip);
        this.newTaskAction.setImageDescriptor(MarkerUtil.getImageDescriptor("addtsk"));
        this.newTaskAction.setDisabledImageDescriptor(MarkerUtil.getImageDescriptor("addtsk_disabled"));
        this.copyTaskAction = new CopyTaskAction(this, "copy");
        this.copyTaskAction.setText(TaskListMessages.CopyTask_text);
        this.copyTaskAction.setToolTipText(TaskListMessages.CopyTask_tooltip);
        this.copyTaskAction.setEnabled(false);
        this.pasteTaskAction = new PasteTaskAction(this, "paste");
        this.pasteTaskAction.setText(TaskListMessages.PasteTask_text);
        this.pasteTaskAction.setToolTipText(TaskListMessages.PasteTask_tooltip);
        this.pasteTaskAction.setEnabled(false);
        this.removeTaskAction = new RemoveTaskAction(this, "delete");
        this.removeTaskAction.setText(TaskListMessages.RemoveTask_text);
        this.removeTaskAction.setToolTipText(TaskListMessages.RemoveTask_tooltip);
        this.removeTaskAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.removeTaskAction.setDisabledImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.removeTaskAction.setEnabled(false);
        this.markCompletedAction = new MarkCompletedAction(this, "markCompleted");
        this.markCompletedAction.setText(TaskListMessages.MarkCompleted_text);
        this.markCompletedAction.setToolTipText(TaskListMessages.MarkCompleted_tooltip);
        this.markCompletedAction.setEnabled(false);
        this.purgeCompletedAction = new PurgeCompletedAction(this, "deleteCompleted");
        this.purgeCompletedAction.setText(TaskListMessages.PurgeCompleted_text);
        this.purgeCompletedAction.setToolTipText(TaskListMessages.PurgeCompleted_tooltip);
        this.purgeCompletedAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.purgeCompletedAction.setEnabled(true);
        this.selectAllAction = new SelectAllTasksAction(this, "selectAll");
        this.selectAllAction.setText(TaskListMessages.SelectAll_text);
        this.selectAllAction.setToolTipText(TaskListMessages.SelectAll_tooltip);
        this.resolveMarkerAction = new ResolveMarkerAction(this, "resolve");
        this.resolveMarkerAction.setText(TaskListMessages.Resolve_text);
        this.resolveMarkerAction.setToolTipText(TaskListMessages.Resolve_tooltip);
        this.resolveMarkerAction.setEnabled(false);
        this.sortByCategoryAction = new SortByAction(0);
        this.sortByCategoryAction.setText(TaskListMessages.SortByCategory_text);
        this.sortByCategoryAction.setToolTipText(TaskListMessages.SortByCategory_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCategoryAction, "org.eclipse.ui.task_sort_type_action_context");
        this.sortByCompletedAction = new SortByAction(1);
        this.sortByCompletedAction.setText(TaskListMessages.SortByCompleted_text);
        this.sortByCompletedAction.setToolTipText(TaskListMessages.SortByCompleted_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCompletedAction, "org.eclipse.ui.task_sort_completed_action_context");
        this.sortByPriorityAction = new SortByAction(2);
        this.sortByPriorityAction.setText(TaskListMessages.SortByPriority_text);
        this.sortByPriorityAction.setToolTipText(TaskListMessages.SortByPriority_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByPriorityAction, "org.eclipse.ui.task_sort_priority_action_context");
        this.sortByDescriptionAction = new SortByAction(3);
        this.sortByDescriptionAction.setText(TaskListMessages.SortByDescription_text);
        this.sortByDescriptionAction.setToolTipText(TaskListMessages.SortByDescription_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByDescriptionAction, "org.eclipse.ui.task_sort_description_action_context");
        this.sortByResourceAction = new SortByAction(4);
        this.sortByResourceAction.setText(TaskListMessages.SortByResource_text);
        this.sortByResourceAction.setToolTipText(TaskListMessages.SortByResource_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByResourceAction, "org.eclipse.ui.task_sort_resource_action_context");
        this.sortByContainerAction = new SortByAction(5);
        this.sortByContainerAction.setText(TaskListMessages.SortByContainer_text);
        this.sortByContainerAction.setToolTipText(TaskListMessages.SortByContainer_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByContainerAction, "org.eclipse.ui.task_sort_folder_action_context");
        this.sortByLocationAction = new SortByAction(6);
        this.sortByLocationAction.setText(TaskListMessages.SortByLocation_text);
        this.sortByLocationAction.setToolTipText(TaskListMessages.SortByLocation_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByLocationAction, "org.eclipse.ui.task_sort_location_action_context");
        this.sortByCreationTimeAction = new SortByAction(7);
        this.sortByCreationTimeAction.setText(TaskListMessages.SortByCreationTime_text);
        this.sortByCreationTimeAction.setToolTipText(TaskListMessages.SortByCreationTime_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortByCreationTimeAction, "org.eclipse.ui.task_sort_creation_time_action_context");
        this.sortAscendingAction = new SortDirectionAction(1);
        this.sortAscendingAction.setText(TaskListMessages.SortAscending_text);
        this.sortAscendingAction.setToolTipText(TaskListMessages.SortAscending_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortAscendingAction, "org.eclipse.ui.task_sort_ascending_action_context");
        this.sortDescendingAction = new SortDirectionAction(-1);
        this.sortDescendingAction.setText(TaskListMessages.SortDescending_text);
        this.sortDescendingAction.setToolTipText(TaskListMessages.SortDescending_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.sortDescendingAction, "org.eclipse.ui.task_sort_descending_action_context");
        this.filtersAction = new FiltersAction(this, TAG_FILTER);
        this.filtersAction.setText(TaskListMessages.Filters_text);
        this.filtersAction.setToolTipText(TaskListMessages.Filters_tooltip);
        this.filtersAction.setImageDescriptor(MarkerUtil.getImageDescriptor(TAG_FILTER));
        this.propertiesAction = new TaskPropertiesAction(this, "properties");
        this.propertiesAction.setText(TaskListMessages.Properties_text);
        this.propertiesAction.setToolTipText(TaskListMessages.Properties_tooltip);
        this.propertiesAction.setEnabled(false);
    }

    void markersChanged() {
        this.updateStatusMessage();
        this.updateTitle();
    }

    void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this.focusPart) {
            return;
        }
        if (this.focusSelectionProvider != null) {
            this.focusSelectionProvider.removeSelectionChangedListener(this.focusSelectionChangedListener);
            this.focusSelectionProvider = null;
        }
        this.focusPart = iWorkbenchPart;
        if (this.focusPart != null) {
            this.focusSelectionProvider = this.focusPart.getSite().getSelectionProvider();
            if (this.focusSelectionProvider != null) {
                this.focusSelectionProvider.addSelectionChangedListener(this.focusSelectionChangedListener);
                this.updateFocusResource(this.focusSelectionProvider.getSelection());
            } else {
                this.updateFocusResource(null);
            }
        }
    }

    void partClosed(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart != this.focusPart) {
            return;
        }
        if (this.focusSelectionProvider != null) {
            this.focusSelectionProvider.removeSelectionChangedListener(this.focusSelectionChangedListener);
            this.focusSelectionProvider = null;
        }
        this.focusPart = null;
    }

    void performDragSetData(DragSourceEvent dragSourceEvent) {
        if (MarkerTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            dragSourceEvent.data = ((IStructuredSelection)this.viewer.getSelection()).toArray();
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(dragSourceEvent.dataType)) {
            Object[] objectArray = ((IStructuredSelection)this.viewer.getSelection()).toArray();
            if (objectArray != null) {
                IMarker[] iMarkerArray = new IMarker[objectArray.length];
                int n = 0;
                while (n < iMarkerArray.length) {
                    iMarkerArray[n] = (IMarker)objectArray[n];
                    ++n;
                }
                dragSourceEvent.data = TaskList.createMarkerReport(iMarkerArray);
            }
            return;
        }
    }

    void restoreState(IMemento iMemento) {
        Object object;
        Table table;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IMemento iMemento2 = iMemento.getChild(TAG_SELECTION);
        if (iMemento2 != null) {
            table = new ArrayList();
            object = iMemento2.getChildren(TAG_MARKER);
            int n = 0;
            while (n < ((IMemento[])object).length) {
                try {
                    IMarker iMarker;
                    long l = Long.parseLong(object[n].getString(TAG_ID));
                    IResource iResource = iWorkspaceRoot.findMember(object[n].getString(TAG_RESOURCE));
                    if (iResource != null && (iMarker = iResource.findMarker(l)) != null) {
                        table.add(iMarker);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (CoreException coreException) {}
                ++n;
            }
            this.viewer.setSelection((ISelection)new StructuredSelection((List)table));
        }
        table = this.viewer.getTable();
        try {
            object = iMemento.getString(TAG_TOP_INDEX);
            table.setTopIndex(Integer.parseInt((String)object));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void saveState(IMemento iMemento) {
        Object[] objectArray;
        IMemento iMemento2;
        if (this.viewer == null) {
            if (this.memento != null) {
                iMemento.putMemento(this.memento);
            }
            return;
        }
        this.getFilter().saveState(iMemento.createChild(TAG_FILTER));
        Table table = this.viewer.getTable();
        TableColumn[] tableColumnArray = table.getColumns();
        boolean bl = false;
        int n = 0;
        while (n < tableColumnArray.length) {
            if (this.columnLayouts[n].resizable && tableColumnArray[n].getWidth() != 0) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < tableColumnArray.length) {
                if (this.columnLayouts[n].resizable) {
                    iMemento2 = iMemento.createChild(TAG_COLUMN);
                    iMemento2.putInteger(TAG_NUMBER, n);
                    iMemento2.putInteger(TAG_WIDTH, tableColumnArray[n].getWidth());
                }
                ++n;
            }
        }
        if ((objectArray = ((IStructuredSelection)this.viewer.getSelection()).toArray()).length > 0) {
            iMemento2 = iMemento.createChild(TAG_SELECTION);
            int n2 = 0;
            while (n2 < objectArray.length) {
                IMemento iMemento3 = iMemento2.createChild(TAG_MARKER);
                IMarker iMarker = (IMarker)objectArray[n2];
                iMemento3.putString(TAG_RESOURCE, iMarker.getResource().getFullPath().toString());
                iMemento3.putString(TAG_ID, String.valueOf(iMarker.getId()));
                ++n2;
            }
        }
        int n3 = table.getTopIndex();
        iMemento.putString(TAG_TOP_INDEX, String.valueOf(n3));
    }

    void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IMarker iMarker;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        this.updateStatusMessage(iStructuredSelection);
        this.updateTitle();
        this.updatePasteEnablement();
        if (iStructuredSelection.isEmpty()) {
            this.copyTaskAction.setEnabled(false);
            this.removeTaskAction.setEnabled(false);
            this.gotoTaskAction.setEnabled(false);
            this.propertiesAction.setEnabled(false);
            return;
        }
        this.propertiesAction.setEnabled(iStructuredSelection.size() == 1);
        this.copyTaskAction.setEnabled(true);
        IMarker iMarker2 = (IMarker)iStructuredSelection.getFirstElement();
        boolean bl = iStructuredSelection.size() == 1 && iMarker2.getResource().getType() == 1;
        this.gotoTaskAction.setEnabled(bl);
        boolean bl2 = true;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            iMarker = (IMarker)iterator.next();
            if (MarkerUtil.isEditable(iMarker)) continue;
            bl2 = false;
            break;
        }
        this.removeTaskAction.setEnabled(bl2);
        if (bl && (iterator = this.getSite().getPage().getActiveEditor()) != null && (iMarker = ResourceUtil.getFile(iterator.getEditorInput())) != null && iMarker2.getResource().equals((Object)iMarker)) {
            IDE.gotoMarker((IEditorPart)iterator, iMarker2);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void setProperty(IMarker iMarker, String string, Object object) {
        if (MarkerUtil.getProperty(iMarker, string).equals(object)) {
            return;
        }
        try {
            if (string == tableColumnProperties[1]) {
                iMarker.setAttribute("done", object);
            } else if (string == tableColumnProperties[2]) {
                iMarker.setAttribute("priority", 2 - (Integer)object);
            } else if (string == tableColumnProperties[3]) {
                iMarker.setAttribute("message", object);
            }
        }
        catch (CoreException coreException) {
            String string2 = TaskListMessages.TaskList_errorModifyingTask;
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)string2, null, (IStatus)coreException.getStatus());
        }
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        Assert.isTrue((boolean)(iSelection instanceof IStructuredSelection));
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Assert.isTrue((boolean)(iterator.next() instanceof IMarker));
        }
        if (this.viewer != null) {
            this.viewer.setSelection(iSelection, bl);
        }
    }

    boolean showChildrenHierarchy() {
        switch (this.getFilter().onResource) {
            default: {
                return true;
            }
            case 1: 
        }
        return false;
    }

    boolean showSelections() {
        switch (this.getFilter().onResource) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    boolean showOwnerProject() {
        return this.getFilter().onResource == 3;
    }

    void toggleInputSelection(boolean bl) {
    }

    void toggleLockInput(boolean bl) {
    }

    void updateFocusResource(ISelection iSelection) {
        int n;
        Object object;
        Iterator iterator;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (iSelection instanceof IStructuredSelection) {
            iterator = ((IStructuredSelection)iSelection).iterator();
            while (iterator.hasNext()) {
                Object object2;
                ITaskListResourceAdapter iTaskListResourceAdapter;
                IResource iResource;
                object = iterator.next();
                if (!(object instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.views.tasklist.ITaskListResourceAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (iTaskListResourceAdapter = (object2 = iAdaptable.getAdapter((Class)clazz)) != null && object2 instanceof ITaskListResourceAdapter ? (ITaskListResourceAdapter)object2 : DefaultTaskListResourceAdapter.getDefault()).getAffectedResource((IAdaptable)object)) == null) continue;
                arrayList.add(iResource);
            }
        }
        if (arrayList.size() == 0 && this.focusPart instanceof IEditorPart && (iterator = ((IEditorPart)this.focusPart).getEditorInput()) != null && (object = ResourceUtil.getResource((IEditorInput)iterator)) != null) {
            arrayList.add(object);
        }
        if ((n = arrayList.size()) < 1) {
            return;
        }
        object = arrayList.toArray(new IResource[n]);
        int n2 = 0;
        while (n2 < n) {
            Assert.isNotNull(object[n2]);
            ++n2;
        }
        if (!Arrays.equals(object, this.focusResources)) {
            n2 = 0;
            if (this.showOwnerProject()) {
                int n3;
                int n4 = n3 = this.focusResources == null ? 0 : this.focusResources.length;
                if (n != n3) {
                    n2 = 1;
                } else {
                    int n5 = 0;
                    while (n5 < n) {
                        boolean bl;
                        IProject iProject = n3 < 1 ? null : this.focusResources[0].getProject();
                        IProject iProject2 = object[0].getProject();
                        boolean bl2 = iProject == null ? iProject2 == null : (bl = iProject.equals((Object)iProject2));
                        if (!bl) {
                            n2 = 1;
                            break;
                        }
                        ++n5;
                    }
                }
            } else if (this.showSelections()) {
                n2 = 1;
            }
            this.focusResources = object;
            if (n2 != 0) {
                this.viewer.getControl().setRedraw(false);
                this.viewer.refresh();
                this.viewer.getControl().setRedraw(true);
                this.updateStatusMessage();
                this.updateTitle();
            }
        }
    }

    void updatePasteEnablement() {
        MarkerTransfer markerTransfer = MarkerTransfer.getInstance();
        IMarker[] iMarkerArray = (IMarker[])this.getClipboard().getContents((Transfer)markerTransfer);
        boolean bl = false;
        if (iMarkerArray != null) {
            int n = 0;
            while (n < iMarkerArray.length) {
                if (MarkerUtil.isMarkerType(iMarkerArray[n], "org.eclipse.core.resources.taskmarker")) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        this.pasteTaskAction.setEnabled(bl);
    }

    void updateStatusMessage() {
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            this.updateStatusMessage((IStructuredSelection)iSelection);
        } else {
            this.updateStatusMessage(null);
        }
    }

    void updateStatusMessage(IStructuredSelection iStructuredSelection) {
        String string = this.getStatusMessage(iStructuredSelection);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(string);
    }

    void updateTitle() {
        TaskListContentProvider taskListContentProvider = (TaskListContentProvider)this.getTableViewer().getContentProvider();
        String string = taskListContentProvider.getTitleSummary();
        this.setContentDescription(string);
    }

    void updateSortingState() {
        int n = this.comparator.getTopPriority();
        this.sortByCategoryAction.setChecked(n == 0);
        this.sortByCompletedAction.setChecked(n == 1);
        this.sortByPriorityAction.setChecked(n == 2);
        this.sortByDescriptionAction.setChecked(n == 3);
        this.sortByResourceAction.setChecked(n == 4);
        this.sortByContainerAction.setChecked(n == 5);
        this.sortByLocationAction.setChecked(n == 6);
        this.sortByCreationTimeAction.setChecked(n == 7);
        int n2 = this.comparator.getTopPriorityDirection();
        this.sortAscendingAction.setChecked(n2 == 1);
        this.sortDescendingAction.setChecked(n2 == -1);
    }

    class SortByAction
    extends Action {
        private int column;

        public SortByAction(int n) {
            this.column = n;
        }

        public void run() {
            TaskList.this.comparator.setTopPriority(this.column);
            TaskList.this.updateSortingState();
            TaskList.this.viewer.refresh();
            IDialogSettings iDialogSettings = TaskList.getPlugin().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TaskList.TAG_SORT_SECTION);
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection(TaskList.TAG_SORT_SECTION);
            }
            TaskList.this.comparator.saveState(iDialogSettings2);
        }
    }

    class SortDirectionAction
    extends Action {
        private int direction;

        public SortDirectionAction(int n) {
            this.direction = n;
        }

        public void run() {
            TaskList.this.comparator.setTopPriorityDirection(this.direction);
            TaskList.this.updateSortingState();
            TaskList.this.viewer.refresh();
            IDialogSettings iDialogSettings = TaskList.getPlugin().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TaskList.TAG_SORT_SECTION);
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection(TaskList.TAG_SORT_SECTION);
            }
            TaskList.this.comparator.saveState(iDialogSettings2);
        }
    }

    static class TaskListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static String[] keys = new String[]{"org.eclipse.jface.image", "org.eclipse.ui.tasklist.completeImage", "org.eclipse.ui.tasklist.priorityImage", "message", "org.eclipse.ui.tasklist.resourceName", "org.eclipse.ui.tasklist.containerName", "org.eclipse.ui.tasklist.lineAndLocation"};

        TaskListLabelProvider() {
        }

        public String getColumnText(Object object, int n) {
            if (n >= 3 && n <= 6) {
                return (String)MarkerUtil.getProperty(object, keys[n]);
            }
            return "";
        }

        public Image getColumnImage(Object object, int n) {
            if (n >= 0 && n <= 2) {
                return (Image)MarkerUtil.getProperty(object, keys[n]);
            }
            return null;
        }
    }
}

