/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerUtil;
import org.eclipse.ui.views.tasklist.TaskList;
import org.eclipse.ui.views.tasklist.TasksFilter;

class TaskListContentProvider
implements IStructuredContentProvider,
IResourceChangeListener {
    private static final int TASKS = 0;
    private static final int ERRORS = 1;
    private static final int WARNINGS = 2;
    private static final int INFOS = 3;
    private TaskList taskList;
    private TableViewer viewer;
    private IResource input;
    private int[] visibleMarkerCounts = null;
    private int totalMarkerCount = -1;

    public TaskListContentProvider(TaskList taskList) {
        this.taskList = taskList;
        this.viewer = taskList.getTableViewer();
    }

    private boolean getFilterOnMarkerLimit() {
        return this.taskList.getFilter().getFilterOnMarkerLimit();
    }

    private int getMarkerLimit() {
        return this.taskList.getFilter().getMarkerLimit();
    }

    private boolean isMarkerLimitExceeded() {
        return this.taskList.isMarkerLimitExceeded();
    }

    private void setMarkerLimitExceeded(boolean bl) {
        this.taskList.setMarkerLimitExceeded(bl);
    }

    public String getStatusSummaryVisible() {
        if (this.visibleMarkerCounts == null) {
            return "";
        }
        return NLS.bind((String)TaskListMessages.TaskList_statusSummaryVisible, (Object)new Integer(this.sum(this.visibleMarkerCounts)), (Object)this.getStatusSummaryBreakdown(this.visibleMarkerCounts));
    }

    public String getStatusSummarySelected(IStructuredSelection iStructuredSelection) {
        int[] nArray = this.getMarkerCounts(iStructuredSelection.toList());
        return NLS.bind((String)TaskListMessages.TaskList_statusSummarySelected, (Object)new Integer(this.sum(nArray)), (Object)this.getStatusSummaryBreakdown(nArray));
    }

    private String getStatusSummaryBreakdown(int[] nArray) {
        return NLS.bind((String)TaskListMessages.TaskList_statusSummaryBreakdown, (Object[])new Object[]{new Integer(nArray[0]), new Integer(nArray[1]), new Integer(nArray[2]), new Integer(nArray[3])});
    }

    public String getTitleSummary() {
        if (this.visibleMarkerCounts == null) {
            return "";
        }
        int n = this.sum(this.visibleMarkerCounts);
        TasksFilter tasksFilter = this.taskList.getFilter();
        if (tasksFilter.isShowingAll()) {
            return NLS.bind((String)TaskListMessages.TaskList_titleSummaryUnfiltered, (Object)new Integer(n));
        }
        return NLS.bind((String)TaskListMessages.TaskList_titleSummaryFiltered, (Object)new Integer(n), (Object)new Integer(this.getTotalMarkerCount()));
    }

    private int sum(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        while (n2 < n3) {
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    private int getTotalMarkerCount() {
        if (this.totalMarkerCount == -1) {
            this.totalMarkerCount = 0;
            try {
                IWorkspaceRoot iWorkspaceRoot = this.taskList.getWorkspace().getRoot();
                IMarker[] iMarkerArray = iWorkspaceRoot.findMarkers(null, true, 2);
                int n = 0;
                while (n < iMarkerArray.length) {
                    if (this.isRootType(iMarkerArray[n])) {
                        ++this.totalMarkerCount;
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
        return this.totalMarkerCount;
    }

    private boolean isRootType(IMarker iMarker) {
        String[] stringArray = TasksFilter.ROOT_TYPES;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (MarkerUtil.isMarkerType(iMarker, stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private IMarker[] getMarkers() throws CoreException {
        TasksFilter tasksFilter;
        IResource iResource;
        IResource[] iResourceArray = this.taskList.getResources();
        int n = iResourceArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            iResource = iResourceArray[n2];
            if (iResource != null && iResource.exists()) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return new IMarker[0];
        }
        if (this.taskList.showOwnerProject()) {
            IResource[] iResourceArray2 = new IResource[n];
            int n3 = 0;
            while (n3 < n) {
                iResource = iResourceArray[n3];
                if (iResource != null) {
                    tasksFilter = iResource.getProject();
                    iResourceArray2[n3] = tasksFilter != null ? tasksFilter : iResource;
                }
                ++n3;
            }
            iResourceArray = iResourceArray2;
        }
        int n4 = this.taskList.getResourceDepth();
        tasksFilter = this.taskList.getFilter();
        HashSet<IMarker> hashSet = new HashSet<IMarker>();
        int n5 = 0;
        while (n5 < n) {
            iResource = iResourceArray[n5];
            if (iResource != null) {
                IMarker[] iMarkerArray = iResource.findMarkers(null, true, n4);
                int n6 = 0;
                while (n6 < iMarkerArray.length) {
                    IMarker iMarker = iMarkerArray[n6];
                    if (tasksFilter.select(iMarker)) {
                        hashSet.add(iMarker);
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        IMarker[] iMarkerArray = new IMarker[hashSet.size()];
        hashSet.toArray(iMarkerArray);
        return iMarkerArray;
    }

    private int[] getMarkerCounts(List list) {
        int[] nArray = new int[4];
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMarker iMarker = (IMarker)iterator.next();
            if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.problemmarker")) {
                switch (MarkerUtil.getSeverity(iMarker)) {
                    case 2: {
                        nArray[1] = nArray[1] + 1;
                        break;
                    }
                    case 1: {
                        nArray[2] = nArray[2] + 1;
                        break;
                    }
                    case 0: {
                        nArray[3] = nArray[3] + 1;
                    }
                }
                continue;
            }
            if (!MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) continue;
            nArray[0] = nArray[0] + 1;
        }
        return nArray;
    }

    private void updateMarkerCounts(IMarkerDelta iMarkerDelta, int n) {
        if (this.visibleMarkerCounts == null) {
            return;
        }
        if (iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            int n2 = iMarkerDelta.getAttribute("severity", 1);
            switch (n2) {
                case 2: {
                    this.visibleMarkerCounts[1] = this.visibleMarkerCounts[1] + n;
                    break;
                }
                case 1: {
                    this.visibleMarkerCounts[2] = this.visibleMarkerCounts[2] + n;
                    break;
                }
                case 0: {
                    this.visibleMarkerCounts[3] = this.visibleMarkerCounts[3] + n;
                }
            }
        } else if (iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            this.visibleMarkerCounts[0] = this.visibleMarkerCounts[0] + n;
        }
    }

    private void updateViewer(List list, List list2, List list3) {
        Control control = this.viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (list2.size() > 0) {
            this.viewer.cancelEditing();
            this.viewer.remove(list2.toArray());
        }
        if (list.size() > 0) {
            this.viewer.add(list.toArray());
        }
        if (list3.size() > 0) {
            this.viewer.update(list3.toArray(), null);
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.input = null;
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (this.input != null) {
            this.input.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.input = (IResource)object2;
        if (this.input != null) {
            this.input.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.viewer = (TableViewer)viewer;
    }

    public Object[] getElements(Object object) {
        try {
            Object[] objectArray = this.getMarkers();
            this.visibleMarkerCounts = this.getMarkerCounts(Arrays.asList(objectArray));
            if (this.getFilterOnMarkerLimit() && objectArray.length > this.getMarkerLimit()) {
                if (!this.isMarkerLimitExceeded()) {
                    this.setMarkerLimitExceeded(true);
                    this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            TaskListContentProvider.this.viewer.refresh();
                        }
                    });
                }
                return new IMarker[0];
            }
            if (this.isMarkerLimitExceeded()) {
                this.setMarkerLimitExceeded(false);
                this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        TaskListContentProvider.this.viewer.refresh();
                    }
                });
            }
            return objectArray;
        }
        catch (CoreException coreException) {
            return new IMarker[0];
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IMarkerDelta[] iMarkerDeltaArray = iResourceChangeEvent.findMarkerDeltas(null, true);
        if (iMarkerDeltaArray == null) {
            return;
        }
        int n = this.totalMarkerCount;
        final ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
        final ArrayList<IMarker> arrayList2 = new ArrayList<IMarker>();
        final ArrayList<IMarker> arrayList3 = new ArrayList<IMarker>();
        int n2 = 0;
        while (n2 < iMarkerDeltaArray.length) {
            IMarkerDelta iMarkerDelta = iMarkerDeltaArray[n2];
            if (iMarkerDelta != null) {
                int n3 = iMarkerDelta.getKind();
                int n4 = 0;
                while (n4 < TasksFilter.ROOT_TYPES.length) {
                    if (iMarkerDelta.isSubtypeOf(TasksFilter.ROOT_TYPES[n4])) {
                        IResource iResource;
                        if (this.totalMarkerCount != -1) {
                            switch (n3) {
                                case 1: {
                                    ++this.totalMarkerCount;
                                    break;
                                }
                                case 2: {
                                    --this.totalMarkerCount;
                                }
                            }
                        }
                        if ((iResource = iMarkerDelta.getResource()) != null) {
                            boolean bl;
                            boolean bl2 = bl = this.taskList.checkResource(iResource) && this.taskList.getFilter().select(iMarkerDelta);
                            if (!bl) break;
                            IMarker iMarker = iMarkerDelta.getMarker();
                            switch (n3) {
                                case 1: {
                                    arrayList.add(iMarker);
                                    this.updateMarkerCounts(iMarkerDelta, 1);
                                    break;
                                }
                                case 2: {
                                    arrayList2.add(iMarker);
                                    this.updateMarkerCounts(iMarkerDelta, -1);
                                    break;
                                }
                                case 4: {
                                    arrayList3.add(iMarker);
                                }
                            }
                            break;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (n == this.totalMarkerCount && arrayList.size() + arrayList2.size() + arrayList3.size() == 0) {
            return;
        }
        this.viewer.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (TaskListContentProvider.this.getFilterOnMarkerLimit() && TaskListContentProvider.this.sum(TaskListContentProvider.this.visibleMarkerCounts) > TaskListContentProvider.this.getMarkerLimit()) {
                    if (!TaskListContentProvider.this.isMarkerLimitExceeded()) {
                        TaskListContentProvider.this.setMarkerLimitExceeded(true);
                        TaskListContentProvider.this.viewer.refresh();
                    }
                } else if (TaskListContentProvider.this.taskList.isMarkerLimitExceeded()) {
                    TaskListContentProvider.this.setMarkerLimitExceeded(false);
                    TaskListContentProvider.this.viewer.refresh();
                } else {
                    TaskListContentProvider.this.updateViewer(arrayList, arrayList2, arrayList3);
                }
                TaskListContentProvider.this.taskList.markersChanged();
            }
        });
    }
}

