/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ui.views.tasklist.MarkerUtil;

class TaskSorter
extends ViewerComparator {
    private int[] priorities;
    private int[] directions;
    static final int ASCENDING = 1;
    static final int DEFAULT_DIRECTION = 0;
    static final int DESCENDING = -1;
    static final int TYPE = 0;
    static final int COMPLETION = 1;
    static final int PRIORITY = 2;
    static final int DESCRIPTION = 3;
    static final int RESOURCE = 4;
    static final int FOLDER = 5;
    static final int LOCATION = 6;
    static final int CREATION_TIME = 7;
    static final int[] DEFAULT_PRIORITIES;
    static final int[] DEFAULT_DIRECTIONS;

    static {
        int[] nArray = new int[8];
        nArray[0] = 5;
        nArray[1] = 4;
        nArray[2] = 6;
        nArray[3] = 3;
        nArray[5] = 2;
        nArray[6] = 1;
        nArray[7] = 7;
        DEFAULT_PRIORITIES = nArray;
        DEFAULT_DIRECTIONS = new int[]{-1, -1, -1, 1, 1, 1, 1, 1};
    }

    public TaskSorter() {
        this.resetState();
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        IMarker iMarker = (IMarker)object;
        IMarker iMarker2 = (IMarker)object2;
        return this.compareColumnValue(iMarker, iMarker2, 0);
    }

    public void setTopPriority(int n) {
        if (n < 0 || n >= this.priorities.length) {
            return;
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.priorities.length) {
            if (this.priorities[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            this.resetState();
            return;
        }
        n3 = n2;
        while (n3 > 0) {
            this.priorities[n3] = this.priorities[n3 - 1];
            --n3;
        }
        this.priorities[0] = n;
        this.directions[n] = DEFAULT_DIRECTIONS[n];
    }

    public int getTopPriority() {
        return this.priorities[0];
    }

    public int[] getPriorities() {
        return this.priorities;
    }

    public void setTopPriorityDirection(int n) {
        if (n == 0) {
            this.directions[this.priorities[0]] = DEFAULT_DIRECTIONS[this.priorities[0]];
        } else if (n == 1 || n == -1) {
            this.directions[this.priorities[0]] = n;
        }
    }

    public int getTopPriorityDirection() {
        return this.directions[this.priorities[0]];
    }

    public void reverseTopPriority() {
        int n = this.priorities[0];
        this.directions[n] = this.directions[n] * -1;
    }

    public void resetState() {
        this.priorities = new int[DEFAULT_PRIORITIES.length];
        System.arraycopy(DEFAULT_PRIORITIES, 0, this.priorities, 0, this.priorities.length);
        this.directions = new int[DEFAULT_DIRECTIONS.length];
        System.arraycopy(DEFAULT_DIRECTIONS, 0, this.directions, 0, this.directions.length);
    }

    private int compareColumnValue(IMarker iMarker, IMarker iMarker2, int n) {
        if (n >= this.priorities.length) {
            return 0;
        }
        int n2 = this.priorities[n];
        int n3 = this.directions[n2];
        switch (n2) {
            case 0: {
                int n4 = this.getCategoryOrder(iMarker) - this.getCategoryOrder(iMarker2);
                if (n4 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n4 * n3;
            }
            case 1: {
                int n5 = this.getCompletedOrder(iMarker) - this.getCompletedOrder(iMarker2);
                if (n5 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n5 * n3;
            }
            case 2: {
                int n6 = this.getPriorityOrder(iMarker) - this.getPriorityOrder(iMarker2);
                if (n6 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n6 * n3;
            }
            case 3: {
                int n7 = this.getComparator().compare(MarkerUtil.getMessage(iMarker), MarkerUtil.getMessage(iMarker2));
                if (n7 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n7 * n3;
            }
            case 4: {
                IResource iResource = iMarker.getResource();
                IResource iResource2 = iMarker2.getResource();
                String string = iResource.getName();
                String string2 = iResource2.getName();
                int n8 = this.getComparator().compare(string, string2);
                if (n8 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n8 * n3;
            }
            case 5: {
                int n9;
                String string = MarkerUtil.getContainerName(iMarker);
                String string3 = MarkerUtil.getContainerName(iMarker2);
                int n10 = n9 = string.equals(string3) ? 0 : this.getComparator().compare(string, string3);
                if (n9 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n9 * n3;
            }
            case 6: {
                int n11 = this.compareLineAndLocation(iMarker, iMarker2);
                if (n11 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n11 * n3;
            }
            case 7: {
                int n12 = this.compareCreationTime(iMarker, iMarker2);
                if (n12 == 0) {
                    return this.compareColumnValue(iMarker, iMarker2, n + 1);
                }
                return n12 * n3;
            }
        }
        return 0;
    }

    private int compareCreationTime(IMarker iMarker, IMarker iMarker2) {
        long l;
        try {
            l = iMarker.getCreationTime() - iMarker2.getCreationTime();
        }
        catch (CoreException coreException) {
            l = 0L;
        }
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    private int compareLineAndLocation(IMarker iMarker, IMarker iMarker2) {
        int n = MarkerUtil.getLineNumber(iMarker);
        int n2 = MarkerUtil.getLineNumber(iMarker2);
        if (n != -1 && n2 != -1) {
            if (n != n2) {
                return n - n2;
            }
            int n3 = MarkerUtil.getCharStart(iMarker);
            int n4 = MarkerUtil.getCharStart(iMarker2);
            if (n3 != -1 && n4 != -1 && n3 != n4) {
                return n3 - n4;
            }
            String string = MarkerUtil.getLocation(iMarker);
            String string2 = MarkerUtil.getLocation(iMarker2);
            return this.getComparator().compare(string, string2);
        }
        if (n == -1 && n2 == -1) {
            String string = MarkerUtil.getLocation(iMarker);
            String string3 = MarkerUtil.getLocation(iMarker2);
            return this.getComparator().compare(string, string3);
        }
        String string = MarkerUtil.getLineAndLocation(iMarker);
        String string4 = MarkerUtil.getLineAndLocation(iMarker2);
        return this.getComparator().compare(string, string4);
    }

    private int getCategoryOrder(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.problemmarker")) {
            switch (MarkerUtil.getSeverity(iMarker)) {
                case 2: {
                    return 4;
                }
                case 1: {
                    return 3;
                }
                case 0: {
                    return 2;
                }
            }
        } else if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            return 1;
        }
        return 1000;
    }

    private int getCompletedOrder(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.isComplete(iMarker) ? 2 : 1;
        }
        return 0;
    }

    private int getPriorityOrder(IMarker iMarker) {
        if (MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            return MarkerUtil.getPriority(iMarker);
        }
        return -1;
    }

    public void saveState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return;
        }
        int n = 0;
        while (n < this.directions.length) {
            iDialogSettings.put("direction" + n, this.directions[n]);
            iDialogSettings.put("priority" + n, this.priorities[n]);
            ++n;
        }
    }

    public void restoreState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return;
        }
        try {
            int n = 0;
            while (n < this.priorities.length) {
                this.directions[n] = iDialogSettings.getInt("direction" + n);
                this.priorities[n] = iDialogSettings.getInt("priority" + n);
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.resetState();
        }
    }
}

