/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.tasklist.MarkerUtil;

class TasksFilter
extends ViewerFilter
implements Cloneable {
    public static final String[] ROOT_TYPES = new String[]{"org.eclipse.core.resources.problemmarker", "org.eclipse.core.resources.taskmarker"};
    static final int ON_ANY_RESOURCE = 0;
    static final int ON_SELECTED_RESOURCE_ONLY = 1;
    static final int ON_SELECTED_RESOURCE_AND_CHILDREN = 2;
    static final int ON_ANY_RESOURCE_OF_SAME_PROJECT = 3;
    static final int ON_WORKING_SET = 4;
    static final int FILTER_CONTAINS = 0;
    static final int FILTER_DOES_NOT_CONTAIN = 1;
    static final int DEFAULT_MARKER_LIMIT = 2000;
    String[] types;
    int onResource;
    IWorkingSet workingSet;
    boolean filterOnDescription;
    int descriptionFilterKind;
    String descriptionFilter;
    boolean filterOnSeverity;
    int severityFilter;
    boolean filterOnPriority;
    int priorityFilter;
    boolean filterOnCompletion;
    int completionFilter;
    private boolean filterOnMarkerLimit = true;
    private int markerLimit = 2000;
    private static final String TAG_ID = "id";
    private static final String TAG_TYPE = "type";
    private static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_FILTER_ON_DESCRIPTION = "filterOnDescription";
    private static final String TAG_DESCRIPTION_FILTER_KIND = "descriptionFilterKind";
    private static final String TAG_DESCRIPTION_FILTER = "descriptionFilter";
    private static final String TAG_FILTER_ON_SEVERITY = "filterOnSeverity";
    private static final String TAG_SEVERITY_FILTER = "severityFilter";
    private static final String TAG_FILTER_ON_PRIORITY = "filterOnPriority";
    private static final String TAG_PRIORITY_FILTER = "priorityFilter";
    private static final String TAG_FILTER_ON_COMPLETION = "filterOnCompletion";
    private static final String TAG_COMPLETION_FILTER = "completionFilter";
    private static final String TAG_FILTER_ON_MARKER_LIMIT = "filterOnMarkerLimit";
    private static final String TAG_MARKER_LIMIT = "markerLimit";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TasksFilter() {
        this.reset();
    }

    boolean getFilterOnMarkerLimit() {
        return this.filterOnMarkerLimit;
    }

    void setFilterOnMarkerLimit(boolean bl) {
        this.filterOnMarkerLimit = bl;
    }

    int getMarkerLimit() {
        return this.markerLimit;
    }

    void setMarkerLimit(int n) {
        if (n < 1) {
            n = 2000;
        }
        this.markerLimit = n;
    }

    boolean checkDescription(String string) {
        if (string == null) {
            string = "";
        }
        boolean bl = this.containsSubstring(string, this.descriptionFilter);
        return this.descriptionFilterKind == 0 ? bl : !bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    boolean containsSubstring(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = n - n2;
        int n4 = 0;
        while (n4 <= n3) {
            if (string.regionMatches(true, n4, string2, 0, n2)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private boolean isEnclosed(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        IAdaptable[] iAdaptableArray = this.workingSet.getElements();
        if (iPath.isEmpty() || iPath.isRoot()) {
            return false;
        }
        int n = 0;
        while (n < iAdaptableArray.length) {
            IContainmentAdapter iContainmentAdapter;
            IAdaptable iAdaptable = iAdaptableArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ui.IContainmentAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iContainmentAdapter = (IContainmentAdapter)iAdaptable.getAdapter((Class)clazz)) != null ? iContainmentAdapter.contains((Object)iAdaptable, (Object)iResource, 11) : this.isEnclosedResource(iResource, iPath, iAdaptable)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isEnclosedResource(IResource iResource, IPath iPath, IAdaptable iAdaptable) {
        IPath iPath2;
        IResource iResource2 = null;
        if (iAdaptable.equals(iResource)) {
            return true;
        }
        if (iAdaptable instanceof IResource) {
            iResource2 = (IResource)iAdaptable;
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iResource2 = (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return iResource2 != null && (iPath2 = iResource2.getFullPath()).isPrefixOf(iPath);
    }

    public void reset() {
        this.types = ROOT_TYPES;
        this.onResource = 0;
        this.filterOnDescription = false;
        this.descriptionFilter = "";
        this.filterOnSeverity = false;
        this.severityFilter = 0;
        this.filterOnPriority = false;
        this.priorityFilter = 0;
        this.filterOnCompletion = false;
        this.completionFilter = 0;
        this.filterOnMarkerLimit = true;
        this.markerLimit = 2000;
    }

    public void restoreState(IMemento iMemento) {
        IMemento[] iMementoArray = iMemento.getChildren(TAG_TYPE);
        this.types = new String[iMementoArray.length];
        int n = 0;
        while (n < iMementoArray.length) {
            this.types[n] = iMementoArray[n].getString(TAG_ID);
            ++n;
        }
        Integer n2 = iMemento.getInteger(TAG_ON_RESOURCE);
        this.onResource = n2 == null ? 0 : n2;
        this.restoreWorkingSet(iMemento.getString(TAG_WORKING_SET));
        n2 = iMemento.getInteger(TAG_FILTER_ON_DESCRIPTION);
        this.filterOnDescription = n2 != null && n2 == 1;
        n2 = iMemento.getInteger(TAG_DESCRIPTION_FILTER_KIND);
        this.descriptionFilterKind = n2 == null ? 0 : n2;
        this.descriptionFilter = iMemento.getString(TAG_DESCRIPTION_FILTER);
        if (this.descriptionFilter == null) {
            this.descriptionFilter = "";
        }
        this.filterOnSeverity = (n2 = iMemento.getInteger(TAG_FILTER_ON_SEVERITY)) != null && n2 == 1;
        n2 = iMemento.getInteger(TAG_SEVERITY_FILTER);
        this.severityFilter = n2 == null ? 0 : n2;
        n2 = iMemento.getInteger(TAG_FILTER_ON_PRIORITY);
        this.filterOnPriority = n2 != null && n2 == 1;
        n2 = iMemento.getInteger(TAG_PRIORITY_FILTER);
        this.priorityFilter = n2 == null ? 0 : n2;
        n2 = iMemento.getInteger(TAG_FILTER_ON_COMPLETION);
        this.filterOnCompletion = n2 != null && n2 == 1;
        n2 = iMemento.getInteger(TAG_COMPLETION_FILTER);
        this.completionFilter = n2 == null ? 0 : n2;
        n2 = iMemento.getInteger(TAG_FILTER_ON_MARKER_LIMIT);
        this.filterOnMarkerLimit = n2 == null || n2 == 1;
        n2 = iMemento.getInteger(TAG_MARKER_LIMIT);
        this.markerLimit = n2 == null ? 2000 : n2;
    }

    private void restoreWorkingSet(String string) {
        IWorkingSetManager iWorkingSetManager;
        IWorkingSet iWorkingSet;
        if (string != null && (iWorkingSet = (iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager()).getWorkingSet(string)) != null) {
            this.workingSet = iWorkingSet;
        }
    }

    public void saveState(IMemento iMemento) {
        int n = 0;
        while (n < this.types.length) {
            iMemento.createChild(TAG_TYPE).putString(TAG_ID, this.types[n]);
            ++n;
        }
        iMemento.putInteger(TAG_ON_RESOURCE, this.onResource);
        if (this.workingSet != null) {
            iMemento.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
        iMemento.putInteger(TAG_FILTER_ON_DESCRIPTION, this.filterOnDescription ? 1 : 0);
        iMemento.putInteger(TAG_DESCRIPTION_FILTER_KIND, this.descriptionFilterKind);
        iMemento.putString(TAG_DESCRIPTION_FILTER, this.descriptionFilter);
        iMemento.putInteger(TAG_FILTER_ON_SEVERITY, this.filterOnSeverity ? 1 : 0);
        iMemento.putInteger(TAG_SEVERITY_FILTER, this.severityFilter);
        iMemento.putInteger(TAG_FILTER_ON_PRIORITY, this.filterOnPriority ? 1 : 0);
        iMemento.putInteger(TAG_PRIORITY_FILTER, this.priorityFilter);
        iMemento.putInteger(TAG_FILTER_ON_COMPLETION, this.filterOnCompletion ? 1 : 0);
        iMemento.putInteger(TAG_COMPLETION_FILTER, this.completionFilter);
        iMemento.putInteger(TAG_FILTER_ON_MARKER_LIMIT, this.filterOnMarkerLimit ? 1 : 0);
        iMemento.putInteger(TAG_MARKER_LIMIT, this.markerLimit);
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        return this.select((IMarker)object2);
    }

    public boolean select(IMarker iMarker) {
        return this.selectByType(iMarker) && this.selectByAttributes(iMarker) && this.selectByWorkingSet(iMarker);
    }

    public boolean select(IMarkerDelta iMarkerDelta) {
        return this.selectByType(iMarkerDelta) && this.selectByAttributes(iMarkerDelta) && this.selectByWorkingSet(iMarkerDelta);
    }

    private boolean selectByType(IMarker iMarker) {
        int n = 0;
        while (n < this.types.length) {
            if (MarkerUtil.isMarkerType(iMarker, this.types[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean selectByType(IMarkerDelta iMarkerDelta) {
        int n = 0;
        while (n < this.types.length) {
            if (iMarkerDelta.isSubtypeOf(this.types[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean selectByWorkingSet(IMarker iMarker) {
        if (this.workingSet == null || this.onResource != 4) {
            return true;
        }
        IResource iResource = iMarker.getResource();
        if (iResource != null) {
            return this.isEnclosed(iResource);
        }
        return false;
    }

    private boolean selectByWorkingSet(IMarkerDelta iMarkerDelta) {
        if (this.workingSet == null || this.onResource != 4) {
            return true;
        }
        IResource iResource = iMarkerDelta.getResource();
        if (iResource != null) {
            return this.isEnclosed(iResource);
        }
        return false;
    }

    private boolean selectByAttributes(IMarker iMarker) {
        String string;
        int n;
        if (this.filterOnSeverity && MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.problemmarker") && (this.severityFilter & 1 << (n = MarkerUtil.getSeverity(iMarker))) == 0) {
            return false;
        }
        if ((this.filterOnPriority || this.filterOnCompletion) && MarkerUtil.isMarkerType(iMarker, "org.eclipse.core.resources.taskmarker")) {
            if (this.filterOnPriority && (this.priorityFilter & 1 << (n = MarkerUtil.getPriority(iMarker))) == 0) {
                return false;
            }
            if (this.filterOnCompletion && (this.completionFilter & ((n = (int)(MarkerUtil.isComplete(iMarker) ? 1 : 0)) != 0 ? 2 : 1)) == 0) {
                return false;
            }
        }
        return !this.filterOnDescription || this.checkDescription(string = MarkerUtil.getMessage(iMarker));
    }

    private boolean selectByAttributes(IMarkerDelta iMarkerDelta) {
        String string;
        int n;
        if (this.filterOnSeverity && iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker") && (this.severityFilter & 1 << (n = iMarkerDelta.getAttribute("severity", 1))) == 0) {
            return false;
        }
        if ((this.filterOnPriority || this.filterOnCompletion) && iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
            if (this.filterOnPriority && (this.priorityFilter & 1 << (n = iMarkerDelta.getAttribute("priority", 1))) == 0) {
                return false;
            }
            if (this.filterOnCompletion && (this.completionFilter & ((n = (int)(iMarkerDelta.getAttribute("done", false) ? 1 : 0)) != 0 ? 2 : 1)) == 0) {
                return false;
            }
        }
        return !this.filterOnDescription || this.checkDescription(string = iMarkerDelta.getAttribute("message", ""));
    }

    public boolean isShowingAll() {
        if (this.filterOnDescription || this.filterOnSeverity || this.filterOnPriority || this.filterOnCompletion) {
            return false;
        }
        if (this.onResource != 0) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.types));
        if (hashSet.size() != ROOT_TYPES.length) {
            return false;
        }
        int n = 0;
        while (n < ROOT_TYPES.length) {
            if (!hashSet.contains(ROOT_TYPES[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

