/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileStoreStructureProvider
implements IImportStructureProvider {
    public static final FileStoreStructureProvider INSTANCE = new FileStoreStructureProvider();

    public List getChildren(Object object) {
        try {
            return Arrays.asList(((IFileStore)object).childStores(0, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (CoreException coreException) {
            this.logException(coreException);
            return new ArrayList();
        }
    }

    private void logException(CoreException coreException) {
        IDEWorkbenchPlugin.log(coreException.getLocalizedMessage(), coreException);
    }

    public InputStream getContents(Object object) {
        try {
            return ((IFileStore)object).openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            this.logException(coreException);
            return null;
        }
    }

    public String getFullPath(Object object) {
        return ((IFileStore)object).toURI().getSchemeSpecificPart();
    }

    public String getLabel(Object object) {
        return ((IFileStore)object).getName();
    }

    public boolean isFolder(Object object) {
        return ((IFileStore)object).fetchInfo().isDirectory();
    }
}

