/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class FileSystemStructureProvider
implements IImportStructureProvider {
    public static final FileSystemStructureProvider INSTANCE = new FileSystemStructureProvider();

    private FileSystemStructureProvider() {
    }

    public List getChildren(Object object) {
        File file = (File)object;
        String[] stringArray = file.list();
        int n = stringArray == null ? 0 : stringArray.length;
        ArrayList<File> arrayList = new ArrayList<File>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(new File(file, stringArray[n2]));
            ++n2;
        }
        return arrayList;
    }

    public InputStream getContents(Object object) {
        try {
            return new FileInputStream((File)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IDEWorkbenchPlugin.log(fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
            return null;
        }
    }

    public String getFullPath(Object object) {
        return ((File)object).getPath();
    }

    public String getLabel(Object object) {
        File file = (File)object;
        String string = file.getName();
        if (string.length() == 0) {
            return file.getPath();
        }
        return string;
    }

    public boolean isFolder(Object object) {
        return ((File)object).isDirectory();
    }
}

