/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ImportOperation
extends WorkspaceModifyOperation {
    private static final int POLICY_DEFAULT = 0;
    private static final int POLICY_SKIP_CHILDREN = 1;
    private static final int POLICY_FORCE_OVERWRITE = 2;
    private Object source;
    private IPath destinationPath;
    private IContainer destinationContainer;
    private List selectedFiles;
    private List rejectedFiles;
    private IImportStructureProvider provider;
    private IProgressMonitor monitor;
    protected IOverwriteQuery overwriteCallback;
    private Shell context;
    private List errorTable = new ArrayList();
    private boolean createGroups = false;
    private boolean createLinks = false;
    private String relativeVariable = null;
    private boolean createContainerStructure = true;
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ImportOperation(IPath iPath, Object object, IImportStructureProvider iImportStructureProvider, IOverwriteQuery iOverwriteQuery) {
        this.destinationPath = iPath;
        this.source = object;
        this.provider = iImportStructureProvider;
        this.overwriteCallback = iOverwriteQuery;
    }

    public ImportOperation(IPath iPath, Object object, IImportStructureProvider iImportStructureProvider, IOverwriteQuery iOverwriteQuery, List list) {
        this(iPath, object, iImportStructureProvider, iOverwriteQuery);
        this.setFilesToImport(list);
    }

    public ImportOperation(IPath iPath, IImportStructureProvider iImportStructureProvider, IOverwriteQuery iOverwriteQuery, List list) {
        this(iPath, null, iImportStructureProvider, iOverwriteQuery);
        this.setFilesToImport(list);
    }

    void collectExistingReadonlyFiles(IPath iPath, List list, ArrayList arrayList, ArrayList arrayList2, int n) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Iterator iterator = list.iterator();
        Path path = null;
        if (this.source != null) {
            path = new Path(this.provider.getFullPath(this.source));
        }
        while (iterator.hasNext()) {
            IPath iPath2;
            IPath iPath3;
            Object e = iterator.next();
            Path path2 = new Path(this.provider.getFullPath(e));
            if (path == null) {
                iPath3 = iPath.append(this.provider.getLabel(e));
            } else {
                int n2 = path2.matchingFirstSegments((IPath)path);
                iPath2 = path2.removeFirstSegments(n2);
                iPath3 = this.destinationPath.append(iPath2);
            }
            IResource iResource = iWorkspaceRoot.findMember(iPath3);
            if (iResource == null) continue;
            IFolder iFolder = this.getFolder(iResource);
            if (iFolder != null) {
                if (!(n == 2 || this.overwriteState != 1 && this.queryOverwrite(iPath3))) {
                    arrayList.add(iFolder);
                    continue;
                }
                if (!this.provider.isFolder(e)) continue;
                this.collectExistingReadonlyFiles(iPath3, this.provider.getChildren(e), arrayList, arrayList2, 2);
                continue;
            }
            iPath2 = this.getFile(iResource);
            if (iPath2 == null) continue;
            if (!this.queryOverwriteFile((IFile)iPath2, n)) {
                arrayList.add(iPath2.getFullPath());
                continue;
            }
            if (!iPath2.isReadOnly()) continue;
            arrayList2.add(iPath2);
        }
    }

    IContainer createContainersFor(IPath iPath) throws CoreException {
        IContainer iContainer = this.destinationContainer;
        int n = iPath.segmentCount();
        if (n == 0) {
            return iContainer;
        }
        if (iContainer.getType() == 8) {
            return this.createFromRoot(iPath);
        }
        int n2 = 0;
        while (n2 < n) {
            if (!(iContainer = iContainer.getFolder((IPath)new Path(iPath.segment(n2)))).exists()) {
                if (this.createGroups) {
                    ((IFolder)iContainer).createGroup(0, null);
                } else if (this.createLinks) {
                    ((IFolder)iContainer).createLink(this.createRelativePath(iContainer.getProject(), iPath), 0, null);
                } else {
                    ((IFolder)iContainer).create(false, true, null);
                }
            }
            ++n2;
        }
        return iContainer;
    }

    private IContainer createFromRoot(IPath iPath) throws CoreException {
        int n = iPath.segmentCount();
        IProject iProject = ((IWorkspaceRoot)this.destinationContainer).getProject(iPath.segment(0));
        int n2 = 1;
        while (n2 < n) {
            if (!(iProject = iProject.getFolder((IPath)new Path(iPath.segment(n2)))).exists()) {
                ((IFolder)iProject).create(false, true, null);
            }
            ++n2;
        }
        return iProject;
    }

    void deleteResource(IResource iResource) {
        try {
            iResource.delete(2, null);
        }
        catch (CoreException coreException) {
            this.errorTable.add(coreException.getStatus());
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) {
        block6: {
            this.monitor = iProgressMonitor;
            try {
                try {
                    if (this.selectedFiles == null) {
                        this.monitor.beginTask(DataTransferMessages.DataTransfer_importTask, 1000);
                        ContainerGenerator containerGenerator = new ContainerGenerator(this.destinationPath);
                        this.monitor.worked(30);
                        this.validateFiles(Arrays.asList(this.source));
                        this.monitor.worked(50);
                        this.destinationContainer = containerGenerator.generateContainer((IProgressMonitor)new SubProgressMonitor(this.monitor, 50));
                        this.importRecursivelyFrom(this.source, 0);
                        this.monitor.worked(90);
                        break block6;
                    }
                    int n = this.selectedFiles.size();
                    this.monitor.beginTask(DataTransferMessages.DataTransfer_importTask, n + 100);
                    ContainerGenerator containerGenerator = new ContainerGenerator(this.destinationPath);
                    this.monitor.worked(30);
                    this.validateFiles(this.selectedFiles);
                    this.monitor.worked(50);
                    this.destinationContainer = containerGenerator.generateContainer((IProgressMonitor)new SubProgressMonitor(this.monitor, 50));
                    this.importFileSystemObjects(this.selectedFiles);
                    this.monitor.done();
                }
                catch (CoreException coreException) {
                    this.errorTable.add(coreException.getStatus());
                    this.monitor.done();
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    IContainer getDestinationContainerFor(Object object) throws CoreException {
        Path path = new Path(this.provider.getFullPath(object));
        if (this.createContainerStructure) {
            return this.createContainersFor(path.removeLastSegments(1));
        }
        if (this.source == object) {
            return null;
        }
        Path path2 = new Path(this.provider.getFullPath(this.source));
        IPath iPath = path.removeLastSegments(1);
        IPath iPath2 = iPath.removeFirstSegments(path2.segmentCount()).setDevice(null);
        return this.createContainersFor(iPath2);
    }

    IFile getFile(IResource iResource) {
        Object object;
        if (iResource instanceof IFile) {
            return (IFile)iResource;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((object = iResource.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return (IFile)object;
    }

    IFolder getFolder(IResource iResource) {
        Object object;
        if (iResource instanceof IFolder) {
            return (IFolder)iResource;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((object = iResource.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return (IFolder)object;
    }

    ArrayList getRejectedFiles(IStatus iStatus, IFile[] iFileArray) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        IStatus[] iStatusArray = iStatus.getChildren();
        int n = 0;
        while (n < iStatusArray.length) {
            if (!iStatusArray[n].isOK()) {
                this.errorTable.add(iStatusArray[n]);
                arrayList.add(iFileArray[n].getFullPath());
            }
            ++n;
        }
        return arrayList;
    }

    public IStatus getStatus() {
        IStatus[] iStatusArray = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(iStatusArray);
        return new MultiStatus("org.eclipse.ui", 0, iStatusArray, DataTransferMessages.ImportOperation_importProblems, null);
    }

    void importFile(Object object, int n) {
        block22: {
            IContainer iContainer;
            try {
                iContainer = this.getDestinationContainerFor(object);
            }
            catch (CoreException coreException) {
                IStatus iStatus = coreException.getStatus();
                String string = NLS.bind((String)DataTransferMessages.ImportOperation_coreImportError, (Object)object, (Object)iStatus.getMessage());
                Status status = new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, null);
                this.errorTable.add(status);
                return;
            }
            String string = this.provider.getFullPath(object);
            this.monitor.subTask(string);
            IFile iFile = iContainer.getFile((IPath)new Path(this.provider.getLabel(object)));
            this.monitor.worked(1);
            if (this.rejectedFiles.contains(iFile.getFullPath())) {
                return;
            }
            IPath iPath = iFile.getLocation();
            if (iPath != null && iPath.toFile().equals(new File(string))) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_targetSameAsSourceError, (Object)string), null));
                return;
            }
            InputStream inputStream = this.provider.getContents(object);
            if (inputStream == null) {
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_openStreamError, (Object)string), null));
                return;
            }
            try {
                try {
                    if (iFile.exists()) {
                        iFile.setContents(inputStream, 2, null);
                    } else if (this.createGroups || this.createLinks) {
                        iFile.createLink(this.createRelativePath(iContainer.getProject(), (IPath)new Path(this.provider.getFullPath(object))), 0, null);
                    } else {
                        iFile.create(inputStream, false, null);
                    }
                    this.setResourceAttributes(iFile, object);
                    if (!(this.provider instanceof TarLeveledStructureProvider)) break block22;
                    try {
                        iFile.setResourceAttributes(((TarLeveledStructureProvider)this.provider).getResourceAttributes(object));
                    }
                    catch (CoreException coreException) {
                        this.errorTable.add(coreException.getStatus());
                    }
                }
                catch (CoreException coreException) {
                    this.errorTable.add(coreException.getStatus());
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_closeStreamError, (Object)string), (Throwable)iOException));
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    this.errorTable.add(new Status(4, "org.eclipse.ui", 0, NLS.bind((String)DataTransferMessages.ImportOperation_closeStreamError, (Object)string), (Throwable)iOException));
                }
            }
        }
    }

    private void setResourceAttributes(IFile iFile, Object object) {
        if (object instanceof File) {
            try {
                iFile.setResourceAttributes(ResourceAttributes.fromFile((File)((File)object)));
            }
            catch (CoreException coreException) {
                IDEWorkbenchPlugin.log(coreException.getStatus().getMessage(), coreException);
            }
        }
    }

    void importFileSystemObjects(List list) throws CoreException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.source == null) {
                IPath iPath = new Path(this.provider.getFullPath(e)).removeLastSegments(1);
                if (this.provider.isFolder(e) && iPath.isEmpty()) {
                    this.errorTable.add(new Status(1, "org.eclipse.ui", 0, DataTransferMessages.ImportOperation_cannotCopy, null));
                    continue;
                }
                this.source = iPath.toFile();
            }
            this.importRecursivelyFrom(e, 0);
        }
    }

    int importFolder(Object object, int n) throws CoreException {
        IContainer iContainer;
        try {
            iContainer = this.getDestinationContainerFor(object);
        }
        catch (CoreException coreException) {
            this.errorTable.add(coreException.getStatus());
            return n;
        }
        if (iContainer == null) {
            return n;
        }
        this.monitor.subTask(this.provider.getFullPath(object));
        IWorkspace iWorkspace = this.destinationContainer.getWorkspace();
        IPath iPath = iContainer.getFullPath();
        IPath iPath2 = iPath.append(this.provider.getLabel(object));
        if (iPath2.equals((Object)iPath)) {
            return n;
        }
        if (iWorkspace.getRoot().exists(iPath2)) {
            if (this.rejectedFiles.contains(iPath2)) {
                return 1;
            }
            IFolder iFolder = iWorkspace.getRoot().getFolder(iPath2);
            if (this.createGroups || this.createLinks || iFolder.isGroup() || iFolder.isLinked()) {
                iFolder.delete(true, null);
            } else {
                return 2;
            }
        }
        try {
            if (this.createGroups) {
                iWorkspace.getRoot().getFolder(iPath2).createGroup(0, null);
            } else if (this.createLinks) {
                iWorkspace.getRoot().getFolder(iPath2).createLink(this.createRelativePath(iContainer.getProject(), (IPath)new Path(this.provider.getFullPath(object))), 0, null);
                n = 1;
            } else {
                iWorkspace.getRoot().getFolder(iPath2).create(false, true, null);
            }
        }
        catch (CoreException coreException) {
            this.errorTable.add(coreException.getStatus());
        }
        return n;
    }

    private IPath createRelativePath(IProject iProject, IPath iPath) {
        if (this.relativeVariable == null) {
            return iPath;
        }
        IPathVariableManager iPathVariableManager = iProject.getPathVariableManager();
        try {
            return iPathVariableManager.convertToRelative(iPath, true, this.relativeVariable);
        }
        catch (CoreException coreException) {
            return iPath;
        }
    }

    void importRecursivelyFrom(Object object, int n) throws CoreException {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.provider.isFolder(object)) {
            this.importFile(object, n);
            return;
        }
        int n2 = this.importFolder(object, n);
        if (n2 != 1) {
            Iterator iterator = this.provider.getChildren(object).iterator();
            while (iterator.hasNext()) {
                this.importRecursivelyFrom(iterator.next(), n2);
            }
        }
    }

    boolean queryOverwrite(IPath iPath) throws OperationCanceledException {
        String string = this.overwriteCallback.queryOverwrite(iPath.makeRelative().toString());
        if (string.equals("CANCEL")) {
            throw new OperationCanceledException(DataTransferMessages.DataTransfer_emptyString);
        }
        if (string.equals("NO")) {
            return false;
        }
        if (string.equals("NOALL")) {
            this.overwriteState = 1;
            return false;
        }
        if (string.equals("ALL")) {
            this.overwriteState = 2;
        }
        return true;
    }

    boolean queryOverwriteFile(IFile iFile, int n) {
        if (n != 2) {
            if (this.overwriteState == 0 && !this.queryOverwrite(iFile.getFullPath())) {
                return false;
            }
            if (this.overwriteState == 1) {
                return false;
            }
        }
        return true;
    }

    public void setContext(Shell shell) {
        this.context = shell;
    }

    public void setCreateContainerStructure(boolean bl) {
        this.createContainerStructure = bl;
    }

    public void setFilesToImport(List list) {
        this.selectedFiles = list;
    }

    public void setOverwriteResources(boolean bl) {
        if (bl) {
            this.overwriteState = 2;
        }
    }

    ArrayList validateEdit(List list) {
        if (list.size() > 0) {
            IFile[] iFileArray = list.toArray(new IFile[list.size()]);
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IStatus iStatus = iWorkspace.validateEdit(iFileArray, (Object)this.context);
            if (iStatus.isMultiStatus()) {
                return this.getRejectedFiles(iStatus, iFileArray);
            }
            if (!iStatus.isOK()) {
                this.errorTable.add(iStatus);
                ArrayList<IPath> arrayList = new ArrayList<IPath>();
                int n = 0;
                while (n < iFileArray.length) {
                    arrayList.add(iFileArray[n].getFullPath());
                    ++n;
                }
                return arrayList;
            }
        }
        return new ArrayList();
    }

    void validateFiles(List list) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.collectExistingReadonlyFiles(this.destinationPath, list, arrayList, arrayList2, 0);
        this.rejectedFiles = this.validateEdit(arrayList2);
        this.rejectedFiles.addAll(arrayList);
    }

    public void setCreateGroups(boolean bl) {
        this.createGroups = bl;
    }

    public void setCreateLinks(boolean bl) {
        this.createLinks = bl;
    }

    public void setRelativeVariable(String string) {
        this.relativeVariable = string;
    }
}

