/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class SelectFilesOperation
implements IRunnableWithProgress {
    IProgressMonitor monitor;
    Object root;
    IImportStructureProvider provider;
    String[] desiredExtensions;
    FileSystemElement result;

    public SelectFilesOperation(Object object, IImportStructureProvider iImportStructureProvider) {
        this.root = object;
        this.provider = iImportStructureProvider;
    }

    protected FileSystemElement createElement(FileSystemElement fileSystemElement, Object object) throws InterruptedException {
        String string;
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        boolean bl = this.provider.isFolder(object);
        String string2 = string = fileSystemElement == null ? this.provider.getFullPath(object) : this.provider.getLabel(object);
        if (!bl && !this.hasDesiredExtension(string)) {
            return null;
        }
        FileSystemElement fileSystemElement2 = new FileSystemElement(string, fileSystemElement, bl);
        fileSystemElement2.setFileSystemObject(object);
        if (bl) {
            boolean bl2 = false;
            ArrayList arrayList = this.provider.getChildren(object);
            if (arrayList == null) {
                arrayList = new ArrayList(1);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                if (this.createElement(fileSystemElement2, iterator.next()) == null) continue;
                bl2 = true;
            }
            if (!bl2 && fileSystemElement != null) {
                fileSystemElement.removeFolder(fileSystemElement2);
                fileSystemElement2 = null;
            }
        }
        return fileSystemElement2;
    }

    protected String getExtensionFor(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return "";
    }

    public FileSystemElement getResult() {
        return this.result;
    }

    protected boolean hasDesiredExtension(String string) {
        if (this.desiredExtensions == null) {
            return true;
        }
        int n = this.desiredExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.getExtensionFor(string).equalsIgnoreCase(this.desiredExtensions[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
        try {
            this.monitor = iProgressMonitor;
            iProgressMonitor.beginTask(DataTransferMessages.DataTransfer_scanningMatching, -1);
            this.result = this.createElement(null, this.root);
            if (this.result == null) {
                this.result = new FileSystemElement(this.provider.getLabel(this.root), null, this.provider.isFolder(this.root));
                this.result.setFileSystemObject(this.root);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public void setDesiredExtensions(String[] stringArray) {
        this.desiredExtensions = stringArray;
    }
}

