/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class WizardExternalProjectImportPage
extends WizardPage {
    private FileFilter projectFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().equals(".project");
        }
    };
    private static String previouslyBrowsedDirectory = "";
    private Text projectNameField;
    private Text locationPathField;
    private Button browseButton;
    private IProjectDescription description;
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event event) {
            WizardExternalProjectImportPage.this.setPageComplete(WizardExternalProjectImportPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardExternalProjectImportPage() {
        super("wizardExternalProjectPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.WizardExternalProjectImportPage_title);
        this.setDescription(DataTransferMessages.WizardExternalProjectImportPage_description);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        this.createProjectNameGroup(composite2);
        this.createProjectLocationGroup(composite2);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    private final void createProjectLocationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(DataTransferMessages.WizardExternalProjectImportPage_projectContentsLabel);
        label.setFont(composite.getFont());
        this.createUserSpecifiedProjectLocationGroup(composite2);
    }

    private final void createProjectNameGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setFont(font);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(DataTransferMessages.WizardExternalProjectImportPage_nameLabel);
        label.setFont(font);
        this.projectNameField = new Text(composite2, 2056);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        this.projectNameField.setFont(font);
        this.projectNameField.setBackground(composite.getDisplay().getSystemColor(22));
    }

    private void createUserSpecifiedProjectLocationGroup(Composite composite) {
        Font font = composite.getFont();
        this.locationPathField = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.locationPathField.setLayoutData((Object)gridData);
        this.locationPathField.setFont(font);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.browseButton.setFont(font);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardExternalProjectImportPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        Object object;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.locationPathField.getShell());
        directoryDialog.setMessage(DataTransferMessages.WizardExternalProjectImportPage_directoryLabel);
        String string = this.getProjectLocationFieldValue();
        if (string.length() == 0) {
            string = previouslyBrowsedDirectory;
        }
        if (string.length() == 0) {
            directoryDialog.setFilterPath(this.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            object = new File(string);
            if (((File)object).exists()) {
                directoryDialog.setFilterPath(new Path(string).toOSString());
            }
        }
        object = directoryDialog.open();
        if (object != null) {
            previouslyBrowsedDirectory = object;
            this.locationPathField.setText(previouslyBrowsedDirectory);
            this.setProjectName(this.projectFile(previouslyBrowsedDirectory));
        }
    }

    private boolean validatePage() {
        String string = this.getProjectLocationFieldValue();
        if (string.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(DataTransferMessages.WizardExternalProjectImportPage_projectLocationEmpty);
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(string)) {
            this.setErrorMessage(DataTransferMessages.WizardExternalProjectImportPage_locationError);
            return false;
        }
        File file = this.projectFile(string);
        if (file == null) {
            this.setErrorMessage(NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_notAProject, (Object)string));
            return false;
        }
        this.setProjectName(file);
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(DataTransferMessages.WizardExternalProjectImportPage_projectExistsMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private IWorkspace getWorkspace() {
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        return iWorkspace;
    }

    private boolean isPrefixOfRoot(IPath iPath) {
        return Platform.getLocation().isPrefixOf(iPath);
    }

    private void setProjectName(File file) {
        if (file == null) {
            return;
        }
        Path path = new Path(file.getPath());
        IProjectDescription iProjectDescription = null;
        try {
            iProjectDescription = this.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (CoreException coreException) {}
        if (iProjectDescription == null) {
            this.description = null;
            this.projectNameField.setText("");
        } else {
            this.description = iProjectDescription;
            this.projectNameField.setText(this.description.getName());
        }
    }

    private File projectFile(String string) {
        File file = new File(string);
        if (file.isFile()) {
            return null;
        }
        File[] fileArray = file.listFiles(this.projectFilter);
        if (fileArray != null && fileArray.length == 1) {
            return fileArray[0];
        }
        return null;
    }

    IProject createExistingProject() {
        Object object;
        String string = this.projectNameField.getText();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProject iProject = iWorkspace.getRoot().getProject(string);
        if (this.description == null) {
            this.description = iWorkspace.newProjectDescription(string);
            object = this.getLocationPath();
            if (this.isPrefixOfRoot((IPath)object)) {
                this.description.setLocation(null);
            } else {
                this.description.setLocation(object);
            }
        } else {
            this.description.setName(string);
        }
        object = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask("", 2000);
                iProject.create(WizardExternalProjectImportPage.this.description, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                iProject.open(128, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000));
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)object);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CoreException) {
                if (((CoreException)throwable).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_caseVariantExistsError, (Object)string));
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, null, (IStatus)((CoreException)throwable).getStatus());
                }
            }
            return null;
        }
        return iProject;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.locationPathField.setFocus();
        }
    }
}

