/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ZipFileStructureProvider
implements IImportStructureProvider {
    private ZipFile zipFile;
    private ZipEntry root = new ZipEntry("/");
    private Map children;
    private Map directoryEntryCache = new HashMap();

    public ZipFileStructureProvider(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    protected void addToChildren(ZipEntry zipEntry, ZipEntry zipEntry2) {
        ArrayList<ZipEntry> arrayList = (ArrayList<ZipEntry>)this.children.get(zipEntry);
        if (arrayList == null) {
            arrayList = new ArrayList<ZipEntry>();
            this.children.put(zipEntry, arrayList);
        }
        arrayList.add(zipEntry2);
    }

    protected void createContainer(IPath iPath) {
        if (this.directoryEntryCache.containsKey(iPath)) {
            return;
        }
        ZipEntry zipEntry = iPath.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(iPath.removeLastSegments(1));
        ZipEntry zipEntry2 = new ZipEntry(iPath.toString());
        this.directoryEntryCache.put(iPath, zipEntry2);
        this.addToChildren(zipEntry, zipEntry2);
    }

    protected void createFile(ZipEntry zipEntry) {
        Path path = new Path(zipEntry.getName());
        ZipEntry zipEntry2 = path.segmentCount() == 1 ? this.root : (ZipEntry)this.directoryEntryCache.get(path.removeLastSegments(1));
        this.addToChildren(zipEntry2, zipEntry);
    }

    public List getChildren(Object object) {
        if (this.children == null) {
            this.initialize();
        }
        return (List)this.children.get(object);
    }

    public InputStream getContents(Object object) {
        try {
            return this.zipFile.getInputStream((ZipEntry)object);
        }
        catch (IOException iOException) {
            IDEWorkbenchPlugin.log(iOException.getLocalizedMessage(), iOException);
            return null;
        }
    }

    public String getFullPath(Object object) {
        return ((ZipEntry)object).getName();
    }

    public String getLabel(Object object) {
        if (object.equals(this.root)) {
            return ((ZipEntry)object).getName();
        }
        return new Path(((ZipEntry)object).getName()).lastSegment();
    }

    public ZipEntry getRoot() {
        return this.root;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    protected void initialize() {
        this.children = new HashMap(1000);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            IPath iPath = new Path(zipEntry.getName()).addTrailingSeparator();
            int n = iPath.segmentCount();
            int n2 = 1;
            while (n2 < n) {
                this.createContainer(iPath.uptoSegment(n2));
                ++n2;
            }
            this.createFile(zipEntry);
        }
    }

    public boolean isFolder(Object object) {
        return ((ZipEntry)object).isDirectory();
    }
}

