/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.newresource;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class BasicNewProjectResourceWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    public static final String WIZARD_ID = "org.eclipse.ui.wizards.new.project";
    private WizardNewProjectCreationPage mainPage;
    private WizardNewProjectReferencePage referencePage;
    private IProject newProject;
    private IConfigurationElement configElement;
    private static String WINDOW_PROBLEMS_TITLE = ResourceMessages.NewProject_errorOpeningWindow;
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";

    public BasicNewProjectResourceWizard() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("BasicNewProjectResourceWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("BasicNewProjectResourceWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage"){

            public void createControl(Composite composite) {
                super.createControl(composite);
                this.createWorkingSetGroup((Composite)this.getControl(), BasicNewProjectResourceWizard.this.getSelection(), new String[]{"org.eclipse.ui.resourceWorkingSetPage"});
                Dialog.applyDialogFont((Control)this.getControl());
            }
        };
        this.mainPage.setTitle(ResourceMessages.NewProject_title);
        this.mainPage.setDescription(ResourceMessages.NewProject_description);
        this.addPage((IWizardPage)this.mainPage);
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("basicReferenceProjectPage");
            this.referencePage.setTitle(ResourceMessages.NewProject_referenceTitle);
            this.referencePage.setDescription(ResourceMessages.NewProject_referenceDescription);
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    private IProject createNewProject() {
        Object object;
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject iProject = this.mainPage.getProjectHandle();
        URI uRI = null;
        if (!this.mainPage.useDefaults()) {
            uRI = this.mainPage.getLocationURI();
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
        iProjectDescription.setLocationURI(uRI);
        if (this.referencePage != null && ((IProject[])(object = this.referencePage.getReferencedProjects())).length > 0) {
            iProjectDescription.setReferencedProjects(object);
        }
        object = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                CreateProjectOperation createProjectOperation = new CreateProjectOperation(iProjectDescription, ResourceMessages.NewProject_windowTitle);
                try {
                    createProjectOperation.execute(iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(BasicNewProjectResourceWizard.this.getShell()));
                }
                catch (ExecutionException executionException) {
                    throw new InvocationTargetException(executionException);
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)object);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ExecutionException && throwable.getCause() instanceof CoreException) {
                CoreException coreException = (CoreException)throwable.getCause();
                StatusAdapter statusAdapter = coreException.getStatus().getCode() == 275 ? new StatusAdapter(StatusUtil.newStatus(2, NLS.bind((String)ResourceMessages.NewProject_caseVariantExistsError, (Object)iProject.getName()), (Throwable)coreException)) : new StatusAdapter(StatusUtil.newStatus(coreException.getStatus().getSeverity(), ResourceMessages.NewProject_errorMessage, (Throwable)coreException));
                statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(statusAdapter, 4);
            } else {
                StatusAdapter statusAdapter = new StatusAdapter((IStatus)new Status(2, "org.eclipse.ui.ide", 0, NLS.bind((String)ResourceMessages.NewProject_internalError, (Object)throwable.getMessage()), throwable));
                statusAdapter.setProperty(StatusAdapter.TITLE_PROPERTY, (Object)ResourceMessages.NewProject_errorMessage);
                StatusManager.getManager().handle(statusAdapter, 5);
            }
            return null;
        }
        this.newProject = iProject;
        return this.newProject;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(ResourceMessages.NewProject_windowTitle);
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor imageDescriptor = IDEWorkbenchPlugin.getIDEImageDescriptor("wizban/newprj_wiz.png");
        this.setDefaultPageImageDescriptor(imageDescriptor);
    }

    private static void openInNewWindow(IPerspectiveDescriptor iPerspectiveDescriptor) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(iPerspectiveDescriptor.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException workbenchException) {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) break block2;
                ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)workbenchException.getMessage(), (IStatus)workbenchException.getStatus());
            }
        }
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        IWorkingSet[] iWorkingSetArray = this.mainPage.getSelectedWorkingSets();
        this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.newProject, iWorkingSetArray);
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor iPerspectiveDescriptor) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        iWorkbenchPage.setPerspective(iPerspectiveDescriptor);
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.configElement = iConfigurationElement;
    }

    protected void updatePerspective() {
        BasicNewProjectResourceWizard.updatePerspective(this.configElement);
    }

    public static void updatePerspective(IConfigurationElement iConfigurationElement) {
        int n;
        Object object;
        Object object2;
        IIdentifier iIdentifier;
        Set set;
        Object object3;
        if (iConfigurationElement == null) {
            return;
        }
        String string = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String string2 = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!string2.equals("prompt") && string.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String string3 = iConfigurationElement.getAttribute(FINAL_PERSPECTIVE);
        if (string3 == null) {
            return;
        }
        IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor iPerspectiveDescriptor = iPerspectiveRegistry.findPerspectiveWithId(string3);
        if (iPerspectiveDescriptor != null && iPerspectiveDescriptor instanceof IPluginContribution) {
            HashSet hashSet;
            object3 = (IPluginContribution)iPerspectiveDescriptor;
            if (object3.getPluginId() != null && !(set = (iIdentifier = (object2 = (object = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)object3))).getActivityIds()).isEmpty() && (hashSet = new HashSet(object2.getEnabledActivityIds())).addAll(set)) {
                object.setEnabledActivityIds(hashSet);
            }
        } else {
            IDEWorkbenchPlugin.log("Unable to find persective " + string3 + " in BasicNewProjectResourceWizard.updatePerspective");
            return;
        }
        object3 = new ArrayList();
        BasicNewProjectResourceWizard.addPerspectiveAndDescendants((List)object3, string3);
        object = iConfigurationElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (object != null) {
            object2 = new StringTokenizer((String)object, " \t\n\r\f,");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                BasicNewProjectResourceWizard.addPerspectiveAndDescendants((List)object3, ((StringTokenizer)object2).nextToken());
            }
        }
        if ((object2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            iIdentifier = object2.getActivePage();
            if (iIdentifier != null && (set = iIdentifier.getPerspective()) != null && ((ArrayList)object3).contains(set.getId())) {
                return;
            }
            if (!BasicNewProjectResourceWizard.confirmPerspectiveSwitch((IWorkbenchWindow)object2, iPerspectiveDescriptor)) {
                return;
            }
        }
        if ((n = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            BasicNewProjectResourceWizard.openInNewWindow(iPerspectiveDescriptor);
            return;
        }
        BasicNewProjectResourceWizard.replaceCurrentPerspective(iPerspectiveDescriptor);
    }

    private static void addPerspectiveAndDescendants(List list, String string) {
        IPerspectiveRegistry iPerspectiveRegistry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = iPerspectiveRegistry.getPerspectives();
        int n = 0;
        while (n < iPerspectiveDescriptorArray.length) {
            PerspectiveDescriptor perspectiveDescriptor = (PerspectiveDescriptor)iPerspectiveDescriptorArray[n];
            if (perspectiveDescriptor.getOriginalId().equals(string)) {
                list.add(perspectiveDescriptor.getId());
            }
            ++n;
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow iWorkbenchWindow, IPerspectiveDescriptor iPerspectiveDescriptor) {
        IPreferenceStore iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(string)) {
            return "always".equals(string);
        }
        String string2 = iPerspectiveDescriptor.getDescription();
        String string3 = string2 == null || string2.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)iPerspectiveDescriptor.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{iPerspectiveDescriptor.getLabel(), string2});
        MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)iWorkbenchWindow.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)string3, null, (boolean)false, (IPreferenceStore)iPreferenceStore, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int n = messageDialogWithToggle.getReturnCode();
        if (messageDialogWithToggle.getToggleState()) {
            String string4 = n == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", string4);
        }
        return n == 2;
    }
}

