/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.IContributionFactorySpi;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionContributionFactory
implements IContributionFactory {
    private IExtensionRegistry registry;
    private Map<String, Object> languages;

    public ReflectionContributionFactory(IExtensionRegistry iExtensionRegistry) {
        this.registry = iExtensionRegistry;
        this.processLanguages();
    }

    public Object call(Object object, String string, String string2, IEclipseContext iEclipseContext, Object object2) {
        Object object3;
        Class<?>[] classArray;
        URI uRI = URI.createURI((String)string);
        if (uRI.segmentCount() > 3) {
            String string3 = uRI.segment(2);
            IContributionFactorySpi iContributionFactorySpi = (IContributionFactorySpi)this.languages.get(string3);
            return iContributionFactorySpi.call(object, string2, iEclipseContext, object2);
        }
        Method method = null;
        Method[] methodArray = object.getClass().getMethods();
        if (methodArray.length == 1) {
            method = methodArray[0];
        } else {
            Method method2;
            classArray = new ArrayList();
            int n = 0;
            while (n < methodArray.length) {
                method2 = methodArray[n];
                if ((method2.getModifiers() & 1) != 0 && method2.getName().equals(string2)) {
                    classArray.add(method2);
                }
                ++n;
            }
            Collections.sort(classArray, new Comparator<Method>(){

                @Override
                public int compare(Method method, Method method2) {
                    int n = method.getParameterTypes().length;
                    int n2 = method2.getParameterTypes().length;
                    return n - n2;
                }
            });
            object3 = classArray.iterator();
            while (object3.hasNext() && method == null) {
                method2 = (Method)object3.next();
                boolean bl = true;
                Class<?>[] classArray2 = method2.getParameterTypes();
                int n2 = 0;
                while (n2 < classArray2.length && bl) {
                    Class<?> clazz = classArray2[n2];
                    if (!iEclipseContext.containsKey(clazz.getName())) {
                        bl = false;
                    }
                    ++n2;
                }
                if (!bl) continue;
                method = method2;
            }
        }
        if (method == null) {
            if (object2 != null) {
                return object2;
            }
            throw new RuntimeException("could not find satisfiable method " + string2 + " in class " + object.getClass());
        }
        classArray = method.getParameterTypes();
        try {
            object3 = new Object[classArray.length];
            int n = 0;
            while (n < ((Object[])object3).length) {
                object3[n] = iEclipseContext.get(classArray[n].getName());
                ++n;
            }
            return method.invoke(object, (Object[])object3);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object create(String string, IEclipseContext iEclipseContext) {
        URI uRI = URI.createURI((String)string);
        Bundle bundle = this.getBundle(uRI);
        if (bundle != null) {
            if (uRI.segmentCount() > 3) {
                String string2 = uRI.segment(2);
                IContributionFactorySpi iContributionFactorySpi = (IContributionFactorySpi)this.languages.get(string2);
                StringBuffer stringBuffer = new StringBuffer(uRI.segment(3));
                int n = 4;
                while (n < uRI.segmentCount()) {
                    stringBuffer.append('/');
                    stringBuffer.append(uRI.segment(n));
                    ++n;
                }
                return iContributionFactorySpi.create(bundle, stringBuffer.toString(), iEclipseContext);
            }
            try {
                Class clazz = bundle.loadClass(uRI.segment(2));
                return this.createObject(clazz, iEclipseContext);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        return null;
    }

    private void processLanguages() {
        this.languages = new HashMap<String, Object>();
        String string = "org.eclipse.e4.languages";
        IConfigurationElement[] iConfigurationElementArray = this.registry.getConfigurationElementsFor(string);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            try {
                this.languages.put(iConfigurationElement.getAttribute("name"), iConfigurationElement.createExecutableExtension("contributionFactory"));
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                invalidRegistryObjectException.printStackTrace();
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object createObject(Class<?> clazz, IEclipseContext iEclipseContext) {
        Class<?>[] classArray;
        Constructor constructor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 1) {
            constructor = constructorArray[0];
        } else {
            void constructor3;
            classArray = new ArrayList();
            boolean n = false;
            while (constructor3 < constructorArray.length) {
                Constructor<?> n2 = constructorArray[constructor3];
                if ((n2.getModifiers() & 1) != 0) {
                    classArray.add(n2);
                }
                ++constructor3;
            }
            Collections.sort(classArray, new Comparator<Constructor<?>>(){

                @Override
                public int compare(Constructor<?> constructor, Constructor<?> constructor2) {
                    int n = constructor.getParameterTypes().length;
                    int n2 = constructor2.getParameterTypes().length;
                    return n - n2;
                }
            });
            for (Constructor objectArray : classArray) {
                boolean bl = true;
                Class<?>[] classArray2 = objectArray.getParameterTypes();
                int n3 = 0;
                while (n3 < classArray2.length && bl) {
                    Class<?> clazz2 = classArray2[n3];
                    if (!iEclipseContext.containsKey(clazz2.getName())) {
                        bl = false;
                    }
                    ++n3;
                }
                if (!bl) continue;
                constructor = objectArray;
            }
        }
        if (constructor == null) {
            throw new RuntimeException("could not find satisfiable constructor in class " + clazz);
        }
        classArray = constructor.getParameterTypes();
        try {
            Object[] exception = new Object[classArray.length];
            int obj = 0;
            while (obj < exception.length) {
                exception[obj] = iEclipseContext.get(classArray[obj].getName());
                ++obj;
            }
            Object obj2 = constructor.newInstance(exception);
            ContextInjectionFactory.inject(obj2, (IEclipseContext)iEclipseContext, (String)" ", (String)" ");
            return obj2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private Bundle getBundle(URI uRI) {
        return Activator.getDefault().getBundleForName(uRI.segment(1));
    }
}

