/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ComputedValue;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.model.application.ApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContributedPart;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.workbench.MWorkbenchWindow;
import org.eclipse.e4.ui.model.workbench.WorkbenchPackage;
import org.eclipse.e4.workbench.ui.IExceptionHandler;
import org.eclipse.e4.workbench.ui.ILegacyHook;
import org.eclipse.e4.workbench.ui.IWorkbench;
import org.eclipse.e4.workbench.ui.IWorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.internal.ActiveChildOutputValue;
import org.eclipse.e4.workbench.ui.internal.ExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.UIContextScheduler;
import org.eclipse.e4.workbench.ui.internal.WorkbenchLogger;
import org.eclipse.e4.workbench.ui.renderers.PartFactory;
import org.eclipse.e4.workbench.ui.renderers.PartRenderer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbench
implements IWorkbench {
    public static final String ID = "org.eclipse.e4.workbench.fakedWBWindow";
    private MApplication<? extends MWindow> workbench;
    private static final boolean saveAndRestore = true;
    private File workbenchData;
    private IWorkbenchWindowHandler windowHandler;
    private Object appWindow;
    private final IExtensionRegistry registry;
    private ResourceSetImpl resourceSet;
    private PartRenderer renderer;
    private int rv;
    private ExceptionHandler exceptionHandler;
    private IEclipseContext globalContext;
    private ReflectionContributionFactory contributionFactory;

    public IEclipseContext getContext() {
        return this.globalContext;
    }

    public Workbench(Location location, IExtensionRegistry iExtensionRegistry, PackageAdmin packageAdmin, URI uRI, IEclipseContext iEclipseContext, IWorkbenchWindowHandler iWorkbenchWindowHandler) {
        this.windowHandler = iWorkbenchWindowHandler;
        this.exceptionHandler = new ExceptionHandler();
        this.registry = iExtensionRegistry;
        try {
            this.workbenchData = new File(location.getURL().toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        this.workbenchData = new File(this.workbenchData, ".metadata");
        this.workbenchData = new File(this.workbenchData, ".plugins");
        this.workbenchData = new File(this.workbenchData, "org.eclipse.e4.workbench");
        this.workbenchData = new File(this.workbenchData, "workbench.xmi");
        this.contributionFactory = new ReflectionContributionFactory(iExtensionRegistry);
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2008/Workbench", (Object)WorkbenchPackage.eINSTANCE);
        this.globalContext = this.createContext(iEclipseContext);
        if (this.workbenchData != null && this.workbenchData.exists()) {
            this.createWorkbenchModel(URI.createFileURI((String)this.workbenchData.getAbsolutePath()), uRI);
        } else {
            this.createWorkbenchModel(null, uRI);
        }
    }

    private IEclipseContext createContext(IEclipseContext iEclipseContext) {
        IConfigurationElement[] iConfigurationElementArray;
        final IEclipseContext iEclipseContext2 = EclipseContextFactory.create((IEclipseContext)iEclipseContext, (IEclipseContextStrategy)UIContextScheduler.instance);
        iEclipseContext2.set(Logger.class.getName(), (Object)new WorkbenchLogger());
        iEclipseContext2.set("DEBUG_STRING", (Object)"globalContext");
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = this.registry.getConfigurationElementsFor("org.eclipse.e4.services");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            try {
                IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElement.getChildren("service");
                int n3 = iConfigurationElementArray3.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement2 = iConfigurationElementArray3[n4];
                    Object object = iConfigurationElement.createExecutableExtension("class");
                    String string = iConfigurationElement2.getAttribute("api");
                    iEclipseContext2.set(string, object);
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            ++n2;
        }
        iEclipseContext2.set(IWorkbench.class.getName(), (Object)this);
        iEclipseContext2.set(IExceptionHandler.class.getName(), (Object)this.exceptionHandler);
        iEclipseContext2.set(IExtensionRegistry.class.getName(), (Object)this.registry);
        iEclipseContext2.set("selection", (Object)new ActiveChildOutputValue("selection"));
        iEclipseContext2.set("input", (Object)new ComputedValue(){

            public Object compute(IEclipseContext iEclipseContext, Object[] objectArray) {
                Object object;
                Class clazz = null;
                if (objectArray.length > 0 && objectArray[0] instanceof Class) {
                    clazz = (Class)objectArray[0];
                }
                Object object2 = null;
                Object object3 = iEclipseContext2.get("selection");
                if (clazz == null || clazz.isInstance(object3)) {
                    object2 = object3;
                } else if (object3 != null && clazz != null && (object = Platform.getAdapterManager().loadAdapter(object3, clazz.getName())) != null) {
                    object2 = object;
                }
                return object2;
            }
        });
        return iEclipseContext2;
    }

    private MApplication<? extends MWindow> createWorkbenchModel(URI uRI, URI uRI2) {
        boolean bl;
        XMIResourceImpl xMIResourceImpl;
        long l = uRI == null ? 0L : new File(uRI.toFileString()).lastModified();
        long l2 = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map map = resourceSetImpl.getURIConverter().getAttributes(uRI2, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object v = map.get("timeStamp");
        if (v instanceof Long) {
            l2 = (Long)v;
        } else if (uRI2.isPlatformPlugin()) {
            try {
                URL uRL = new URL(uRI2.toString());
                xMIResourceImpl = PlatformURLPluginConnection.parse((String)uRL.getFile().trim(), (URL)uRL);
                Bundle bundle = (Bundle)xMIResourceImpl[0];
                URLConnection uRLConnection = bundle.getResource((String)xMIResourceImpl[1]).openConnection();
                l2 = uRLConnection.getLastModified();
            }
            catch (Exception exception) {}
        }
        boolean bl2 = bl = l > l2;
        if (bl) {
            System.err.println("Restoring workbench: " + uRI);
            this.workbench = (MApplication)resourceSetImpl.getResource(uRI, true).getContents().get(0);
        } else {
            System.err.println("Initializing workbench: " + uRI2);
            xMIResourceImpl = new XMIResourceImpl();
            this.workbench = this.loadDefaultModel(uRI2);
            xMIResourceImpl.getContents().add(this.workbench);
            xMIResourceImpl.setURI(URI.createFileURI((String)this.workbenchData.getAbsolutePath()));
        }
        this.init(this.workbench);
        return this.workbench;
    }

    private MApplication<? extends MWindow> loadDefaultModel(URI uRI) {
        Resource resource = new ResourceSetImpl().getResource(uRI, true);
        MApplication mApplication = (MApplication)resource.getContents().get(0);
        this.processPartContributions(resource, (MWindow)mApplication.getWindows().get(0));
        return mApplication;
    }

    private void processPartContributions(Resource resource, MWindow mWindow) {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        String string = "org.eclipse.e4.workbench.parts";
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            MContributedPart mContributedPart = ApplicationFactory.eINSTANCE.createMContributedPart();
            mContributedPart.setName(iConfigurationElementArray[n].getAttribute("label"));
            mContributedPart.setIconURI("platform:/plugin/" + iConfigurationElementArray[n].getContributor().getName() + "/" + iConfigurationElementArray[n].getAttribute("icon"));
            mContributedPart.setURI("platform:/plugin/" + iConfigurationElementArray[n].getContributor().getName() + "/" + iConfigurationElementArray[n].getAttribute("class"));
            String string2 = iConfigurationElementArray[n].getAttribute("parentId");
            MPart mPart = (MPart)this.findObject((TreeIterator<EObject>)resource.getAllContents(), string2);
            if (mPart != null) {
                mPart.getChildren().add((Object)mContributedPart);
            }
            ++n;
        }
    }

    private EObject findObject(TreeIterator<EObject> treeIterator, String string) {
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof MApplicationElement) || !eObject.eResource().getURIFragment(eObject).equals(string)) continue;
            return eObject;
        }
        return null;
    }

    private void init(MApplication<? extends MWindow> mApplication) {
        this.globalContext.set(MApplication.class.getName(), this.workbench);
        this.globalContext.get(ILegacyHook.class.getName());
    }

    @Override
    public int run() {
        MWindow mWindow = (MWindow)this.workbench.getWindows().get(0);
        this.createGUI(mWindow);
        this.rv = 0;
        Platform.endSplash();
        this.windowHandler.setBounds(this.appWindow, mWindow.getX(), mWindow.getY(), mWindow.getWidth(), mWindow.getHeight());
        this.windowHandler.layout(this.appWindow);
        this.windowHandler.open(this.appWindow);
        this.windowHandler.runEvenLoop(this.appWindow);
        if (this.workbenchData != null && this.workbench != null) {
            try {
                System.err.println("Saving workbench: " + this.workbench.eResource().getURI());
                this.workbench.eResource().save(null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.rv;
    }

    public static void initializeRenderer(IExtensionRegistry iExtensionRegistry, PartRenderer partRenderer, IEclipseContext iEclipseContext, IContributionFactory iContributionFactory) {
        Object object;
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.e4.workbench.partfactory");
        int n = 0;
        int n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            object = iConfigurationElementArray[n2].getAttribute("class");
            if (((String)object).indexOf("Legacy") >= 0 || ((String)object).indexOf("PartSash") >= 0) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                iConfigurationElementArray[n++] = iConfigurationElementArray[n2];
                iConfigurationElementArray[n2] = iConfigurationElement;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < iConfigurationElementArray.length) {
            object = null;
            try {
                object = (PartFactory)iConfigurationElementArray[n2].createExecutableExtension("class");
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
            if (object != null) {
                ((PartFactory)object).init(partRenderer, iEclipseContext, iContributionFactory);
                partRenderer.addPartFactory((PartFactory)object);
            }
            ++n2;
        }
    }

    private void createGUI(MWindow mWindow) {
        if (this.renderer == null) {
            this.renderer = new PartRenderer(this.contributionFactory, this.globalContext);
            Workbench.initializeRenderer(this.registry, this.renderer, this.globalContext, this.contributionFactory);
        }
        this.renderer.createGui((MPart)mWindow);
        this.appWindow = mWindow.getWidget();
    }

    @Override
    public void close() {
        this.windowHandler.dispose(this.appWindow);
    }

    public void closeWindow(MWorkbenchWindow mWorkbenchWindow) {
        this.windowHandler.close(mWorkbenchWindow.getWidget());
    }

    public Object getWindow() {
        return this.appWindow;
    }
}

