/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.Bundle;

public final class WorkbenchLogger
extends Logger {
    private DebugTrace trace;
    private ILog log;

    public void debug(Throwable throwable) {
        this.debug(throwable, null);
    }

    public void debug(Throwable throwable, String string) {
        this.getTrace().trace(null, string, throwable);
    }

    private synchronized DebugTrace getTrace() {
        if (this.trace != null) {
            this.trace = Activator.getDefault().getDebugOptions().newDebugTrace(Activator.getDefault().getBundle().getSymbolicName());
        }
        return this.trace;
    }

    public void error(Throwable throwable, String string) {
        this.getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), string, throwable));
    }

    private synchronized ILog getLog() {
        if (this.log == null) {
            this.log = Platform.getLog((Bundle)Activator.getDefault().getBundle());
        }
        return this.log;
    }

    public void info(Throwable throwable, String string) {
        this.getLog().log((IStatus)new Status(1, Activator.getDefault().getBundle().getSymbolicName(), string, throwable));
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void trace(Throwable throwable, String string) {
        this.getTrace().trace(null, string, throwable);
    }

    public void warn(Throwable throwable, String string) {
        this.getLog().log((IStatus)new Status(2, Activator.getDefault().getBundle().getSymbolicName(), string, throwable));
    }
}

