/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.ApplicationPackage;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.workbench.ui.renderers.PartFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartRenderer {
    private final List partFactories = new ArrayList();
    public static final String FACTORY = "partFactory";
    private final IContributionFactory contributionFactory;
    private final IEclipseContext context;

    public PartRenderer(IContributionFactory iContributionFactory, IEclipseContext iEclipseContext) {
        this.contributionFactory = iContributionFactory;
        this.context = iEclipseContext;
    }

    public void addPartFactory(PartFactory partFactory) {
        this.partFactories.add(partFactory);
    }

    public Object createGui(MPart mPart) {
        if (!mPart.isVisible()) {
            return null;
        }
        Object object = this.createWidget(mPart);
        if (object != null) {
            mPart.setWidget(object);
            PartFactory partFactory = this.getFactoryFor(mPart);
            partFactory.bindWidget(mPart, object);
            this.hookControllerLogic(mPart);
            partFactory.processContents(mPart);
            partFactory.postProcess(mPart);
            if (mPart.getParent() instanceof MPart) {
                MPart mPart2 = mPart.getParent();
                PartFactory partFactory2 = this.getFactoryFor(mPart2);
                partFactory2.childAdded(mPart2, mPart);
            }
        }
        return object;
    }

    protected Object createWidget(MPart mPart) {
        for (PartFactory partFactory : this.partFactories) {
            Object object = partFactory.createWidget(mPart);
            if (object == null) continue;
            this.setFactoryFor(mPart, partFactory);
            this.processHandlers(mPart);
            if (mPart.getMenu() != null) {
                partFactory.createMenu(mPart, object, mPart.getMenu());
            }
            if (mPart.getToolBar() != null) {
                partFactory.createToolBar(mPart, object, mPart.getToolBar());
            }
            return object;
        }
        return null;
    }

    protected void processHandlers(MPart<?> mPart) {
        for (MHandler mHandler : mPart.getHandlers()) {
            mHandler.setObject(this.contributionFactory.create(mHandler.getURI(), this.context));
        }
    }

    private void hookControllerLogic(MPart<?> mPart) {
        PartFactory partFactory = this.getFactoryFor(mPart);
        if (partFactory != null) {
            partFactory.hookControllerLogic(mPart);
        }
        mPart.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (ApplicationPackage.Literals.MPART__CHILDREN.equals(notification.getFeature()) && notification.getEventType() == 3) {
                    MPart mPart = (MPart)notification.getNotifier();
                    PartFactory partFactory = PartRenderer.this.getFactoryFor(mPart);
                    if (partFactory == null) {
                        return;
                    }
                    MPart mPart2 = (MPart)notification.getNewValue();
                    partFactory.childAdded(mPart, mPart2);
                }
            }
        });
        mPart.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (ApplicationPackage.Literals.MPART__CHILDREN.equals(notification.getFeature()) && notification.getEventType() == 4) {
                    MPart mPart = (MPart)notification.getNotifier();
                    PartFactory partFactory = PartRenderer.this.getFactoryFor(mPart);
                    if (partFactory == null) {
                        return;
                    }
                    MPart mPart2 = (MPart)notification.getOldValue();
                    partFactory.childRemoved(mPart, mPart2);
                }
            }
        });
    }

    protected void setFactoryFor(MPart mPart, PartFactory partFactory) {
        mPart.setOwner((Object)partFactory);
    }

    protected PartFactory getFactoryFor(MPart mPart) {
        return (PartFactory)mPart.getOwner();
    }
}

