/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.internal.context.EclipseContext;

abstract class Computation {
    Map dependencies = new HashMap();

    Computation() {
    }

    final void clear(IEclipseContext iEclipseContext, String string) {
        this.doClear();
        this.stopListening(iEclipseContext, string);
    }

    private void stopListening(IEclipseContext iEclipseContext, String string) {
        if (EclipseContext.DEBUG) {
            System.out.println(String.valueOf(this.toString()) + " no longer listening");
        }
        if (string == null) {
            this.dependencies.remove(iEclipseContext);
            return;
        }
        Set set = (Set)this.dependencies.get(iEclipseContext);
        if (set != null) {
            ((EclipseContext)iEclipseContext).listeners.remove(this);
            set.remove(string);
        }
    }

    protected void doClear() {
    }

    protected void doHandleInvalid(IEclipseContext iEclipseContext, String string, int n) {
    }

    final void handleInvalid(IEclipseContext iEclipseContext, String string, int n) {
        Set set = (Set)this.dependencies.get(iEclipseContext);
        if (string == null && n == 3) {
            this.clear(iEclipseContext, null);
            this.doHandleInvalid(iEclipseContext, null, n);
        } else if (set != null && set.contains(string)) {
            this.clear(iEclipseContext, string);
            this.doHandleInvalid(iEclipseContext, string, n);
        }
    }

    void startListening() {
        if (EclipseContext.DEBUG) {
            System.out.println(String.valueOf(this.toString()) + " now listening to: " + this.mapToString(this.dependencies));
        }
        Iterator iterator = this.dependencies.keySet().iterator();
        while (iterator.hasNext()) {
            EclipseContext eclipseContext = (EclipseContext)iterator.next();
            eclipseContext.listeners.add(this);
        }
    }

    private String mapToString(Map map) {
        StringBuffer stringBuffer = new StringBuffer(123);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append("->(");
            Set set = (Set)entry.getValue();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                stringBuffer.append(string);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    void addDependency(IEclipseContext iEclipseContext, String string) {
        HashSet<String> hashSet = (HashSet<String>)this.dependencies.get(iEclipseContext);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            this.dependencies.put(iEclipseContext, hashSet);
        }
        hashSet.add(string);
    }
}

