/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.IContextConstants;
import org.eclipse.e4.core.services.context.spi.IRunAndTrack;

public class ContextToObjectLink
implements IRunAndTrack,
IContextConstants {
    private static final String JAVA_OBJECT = "java.lang.Object";
    protected final String fieldPrefix;
    protected final String setMethodPrefix;
    protected final int fieldPrefixLength;
    protected IEclipseContext context;
    protected List userObjects = new ArrayList(3);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ContextToObjectLink(IEclipseContext iEclipseContext, String string, String string2) {
        this.context = iEclipseContext;
        this.fieldPrefix = string != null ? string : "di_";
        this.setMethodPrefix = string2 != null ? string2 : "set";
        this.fieldPrefixLength = this.fieldPrefix.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notify(final IEclipseContext iEclipseContext, final String string, final int n, final Object[] objectArray) {
        Object object;
        if (n == 3) {
            Iterator iterator = this.userObjects.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                this.findAndCallDispose(object, object.getClass());
            }
        }
        boolean bl = n == 1;
        object = new Processor(bl){

            void processField(Field field, String string3, boolean bl) {
                switch (n) {
                    case 0: {
                        String string2 = ContextToObjectLink.this.findKey(string3, field.getType());
                        if (string2 != null) {
                            ContextToObjectLink.this.setField(objectArray[0], field, iEclipseContext.get(string2));
                            break;
                        }
                        if (bl) break;
                        throw new IllegalStateException("Could not set " + field + " because of missing: " + string3);
                    }
                    case 1: {
                        if (!ContextToObjectLink.this.keyMatches(string, string3)) break;
                        ContextToObjectLink.this.setField(this.userObject, field, iEclipseContext.get(ContextToObjectLink.this.findKey(string, field.getType())));
                        break;
                    }
                    case 2: {
                        if (!ContextToObjectLink.this.keyMatches(string, string3)) break;
                        ContextToObjectLink.this.setField(this.userObject, field, null);
                        break;
                    }
                    default: {
                        ContextToObjectLink.this.logWarning(this.userObject, new IllegalArgumentException("Unknown event type: " + n));
                    }
                }
            }

            void processMethod(Method method, boolean bl) {
                String string3 = method.getName();
                switch (n) {
                    case 0: {
                        String string2 = ContextToObjectLink.this.findKey(string3.substring("set".length()), method.getParameterTypes()[0]);
                        if (string2 != null) {
                            ContextToObjectLink.this.setMethod(objectArray[0], method, iEclipseContext.get(string2, method.getParameterTypes()));
                            break;
                        }
                        if (bl) break;
                        throw new IllegalStateException("Could not invoke " + method + " because of missing: " + string3);
                    }
                    case 1: {
                        if (!ContextToObjectLink.this.keyMatches(string, string3.substring("set".length()))) break;
                        ContextToObjectLink.this.setMethod(this.userObject, method, iEclipseContext.get(ContextToObjectLink.this.findKey(string, method.getParameterTypes()[0]), method.getParameterTypes()));
                        break;
                    }
                    case 2: {
                        if (!ContextToObjectLink.this.keyMatches(string, string3.substring("set".length()))) break;
                        ContextToObjectLink.this.setMethod(this.userObject, method, null);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        ContextToObjectLink.this.logWarning(this.userObject, new IllegalArgumentException("Unknown event type: " + n));
                    }
                }
            }

            void processPostConstructMethod(Method method) {
                block7: {
                    if (n == 0) {
                        try {
                            if (!method.isAccessible()) {
                                method.setAccessible(true);
                                try {
                                    method.invoke(this.userObject, new Object[0]);
                                    break block7;
                                }
                                finally {
                                    method.setAccessible(false);
                                }
                            }
                            method.invoke(this.userObject, new Object[0]);
                        }
                        catch (Exception exception) {
                            ContextToObjectLink.this.logWarning(this.userObject, exception);
                        }
                    }
                }
            }

            public void processOutMethod(Method method, String string2) {
                IEclipseContext iEclipseContext2 = (IEclipseContext)iEclipseContext.get("outputs");
                if (iEclipseContext2 == null) {
                    throw new IllegalStateException("No output context available for @Out " + method + " in " + this.userObject);
                }
                if (n == 0) {
                    try {
                        Object object;
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                            try {
                                object = method.invoke(this.userObject, new Object[0]);
                            }
                            finally {
                                method.setAccessible(false);
                            }
                        } else {
                            object = method.invoke(this.userObject, new Object[0]);
                        }
                        iEclipseContext2.set(string2, object);
                        Class<?> clazz = this.userObject.getClass();
                        Class[] classArray = new Class[2];
                        Class<?> clazz2 = class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$0 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz2;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$1 = Class.forName("java.beans.PropertyChangeListener");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[1] = clazz3;
                        clazz.getMethod("addPropertyChangeListener", classArray).invoke(this.userObject, string2, new PropertyChangeListenerImplementation(string2, iEclipseContext2));
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            }
        };
        if (n == 0) {
            if (objectArray == null || objectArray.length == 0 || objectArray[0] == null) {
                throw new IllegalArgumentException();
            }
            Object object2 = objectArray[0];
            ((Processor)object).setObject(object2);
            this.walkClassHierarchy(object2.getClass(), (Processor)object);
            WeakReference weakReference = new WeakReference(object2){};
            List list = this.userObjects;
            synchronized (list) {
                this.userObjects.add(weakReference);
            }
        } else {
            Object[] objectArray2 = this.safeObjectsCopy();
            int n2 = 0;
            while (n2 < objectArray2.length) {
                Object object3 = objectArray2[n2];
                ((Processor)object).setObject(object3);
                this.walkClassHierarchy(object3.getClass(), (Processor)object);
                ++n2;
            }
        }
        return !this.userObjects.isEmpty();
    }

    private void findAndCallDispose(Object object, Class clazz) {
        Method method;
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            method = methodArray[n];
            try {
                Object[] objectArray = (Object[])method.getClass().getMethod("getAnnotations", new Class[0]).invoke((Object)method, new Object[0]);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    Object object2 = objectArray[n2];
                    try {
                        String string = ((Class)object2.getClass().getMethod("annotationType", new Class[0]).invoke(object2, new Object[0])).getName();
                        if (string.endsWith(".PreDestroy")) {
                            this.callDispose(object, method);
                            return;
                        }
                    }
                    catch (Exception exception) {
                        this.logWarning(method, exception);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        n = 0;
        while (n < methodArray.length) {
            method = methodArray[n];
            if (method.getName().equals("dispose")) {
                this.callDispose(object, method);
                return;
            }
            ++n;
        }
        Class clazz2 = clazz.getSuperclass();
        if (!clazz2.getName().equals(JAVA_OBJECT)) {
            this.findAndCallDispose(object, clazz2);
        }
    }

    private void callDispose(Object object, Method method) {
        block6: {
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                    try {
                        method.invoke(object, new Object[0]);
                        break block6;
                    }
                    finally {
                        method.setAccessible(false);
                    }
                }
                method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                this.logWarning(object, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] safeObjectsCopy() {
        int n = 0;
        Object[] objectArray = this.userObjects;
        synchronized (this.userObjects) {
            Object[] objectArray2 = new Object[this.userObjects.size()];
            Iterator iterator = this.userObjects.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                Object t = weakReference.get();
                if (t == null) {
                    iterator.remove();
                    continue;
                }
                objectArray2[n] = t;
                ++n;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (n == objectArray2.length) {
                return objectArray2;
            }
            objectArray = new Object[n];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            return objectArray;
        }
    }

    private void walkClassHierarchy(Class clazz, Processor processor) {
        Method method;
        ProcessMethodsResult processMethodsResult;
        Class clazz2 = clazz.getSuperclass();
        if (!clazz2.getName().equals(JAVA_OBJECT)) {
            this.walkClassHierarchy(clazz2, processor);
        }
        if (processor.isSetter) {
            this.processFields(clazz, processor);
            processMethodsResult = this.processMethods(clazz, processor);
        } else {
            processMethodsResult = this.processMethods(clazz, processor);
            this.processFields(clazz, processor);
        }
        Iterator iterator = processMethodsResult.postConstructMethods.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            processor.processPostConstructMethod(method);
        }
        iterator = processMethodsResult.outMethods.iterator();
        while (iterator.hasNext()) {
            char c;
            method = (Method)iterator.next();
            String string = method.getName();
            if (string.startsWith("get") && string.length() > 3 && Character.isUpperCase(c = (string = string.substring(3)).charAt(0))) {
                c = Character.toLowerCase(c);
                string = string.length() == 1 ? Character.toString(c) : String.valueOf(Character.toString(c)) + string.substring(1);
            }
            processor.processOutMethod(method, string);
        }
    }

    private ProcessMethodsResult processMethods(Class clazz, Processor processor) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ProcessMethodsResult processMethodsResult = new ProcessMethodsResult();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = method.getName();
            boolean bl = string.startsWith(this.setMethodPrefix);
            boolean bl2 = false;
            try {
                Object[] objectArray = (Object[])method.getClass().getMethod("getAnnotations", new Class[0]).invoke((Object)method, new Object[0]);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    Object object = objectArray[n2];
                    try {
                        String string2 = ((Class)object.getClass().getMethod("annotationType", new Class[0]).invoke(object, new Object[0])).getName();
                        if (string2.endsWith(".Inject") || string2.endsWith(".In")) {
                            bl = true;
                            try {
                                bl2 = (Boolean)object.getClass().getMethod("optional", new Class[0]).invoke(object, new Object[0]);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else if (string2.endsWith(".PostConstruct")) {
                            bl = false;
                            processMethodsResult.postConstructMethods.add(method);
                        } else if (string2.endsWith(".Out")) {
                            bl = false;
                            processMethodsResult.outMethods.add(method);
                        } else {
                            string2.endsWith(".PreDestroy");
                        }
                    }
                    catch (Exception exception) {
                        this.logWarning(method, exception);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
            if (bl) {
                processor.processMethod(method, bl2);
            }
            ++n;
        }
        return processMethodsResult;
    }

    private void processFields(Class clazz, Processor processor) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            String string = field.getName();
            boolean bl = false;
            boolean bl2 = false;
            try {
                Object[] objectArray = (Object[])field.getClass().getMethod("getAnnotations", new Class[0]).invoke((Object)field, new Object[0]);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    block17: {
                        Object object = objectArray[n2];
                        try {
                            String string2 = ((Class)object.getClass().getMethod("annotationType", new Class[0]).invoke(object, new Object[0])).getName();
                            if (string2.endsWith(".Inject") || string2.endsWith(".In")) {
                                bl = true;
                                try {
                                    bl2 = (Boolean)object.getClass().getMethod("optional", new Class[0]).invoke(object, new Object[0]);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                break block17;
                            }
                            if (string2.endsWith(".Named")) {
                                try {
                                    string = (String)object.getClass().getMethod("value", new Class[0]).invoke(object, new Object[0]);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                break block17;
                            }
                            if (!string2.endsWith(".Resource")) break block17;
                            bl = true;
                            String string3 = null;
                            try {
                                string3 = (String)object.getClass().getMethod("name", new Class[0]).invoke(object, new Object[0]);
                            }
                            catch (Exception exception) {
                                this.logWarning(field, exception);
                            }
                            if (string3 != null && !string3.equals("")) {
                                string = string3;
                            }
                        }
                        catch (Exception exception) {
                            this.logWarning(field, exception);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {}
            if (!bl && string.startsWith(this.fieldPrefix)) {
                bl = true;
                string = string.substring(this.fieldPrefixLength);
            }
            if (bl) {
                processor.processField(field, string, bl2);
            }
            ++n;
        }
    }

    protected String findKey(String string, Class clazz) {
        if (this.context.containsKey(string)) {
            return string;
        }
        String string2 = this.altKey(string);
        if (string2 != null && this.context.containsKey(string2)) {
            return string2;
        }
        if (this.context.containsKey(clazz.getName())) {
            return clazz.getName();
        }
        return null;
    }

    protected boolean keyMatches(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        if (string.equals(string2)) {
            return true;
        }
        String string3 = this.altKey(string2);
        if (string3 == null) {
            return false;
        }
        return string.equals(string3);
    }

    protected String altKey(String string) {
        if (string.length() == 0) {
            return null;
        }
        char c = string.charAt(0);
        String string2 = null;
        if (Character.isUpperCase(c)) {
            c = Character.toLowerCase(c);
            string2 = string.length() == 1 ? Character.toString(c) : String.valueOf(Character.toString(c)) + string.substring(1);
        } else if (Character.isLowerCase(c)) {
            c = Character.toUpperCase(c);
            string2 = string.length() == 1 ? Character.toString(c) : String.valueOf(Character.toString(c)) + string.substring(1);
        }
        return string2;
    }

    protected boolean setField(Object object, Field field, Object object2) {
        if (object2 != null && !field.getType().isAssignableFrom(object2.getClass())) {
            return false;
        }
        boolean bl = true;
        if (!field.isAccessible()) {
            field.setAccessible(true);
            bl = false;
        }
        try {
            try {
                field.set(object, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logWarning(field, illegalArgumentException);
                if (!bl) {
                    field.setAccessible(false);
                }
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logWarning(field, illegalAccessException);
                if (!bl) {
                    field.setAccessible(false);
                }
                return false;
            }
        }
        finally {
            if (!bl) {
                field.setAccessible(false);
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    protected boolean setMethod(Object object, Method method, Object object2) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return false;
        }
        if (object2 != null && !classArray[0].isAssignableFrom(object2.getClass())) {
            return false;
        }
        boolean bl = true;
        if (!method.isAccessible()) {
            method.setAccessible(true);
            bl = false;
        }
        try {
            try {
                method.invoke(object, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logWarning(method, illegalArgumentException);
                if (!bl) {
                    method.setAccessible(false);
                }
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logWarning(method, illegalAccessException);
                if (!bl) {
                    method.setAccessible(false);
                }
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logWarning(method, invocationTargetException);
                if (!bl) {
                    method.setAccessible(false);
                }
                return false;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (!bl) {
                method.setAccessible(false);
            }
        }
        return true;
    }

    private void logWarning(Object object, Exception exception) {
        System.out.println("Injection failed " + object.toString());
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    static class ProcessMethodsResult {
        List postConstructMethods = new ArrayList();
        List outMethods = new ArrayList();

        ProcessMethodsResult() {
        }
    }

    private abstract class Processor {
        protected boolean isSetter;
        protected Object userObject;

        public Processor(boolean bl) {
            this.isSetter = bl;
        }

        public void setObject(Object object) {
            this.userObject = object;
        }

        abstract void processMethod(Method var1, boolean var2);

        abstract void processField(Field var1, String var2, boolean var3);

        abstract void processPostConstructMethod(Method var1);

        public abstract void processOutMethod(Method var1, String var2);
    }

    private static class PropertyChangeListenerImplementation
    implements PropertyChangeListener {
        private final String name;
        private final IEclipseContext outputContext;

        private PropertyChangeListenerImplementation(String string, IEclipseContext iEclipseContext) {
            this.name = string;
            this.outputContext = iEclipseContext;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.outputContext.set(this.name, propertyChangeEvent.getNewValue());
        }
    }
}

