/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.core.services.context.IComputedValue;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.IEclipseContextScheduler;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.core.services.context.spi.IRunAndTrack;
import org.eclipse.e4.core.services.internal.context.Computation;
import org.eclipse.e4.core.services.internal.context.ValueComputation;

public class EclipseContext
implements IEclipseContext {
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private IEclipseContextStrategy strategy;
    public static boolean DEBUG = false;
    static ThreadLocal currentComputation = new ThreadLocal();
    Set listeners = new HashSet();
    Map localValues = new HashMap();
    Map localValueComputations = new HashMap();
    IEclipseContext parent;

    public EclipseContext(IEclipseContext iEclipseContext, IEclipseContextStrategy iEclipseContextStrategy) {
        this.parent = iEclipseContext;
        this.strategy = iEclipseContextStrategy;
        this.set("DEBUG_STRING", "Anonymous Context");
    }

    protected void schedule(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.strategy != null && this.strategy instanceof IEclipseContextScheduler) {
            ((IEclipseContextScheduler)this.strategy).schedule(runnable);
        } else {
            runnable.run();
        }
    }

    protected boolean schedule(IRunAndTrack iRunAndTrack, String string, int n, Object[] objectArray) {
        if (iRunAndTrack == null) {
            return false;
        }
        if (n != 0 && n != 3 && this.strategy != null && this.strategy instanceof IEclipseContextScheduler) {
            return ((IEclipseContextScheduler)this.strategy).schedule(this, iRunAndTrack, string, n, objectArray);
        }
        return iRunAndTrack.notify(this, string, n, objectArray);
    }

    public Object getLocal(String string) {
        return this.internalGet(this, string, null, true);
    }

    public Object get(String string) {
        return this.internalGet(this, string, NO_ARGUMENTS, false);
    }

    public Object get(String string, Object[] objectArray) {
        return this.internalGet(this, string, objectArray, false);
    }

    protected Object internalGet(EclipseContext eclipseContext, String string, Object[] objectArray, boolean bl) {
        Object object;
        this.trackAccess(string);
        LookupKey lookupKey = new LookupKey(string, objectArray);
        if (this == eclipseContext && (object = (ValueComputation)this.localValueComputations.get(lookupKey)) != null) {
            return ((ValueComputation)object).get(objectArray);
        }
        object = this.localValues.get(string);
        if (object != null) {
            if (object instanceof IComputedValue) {
                if (DEBUG) {
                    System.out.println("creating new value computation for " + string + " in " + this + " from " + eclipseContext);
                }
                ValueComputation valueComputation = new ValueComputation(this, eclipseContext, string, (IComputedValue)object);
                eclipseContext.localValueComputations.put(lookupKey, valueComputation);
                object = valueComputation.get(objectArray);
            }
            return object;
        }
        if (!bl && this.parent != null) {
            return ((EclipseContext)this.parent).internalGet(eclipseContext, string, objectArray, bl);
        }
        return null;
    }

    protected void invalidate(String string, int n) {
        if (DEBUG) {
            System.out.println("invalidating " + this.get("DEBUG_STRING") + ',' + string);
        }
        this.localValueComputations.remove(string);
        Computation[] computationArray = this.listeners.toArray(new Computation[this.listeners.size()]);
        int n2 = 0;
        while (n2 < computationArray.length) {
            computationArray[n2].handleInvalid(this, string, n);
            ++n2;
        }
    }

    public boolean containsKey(String string) {
        return this.isSetLocally(string) || this.parent != null && this.parent.containsKey(string);
    }

    private boolean isSetLocally(String string) {
        this.trackAccess(string);
        return this.localValues.containsKey(string);
    }

    public void runAndTrack(Runnable runnable, String string) {
        TrackableComputation trackableComputation = new TrackableComputation(runnable, string);
        this.schedule(trackableComputation);
    }

    public void runAndTrack(IRunAndTrack iRunAndTrack, Object[] objectArray) {
        TrackableComputationExt trackableComputationExt = new TrackableComputationExt(iRunAndTrack);
        this.schedule(trackableComputationExt, null, 0, objectArray);
    }

    public void set(String string, Object object) {
        this.localValues.put(string, object);
        Object v = this.localValueComputations.remove(string);
        if (v instanceof ValueComputation) {
            ValueComputation valueComputation = (ValueComputation)v;
            valueComputation.clear(this, string);
        }
        this.invalidate(string, 1);
    }

    private void trackAccess(String string) {
        Computation computation = (Computation)currentComputation.get();
        if (computation != null) {
            computation.addDependency(this, string);
        }
    }

    public void remove(String string) {
        if (this.isSetLocally(string)) {
            this.localValues.remove(string);
            Object v = this.localValueComputations.remove(string);
            if (v instanceof ValueComputation) {
                ValueComputation valueComputation = (ValueComputation)v;
                valueComputation.clear(this, string);
            }
            this.invalidate(string, 2);
        }
    }

    public String toString() {
        return (String)this.get("DEBUG_STRING");
    }

    public void dispose() {
        Computation[] computationArray = this.listeners.toArray(new Computation[this.listeners.size()]);
        int n = 0;
        while (n < computationArray.length) {
            computationArray[n].handleInvalid(this, null, 3);
            ++n;
        }
    }

    static class LookupKey {
        String name;
        Object[] arguments;

        public LookupKey(String string, Object[] objectArray) {
            this.name = string;
            this.arguments = objectArray;
        }

        public int hashCode() {
            int n = 1;
            n *= 31;
            if (this.arguments != null) {
                int n2 = 0;
                while (n2 < this.arguments.length) {
                    Object object = this.arguments[n2];
                    n = 31 * n + (object == null ? 0 : object.hashCode());
                    ++n2;
                }
            }
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            LookupKey lookupKey = (LookupKey)object;
            if (!Arrays.equals(this.arguments, lookupKey.arguments)) {
                return false;
            }
            return !(this.name == null ? lookupKey.name != null : !this.name.equals(lookupKey.name));
        }
    }

    static class TrackableComputation
    extends Computation
    implements Runnable {
        Runnable runnable;
        private final String name;

        TrackableComputation(Runnable runnable, String string) {
            this.runnable = runnable;
            this.name = string;
        }

        protected final void doHandleInvalid(IEclipseContext iEclipseContext, String string, int n) {
            if (n == 3) {
                return;
            }
            if (DEBUG) {
                System.out.println("scheduling " + this.toString());
            }
            ((EclipseContext)iEclipseContext).schedule(this);
        }

        public void run() {
            Computation computation = (Computation)currentComputation.get();
            currentComputation.set(this);
            try {
                this.runnable.run();
            }
            finally {
                currentComputation.set(computation);
            }
            this.startListening();
        }

        public String toString() {
            return this.name;
        }
    }

    static class TrackableComputationExt
    extends Computation
    implements IRunAndTrack {
        private IRunAndTrack runnable;

        public TrackableComputationExt(IRunAndTrack iRunAndTrack) {
            this.runnable = iRunAndTrack;
        }

        protected final void doHandleInvalid(IEclipseContext iEclipseContext, String string, int n) {
            ((EclipseContext)iEclipseContext).schedule(this, string, n, null);
        }

        public boolean notify(IEclipseContext iEclipseContext, String string, int n, Object[] objectArray) {
            Computation computation = (Computation)currentComputation.get();
            currentComputation.set(this);
            boolean bl = true;
            try {
                bl = this.runnable.notify(iEclipseContext, string, n, objectArray);
            }
            finally {
                currentComputation.set(computation);
            }
            this.startListening();
            return bl;
        }
    }
}

