/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.services.internal.context;

import org.eclipse.e4.core.services.context.IComputedValue;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.internal.context.Computation;
import org.eclipse.e4.core.services.internal.context.EclipseContext;

public class ValueComputation
extends Computation {
    Object cachedValue;
    IEclipseContext context;
    String name;
    boolean valid;
    IComputedValue computedValue;
    EclipseContext originatingContext;
    private boolean computing;

    public ValueComputation(IEclipseContext iEclipseContext, IEclipseContext iEclipseContext2, String string, IComputedValue iComputedValue) {
        this.context = iEclipseContext;
        this.originatingContext = (EclipseContext)iEclipseContext2;
        this.name = string;
        this.computedValue = iComputedValue;
    }

    protected final void doClear() {
        this.valid = false;
        this.cachedValue = null;
    }

    protected final void doHandleInvalid(IEclipseContext iEclipseContext, String string, int n) {
        this.originatingContext.invalidate(this.name, n == 3 ? 2 : n);
    }

    final Object get(Object[] objectArray) {
        if (this.valid) {
            return this.cachedValue;
        }
        if (this.computing) {
            throw new CycleException(this.toString());
        }
        Computation computation = (Computation)EclipseContext.currentComputation.get();
        EclipseContext.currentComputation.set(this);
        this.computing = true;
        try {
            try {
                this.cachedValue = this.computedValue.compute(this.originatingContext, objectArray);
                this.valid = true;
            }
            catch (CycleException cycleException) {
                throw new CycleException(String.valueOf(cycleException.getCycleMessage()) + "\n" + this.toString());
            }
        }
        finally {
            this.computing = false;
            EclipseContext.currentComputation.set(computation);
        }
        this.startListening();
        return this.cachedValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VC(");
        stringBuffer.append(this.context);
        stringBuffer.append(',');
        stringBuffer.append(this.name);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static class CycleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final String cycleMessage;

        CycleException(String string) {
            super("cycle while computing value");
            this.cycleMessage = string;
        }

        String getCycleMessage() {
            return this.cycleMessage;
        }

        public String toString() {
            return "\n" + this.cycleMessage + "\n";
        }
    }
}

