/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.core.services.osgi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.internal.context.EclipseContext;
import org.eclipse.e4.core.services.osgi.IServiceAliasRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class OSGiServiceContext
extends EclipseContext
implements IDisposable,
ServiceTrackerCustomizer {
    private final BundleContext bundleContext;
    private final ServiceTracker aliasRegistryTracker;
    private Map services = Collections.synchronizedMap(new HashMap());

    public OSGiServiceContext(BundleContext bundleContext) {
        super(null, null);
        this.bundleContext = bundleContext;
        this.aliasRegistryTracker = new ServiceTracker(bundleContext, IServiceAliasRegistry.SERVICE_NAME, null);
        this.set("DEBUG_STRING", "OSGi context for bundle: " + bundleContext.getBundle().getSymbolicName());
        this.aliasRegistryTracker.open();
    }

    public Object addingService(ServiceReference serviceReference) {
        String string = this.serviceName(serviceReference);
        String string2 = this.unresolve(string);
        Object object = this.bundleContext.getService(serviceReference);
        if (object == null) {
            return null;
        }
        ServiceData serviceData = (ServiceData)this.services.get(string2);
        Iterator iterator = serviceData.users.keySet().iterator();
        while (iterator.hasNext()) {
            ((IEclipseContext)iterator.next()).set(string2, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanReferences() {
        Map map = this.services;
        synchronized (map) {
            Iterator iterator = this.services.values().iterator();
            while (iterator.hasNext()) {
                ServiceData serviceData = (ServiceData)iterator.next();
                if (!serviceData.users.isEmpty()) continue;
                serviceData.tracker.close();
                iterator.remove();
                this.remove(serviceData.name);
            }
        }
    }

    public boolean containsKey(String string) {
        this.cleanReferences();
        String string2 = this.unresolve(string);
        String string3 = this.resolve(string);
        return super.containsKey(string2) || this.bundleContext.getServiceReference(string3) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map map = this.services;
        synchronized (map) {
            Iterator iterator = this.services.values().iterator();
            while (iterator.hasNext()) {
                ((ServiceData)iterator.next()).tracker.close();
            }
            this.services.clear();
        }
        this.aliasRegistryTracker.close();
    }

    protected Object internalGet(EclipseContext eclipseContext, String string, Object[] objectArray, boolean bl) {
        this.cleanReferences();
        String string2 = this.unresolve(string);
        String string3 = this.resolve(string);
        Object object = super.internalGet(eclipseContext, string2, objectArray, bl);
        if (object != null) {
            return object;
        }
        ServiceData serviceData = (ServiceData)this.services.get(string2);
        if (serviceData == null) {
            serviceData = new ServiceData(string2);
            serviceData.tracker = new ServiceTracker(this.bundleContext, string3, (ServiceTrackerCustomizer)this);
            this.services.put(string2, serviceData);
            serviceData.tracker.open();
        }
        serviceData.addContext(eclipseContext);
        return serviceData.tracker.getService();
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
        String string = this.serviceName(serviceReference);
        String string2 = this.unresolve(string);
        ServiceData serviceData = (ServiceData)this.services.get(string2);
        Iterator iterator = serviceData.users.keySet().iterator();
        while (iterator.hasNext()) {
            ((IEclipseContext)iterator.next()).set(string2, object);
        }
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        String string = this.serviceName(serviceReference);
        String string2 = this.unresolve(string);
        ServiceData serviceData = (ServiceData)this.services.get(string2);
        Iterator iterator = serviceData.users.keySet().iterator();
        while (iterator.hasNext()) {
            ((IEclipseContext)iterator.next()).set(string2, null);
        }
        this.bundleContext.ungetService(serviceReference);
    }

    private String unresolve(String string) {
        IServiceAliasRegistry iServiceAliasRegistry = (IServiceAliasRegistry)this.aliasRegistryTracker.getService();
        return iServiceAliasRegistry == null ? string : iServiceAliasRegistry.findAlias(string);
    }

    private String resolve(String string) {
        IServiceAliasRegistry iServiceAliasRegistry = (IServiceAliasRegistry)this.aliasRegistryTracker.getService();
        return iServiceAliasRegistry == null ? string : iServiceAliasRegistry.resolveAlias(string);
    }

    private String serviceName(ServiceReference serviceReference) {
        return ((String[])serviceReference.getProperty("objectClass"))[0];
    }

    class ServiceData {
        String name;
        ServiceTracker tracker;
        final Map users = new WeakHashMap();

        ServiceData(String string) {
            this.name = string;
        }

        public void addContext(EclipseContext eclipseContext) {
            this.users.put(eclipseContext, null);
        }
    }
}

