/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.as;

import java.io.PrintWriter;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.as.ASCompilerOptions;
import org.eclipse.jdt.internal.compiler.as.ActionScriptSourceGenerator;
import org.eclipse.jdt.internal.compiler.as.FieldNamesRegistry;
import org.eclipse.jdt.internal.compiler.as.IActionScriptSourcesCollector;
import org.eclipse.jdt.internal.compiler.as.ProblemReporter;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;

public class ASCompiler
extends Compiler {
    public IActionScriptSourcesCollector actionScriptSourceFilesCollector;
    private IErrorHandlingPolicy policy;
    private IProblemFactory problemFactory;
    private FieldNamesRegistry fieldNamesRegistry = new FieldNamesRegistry();

    public ASCompiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, ASCompilerOptions aSCompilerOptions, ICompilerRequestor iCompilerRequestor, IActionScriptSourcesCollector iActionScriptSourcesCollector, IProblemFactory iProblemFactory, PrintWriter printWriter) {
        super(iNameEnvironment, iErrorHandlingPolicy, (CompilerOptions)aSCompilerOptions, iCompilerRequestor, iProblemFactory, printWriter, null);
        this.actionScriptSourceFilesCollector = iActionScriptSourcesCollector;
        this.policy = iErrorHandlingPolicy;
        this.problemFactory = iProblemFactory;
        this.initializeParser();
    }

    public void initializeParser() {
        if (this.policy != null) {
            this.problemReporter = new ProblemReporter(this.policy, this.options, this.problemFactory, this.fieldNamesRegistry);
            this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
        }
    }

    public void process(CompilationUnitDeclaration compilationUnitDeclaration, int n) {
        super.process(compilationUnitDeclaration, n);
        if (!compilationUnitDeclaration.hasErrors()) {
            ActionScriptSourceGenerator actionScriptSourceGenerator = new ActionScriptSourceGenerator(this.actionScriptSourceFilesCollector, this.fieldNamesRegistry);
            compilationUnitDeclaration.traverse((ASTVisitor)actionScriptSourceGenerator, compilationUnitDeclaration.scope);
        }
    }
}

