/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.as;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.as.ActionScriptScribe;
import org.eclipse.jdt.internal.compiler.as.ActionScriptSourceGenerator;
import org.eclipse.jdt.internal.compiler.as.ParameterNamesRegistry;
import org.eclipse.jdt.internal.compiler.as.Util;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ActionScriptConstructorGenerator {
    ActionScriptSourceGenerator parent;
    ArrayList constructors = new ArrayList();
    Map bindingToIndex = new HashMap();
    boolean needSuperCall = false;
    int superArgsCount = 0;

    ActionScriptConstructorGenerator(ActionScriptSourceGenerator actionScriptSourceGenerator) {
        this.parent = actionScriptSourceGenerator;
    }

    void add(ConstructorDeclaration constructorDeclaration) {
        this.constructors.add(constructorDeclaration);
        this.bindingToIndex.put(constructorDeclaration.binding, new Integer(this.constructors.size() - 1));
    }

    void generate() {
        MethodBinding methodBinding;
        int n = this.constructors.size();
        if (n < 2) {
            return;
        }
        ActionScriptScribe actionScriptScribe = this.parent.scriptOutput;
        ReferenceBinding referenceBinding = ((ConstructorDeclaration)this.constructors.get((int)0)).binding.declaringClass;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = referenceBinding.isNestedType() ? ((NestedTypeBinding)referenceBinding).syntheticEnclosingInstances() : null;
        int n2 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        this.parent.printIndent();
        actionScriptScribe.append("public function ");
        Util.appendTypeName(actionScriptScribe, (TypeBinding)referenceBinding, false);
        actionScriptScribe.append("(... vargs) {").appendNewLine();
        this.parent.indent();
        this.parent.printIndent();
        actionScriptScribe.append("var args: Array;").appendNewLine();
        this.parent.printIndent();
        actionScriptScribe.append("var id: int;").appendNewLine();
        if (n2 > 0) {
            this.parent.printIndent();
            actionScriptScribe.append("var syntheticCount: int;").appendNewLine();
        }
        this.parent.printIndent();
        actionScriptScribe.append("if (vargs.length == 1 && vargs[0] is Arguments) {").appendNewLine();
        this.parent.indent();
        this.parent.printIndent();
        actionScriptScribe.append("args = Arguments(vargs[0]).args;").appendNewLine();
        this.parent.printIndent();
        actionScriptScribe.append("id = Arguments(vargs[0]).id;").appendNewLine();
        if (n2 > 0) {
            this.parent.printIndent();
            actionScriptScribe.append("syntheticCount = ");
            actionScriptScribe.append(n2);
            actionScriptScribe.append(';').appendNewLine();
        }
        this.parent.outdent();
        this.parent.printIndent();
        actionScriptScribe.append("} else {").appendNewLine();
        this.parent.indent();
        if (n2 > 0) {
            this.parent.printIndent();
            actionScriptScribe.append("syntheticCount = 0;").appendNewLine();
        }
        int n3 = 0;
        while (n3 < n) {
            methodBinding = ((ConstructorDeclaration)this.constructors.get((int)n3)).binding;
            if (n3 == 0) {
                this.parent.printIndent();
            } else {
                actionScriptScribe.append("} else ");
            }
            actionScriptScribe.append("if (vargs.length == ");
            if (methodBinding.parameters == null || methodBinding.parameters.length == 0) {
                actionScriptScribe.append(0);
                actionScriptScribe.append(") {").appendNewLine();
                this.parent.indent();
            } else {
                actionScriptScribe.append(methodBinding.parameters.length);
                this.parent.indent();
                int n4 = 0;
                int n5 = methodBinding.parameters.length;
                while (n4 < n5) {
                    actionScriptScribe.append(" && vargs[");
                    actionScriptScribe.append(n4);
                    actionScriptScribe.append("] is ");
                    TypeBinding typeBinding = methodBinding.parameters[n4];
                    Util.appendTypeName(actionScriptScribe, typeBinding, this.parent.importRegistry.isAmbiguous(typeBinding));
                    ++n4;
                }
                actionScriptScribe.append(") {").appendNewLine();
                this.parent.printIndent();
                actionScriptScribe.append("args = vargs;").appendNewLine();
            }
            this.parent.printIndent();
            actionScriptScribe.append("id = ");
            actionScriptScribe.append(n3);
            actionScriptScribe.append(';').appendNewLine();
            this.parent.outdent();
            this.parent.printIndent();
            ++n3;
        }
        actionScriptScribe.append('}').appendNewLine();
        this.parent.outdent();
        this.parent.printIndent();
        actionScriptScribe.append('}').appendNewLine();
        this.parent.printIndent();
        actionScriptScribe.append("switch (id) {").appendNewLine();
        this.parent.indent();
        n3 = 0;
        while (n3 < n) {
            methodBinding = (ConstructorDeclaration)this.constructors.get(n3);
            this.parent.printIndent();
            actionScriptScribe.append("case ");
            actionScriptScribe.append(n3);
            actionScriptScribe.append(':').appendNewLine();
            this.parent.indent();
            this.generateArguments(actionScriptScribe, (ConstructorDeclaration)methodBinding, n2, n3, null, -1);
            this.parent.printIndent();
            actionScriptScribe.append("break;").appendNewLine();
            this.parent.outdent();
            ++n3;
        }
        this.parent.outdent();
        this.parent.printIndent();
        actionScriptScribe.append('}').appendNewLine();
        if (this.needSuperCall) {
            this.parent.printIndent();
            actionScriptScribe.append("super(");
            switch (this.superArgsCount) {
                case -1: {
                    actionScriptScribe.append("superArgs");
                    break;
                }
                case 0: {
                    if (n2 != 1 || referenceBinding.superclass().id == 1) break;
                    actionScriptScribe.append("args[0]");
                    break;
                }
                default: {
                    actionScriptScribe.append("superArgs[0]");
                    n3 = 1;
                    while (n3 < this.superArgsCount) {
                        actionScriptScribe.append(", superArgs[");
                        actionScriptScribe.append(n3);
                        actionScriptScribe.append(']');
                        ++n3;
                    }
                    break block0;
                }
            }
            actionScriptScribe.append(");").appendNewLine();
        }
        this.parent.printIndent();
        actionScriptScribe.append("switch (id) {").appendNewLine();
        this.parent.indent();
        n3 = 0;
        while (n3 < n) {
            methodBinding = (ConstructorDeclaration)this.constructors.get(n3);
            this.parent.printIndent();
            actionScriptScribe.append("case ");
            actionScriptScribe.append(n3);
            actionScriptScribe.append(':').appendNewLine();
            this.parent.indent();
            this.generateFunctionCalls(actionScriptScribe, (ConstructorDeclaration)methodBinding, n2, n3);
            this.parent.printIndent();
            actionScriptScribe.append("break;").appendNewLine();
            this.parent.outdent();
            ++n3;
        }
        this.parent.outdent();
        this.parent.printIndent();
        actionScriptScribe.append('}').appendNewLine();
        this.parent.outdent();
        this.parent.printIndent();
        actionScriptScribe.append('}').appendNewLine();
        n3 = 0;
        while (n3 < n) {
            methodBinding = (ConstructorDeclaration)this.constructors.get(n3);
            this.parent.printIndent();
            actionScriptScribe.append("public static const ");
            Util.appendMethodName(actionScriptScribe, methodBinding.binding, false, false);
            actionScriptScribe.append(" : int = ");
            Object v = this.bindingToIndex.get(methodBinding.binding);
            if (v == null) {
                this.parent.reportError((Scope)methodBinding.scope, "could not find constructor binding", (ASTNode)methodBinding);
            }
            actionScriptScribe.append(v);
            actionScriptScribe.append(';').appendNewLine();
            ++n3;
        }
    }

    private void generateArguments(ActionScriptScribe actionScriptScribe, ConstructorDeclaration constructorDeclaration, int n, int n2, ExplicitConstructorCall explicitConstructorCall, int n3) {
        ExplicitConstructorCall explicitConstructorCall2;
        int n4;
        int n5;
        int n6 = n + (constructorDeclaration.binding.parameters == null ? 0 : constructorDeclaration.binding.parameters.length);
        if (n6 > 0) {
            this.parent.printIndent();
            if (explicitConstructorCall == null) {
                actionScriptScribe.append("var ");
            }
            actionScriptScribe.append("args");
            actionScriptScribe.append(n2);
            if (explicitConstructorCall == null) {
                actionScriptScribe.append(": Array");
            }
            actionScriptScribe.append(" = [");
            if (explicitConstructorCall == null) {
                actionScriptScribe.append("args[0]");
                int n7 = 1;
                while (n7 < n6) {
                    actionScriptScribe.append(", args[");
                    actionScriptScribe.append(n7);
                    actionScriptScribe.append(']');
                    ++n7;
                }
            } else {
                this.parent.localNamesRegistry = new ParameterNamesRegistry((ConstructorDeclaration)this.constructors.get(n3), n3);
                Expression[] expressionArray = explicitConstructorCall.arguments;
                expressionArray[0].traverse((ASTVisitor)this.parent, (BlockScope)constructorDeclaration.scope);
                n5 = 1;
                n4 = expressionArray.length;
                while (n5 < n4) {
                    actionScriptScribe.append(", ");
                    expressionArray[n5].traverse((ASTVisitor)this.parent, (BlockScope)constructorDeclaration.scope);
                    ++n5;
                }
            }
            actionScriptScribe.append("];").appendNewLine();
        }
        if ((explicitConstructorCall2 = constructorDeclaration.constructorCall) != null) {
            if (explicitConstructorCall2.isSuperAccess()) {
                n5 = explicitConstructorCall2.binding.declaringClass.id == 11 || Util.isSingleConstructor(explicitConstructorCall2.binding) || explicitConstructorCall2.binding.declaringClass.id == 1 || Util.isIntrinsic((TypeBinding)explicitConstructorCall2.binding.declaringClass) ? 0 : 1;
                Expression[] expressionArray = explicitConstructorCall2.arguments;
                int n8 = n6 = expressionArray == null ? 0 : expressionArray.length;
                if (!this.needSuperCall) {
                    this.needSuperCall = true;
                    if (n5 != 0) {
                        this.parent.printIndent();
                        actionScriptScribe.append("var superArgs: Arguments;").appendNewLine();
                    } else if (n6 > 0) {
                        this.parent.printIndent();
                        actionScriptScribe.append("var superArgs: Array;").appendNewLine();
                    }
                }
                if (n5 != 0 || n6 > 0) {
                    this.parent.printIndent();
                    actionScriptScribe.append("superArgs = ");
                }
                if (n5 != 0) {
                    actionScriptScribe.append("new Arguments(");
                    Util.dumpConstructorFieldReference(actionScriptScribe, explicitConstructorCall2.binding);
                    actionScriptScribe.append(", [");
                } else if (n6 > 0) {
                    actionScriptScribe.append('[');
                }
                if (n6 > 0) {
                    this.parent.localNamesRegistry = new ParameterNamesRegistry(constructorDeclaration, n2);
                    expressionArray[0].traverse((ASTVisitor)this.parent, (BlockScope)constructorDeclaration.scope);
                    int n9 = 1;
                    while (n9 < n6) {
                        actionScriptScribe.append(", ");
                        expressionArray[n9].traverse((ASTVisitor)this.parent, (BlockScope)constructorDeclaration.scope);
                        ++n9;
                    }
                }
                if (n5 != 0) {
                    this.superArgsCount = -1;
                    actionScriptScribe.append("]);").appendNewLine();
                } else if (n6 > 0) {
                    this.superArgsCount = n6;
                    actionScriptScribe.append("];").appendNewLine();
                }
            } else {
                Object v = this.bindingToIndex.get(explicitConstructorCall2.binding.original());
                if (v == null) {
                    this.parent.reportError((Scope)constructorDeclaration.scope, "could not find constructor binding", (ASTNode)constructorDeclaration);
                } else {
                    n4 = (Integer)v;
                    this.generateArguments(actionScriptScribe, (ConstructorDeclaration)this.constructors.get(n4), n, n4, explicitConstructorCall2, n2);
                }
            }
        }
    }

    private void generateFunctionCalls(ActionScriptScribe actionScriptScribe, ConstructorDeclaration constructorDeclaration, int n, int n2) {
        int n3;
        Object object;
        int n4 = n + (constructorDeclaration.binding.parameters == null ? 0 : constructorDeclaration.binding.parameters.length);
        if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isSuperAccess()) {
            object = (Integer)this.bindingToIndex.get(constructorDeclaration.constructorCall.binding.original());
            if (object == null) {
                this.parent.reportError((Scope)constructorDeclaration.scope, "could not find constructor binding", (ASTNode)constructorDeclaration);
                return;
            }
            n3 = (Integer)object;
            this.generateFunctionCalls(actionScriptScribe, (ConstructorDeclaration)this.constructors.get(n3), n, n3);
        }
        this.parent.printIndent();
        Util.appendMethodName(actionScriptScribe, constructorDeclaration.binding, false, false);
        actionScriptScribe.append('(');
        if (n4 > 0) {
            object = "args" + n2;
            actionScriptScribe.append((String)object);
            actionScriptScribe.append("[0]");
            n3 = 1;
            while (n3 < n4) {
                actionScriptScribe.append(", ");
                actionScriptScribe.append((String)object);
                actionScriptScribe.append('[');
                actionScriptScribe.append(n3);
                actionScriptScribe.append(']');
                ++n3;
            }
        }
        actionScriptScribe.append(");").appendNewLine();
    }
}

